/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import io.confluent.kafka.serializers.context.strategy.ContextNameStrategy;
import java.util.HashMap;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.junit.Assert;
import org.junit.Test;

public class ContextNameStrategyTest {
    private final String topic;
    private final String topic2;
    private final SchemaRegistryClient schemaRegistry = new MockSchemaRegistryClient();
    private final KafkaAvroSerializer avroSerializer1;
    private final KafkaAvroDeserializer avroDeserializer1;
    private final KafkaAvroSerializer avroSerializer2;
    private final KafkaAvroSerializer avroSerializer3;
    private final KafkaAvroSerializer avroSerializer4;

    public ContextNameStrategyTest() {
        this.topic = "test";
        this.topic2 = "test2";
        Properties config1 = new Properties();
        config1.put("schema.registry.url", "bogus");
        config1.put("context.name.strategy", CustomContextNameStrategy1.class.getName());
        this.avroSerializer1 = new KafkaAvroSerializer(this.schemaRegistry, new HashMap<Object, Object>(config1));
        this.avroDeserializer1 = new KafkaAvroDeserializer(this.schemaRegistry, new HashMap<Object, Object>(config1));
        Properties config2 = new Properties();
        config2.put("schema.registry.url", "bogus");
        config2.put("context.name.strategy", CustomContextNameStrategy2.class.getName());
        this.avroSerializer2 = new KafkaAvroSerializer(this.schemaRegistry, new HashMap<Object, Object>(config2));
        Properties config3 = new Properties();
        config3.put("schema.registry.url", "bogus");
        config3.put("context.name.strategy", CustomContextNameStrategy3.class.getName());
        this.avroSerializer3 = new KafkaAvroSerializer(this.schemaRegistry, new HashMap<Object, Object>(config3));
        Properties config4 = new Properties();
        config4.put("schema.registry.url", "bogus");
        config4.put("context.name.strategy", CustomContextNameStrategy4.class.getName());
        this.avroSerializer4 = new KafkaAvroSerializer(this.schemaRegistry, new HashMap<Object, Object>(config4));
    }

    private Schema createUserSchema() {
        String userSchema = "{\"namespace\": \"example.avro\", \"type\": \"record\", \"name\": \"User\",\"fields\": [{\"name\": \"name\", \"type\": \"string\"}]}";
        Schema.Parser parser = new Schema.Parser();
        Schema schema = parser.parse(userSchema);
        return schema;
    }

    private IndexedRecord createUserRecord() {
        Schema schema = this.createUserSchema();
        GenericData.Record avroRecord = new GenericData.Record(schema);
        avroRecord.put("name", (Object)"testUser");
        return avroRecord;
    }

    @Test
    public void testCustomContextNameStrategy() {
        Assert.assertEquals((Object)":.customContext_test:", (Object)this.avroSerializer1.getContextName(this.topic));
        Assert.assertEquals((Object)":.customContext_test:subject1", (Object)this.avroSerializer1.getContextName(this.topic, "subject1"));
        Assert.assertEquals((Object)":.customContext_test:", (Object)this.avroSerializer2.getContextName(this.topic));
        Assert.assertEquals((Object)":.customContext_test:subject1", (Object)this.avroSerializer2.getContextName(this.topic, "subject1"));
        Assert.assertEquals((Object)":.customContext_test:", (Object)this.avroSerializer3.getContextName(this.topic));
        Assert.assertEquals((Object)":.customContext_test:subject1", (Object)this.avroSerializer3.getContextName(this.topic, "subject1"));
        Assert.assertEquals((Object)":.customContext_test:", (Object)this.avroSerializer4.getContextName(this.topic));
        Assert.assertEquals((Object)":.customContext_test:subject1", (Object)this.avroSerializer4.getContextName(this.topic, "subject1"));
    }

    @Test
    public void testSerialization() {
        IndexedRecord avroRecord = this.createUserRecord();
        byte[] bytes = this.avroSerializer1.serialize(this.topic, (Object)avroRecord);
        Assert.assertEquals((Object)avroRecord, (Object)this.avroDeserializer1.deserialize(this.topic, bytes));
        bytes = this.avroSerializer1.serialize(this.topic2, (Object)avroRecord);
        Assert.assertEquals((Object)avroRecord, (Object)this.avroDeserializer1.deserialize(this.topic2, bytes));
    }

    public static class CustomContextNameStrategy4
    implements ContextNameStrategy {
        public String contextName(String topic) {
            return ":customContext_" + topic + ":";
        }
    }

    public static class CustomContextNameStrategy3
    implements ContextNameStrategy {
        public String contextName(String topic) {
            return ":.customContext_" + topic + ":";
        }
    }

    public static class CustomContextNameStrategy2
    implements ContextNameStrategy {
        public String contextName(String topic) {
            return ".customContext_" + topic;
        }
    }

    public static class CustomContextNameStrategy1
    implements ContextNameStrategy {
        public String contextName(String topic) {
            return "customContext_" + topic;
        }
    }
}

