/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.collect.ImmutableSet;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils;
import io.confluent.kafka.schemaregistry.client.rest.entities.Metadata;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaEntity;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericEnumSymbol;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.util.Utf8;
import org.junit.Assert;
import org.junit.Test;

public class AvroSchemaTest {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final Schema.Parser parser = new Schema.Parser();
    private static final Schema recordSchema = new Schema.Parser().parse("{\"namespace\": \"namespace\",\n \"type\": \"record\",\n \"name\": \"test\",\n \"fields\": [\n     {\"name\": \"null\", \"type\": \"null\"},\n     {\"name\": \"boolean\", \"type\": \"boolean\"},\n     {\"name\": \"int\", \"type\": \"int\"},\n     {\"name\": \"long\", \"type\": \"long\"},\n     {\"name\": \"float\", \"type\": \"float\"},\n     {\"name\": \"double\", \"type\": \"double\"},\n     {\"name\": \"bytes\", \"type\": \"bytes\"},\n     {\"name\": \"string\", \"type\": \"string\", \"aliases\": [\"string_alias\"]},\n     {\"name\": \"null_default\", \"type\": \"null\", \"default\": null},\n     {\"name\": \"boolean_default\", \"type\": \"boolean\", \"default\": false},\n     {\"name\": \"int_default\", \"type\": \"int\", \"default\": 24},\n     {\"name\": \"long_default\", \"type\": \"long\", \"default\": 4000000000},\n     {\"name\": \"float_default\", \"type\": \"float\", \"default\": 12.3},\n     {\"name\": \"double_default\", \"type\": \"double\", \"default\": 23.2},\n     {\"name\": \"bytes_default\", \"type\": \"bytes\", \"default\": \"bytes\"},\n     {\"name\": \"string_default\", \"type\": \"string\", \"default\": \"default string\"}\n]\n}");
    private static final String recordInvalidDefaultSchema = "{\"namespace\": \"namespace\",\n \"type\": \"record\",\n \"name\": \"test\",\n \"fields\": [\n     {\"name\": \"string_default\", \"type\": \"string\", \"default\": null}\n]\n}";
    private static final Schema recordWithDocSchema = new Schema.Parser().parse("{\"namespace\": \"namespace\",\n \"type\": \"record\",\n \"name\": \"test\",\n \"doc\": \"test\",\n \"fields\": [\n     {\"name\": \"null\", \"type\": \"null\"},\n     {\"name\": \"boolean\", \"type\": \"boolean\"},\n     {\"name\": \"int\", \"type\": \"int\"},\n     {\"name\": \"long\", \"type\": \"long\"},\n     {\"name\": \"float\", \"type\": \"float\"},\n     {\"name\": \"double\", \"type\": \"double\"},\n     {\"name\": \"bytes\", \"type\": \"bytes\"},\n     {\"name\": \"string\", \"type\": \"string\", \"aliases\": [\"string_alias\"]},\n     {\"name\": \"null_default\", \"type\": \"null\", \"default\": null},\n     {\"name\": \"boolean_default\", \"type\": \"boolean\", \"default\": false},\n     {\"name\": \"int_default\", \"type\": \"int\", \"default\": 24},\n     {\"name\": \"long_default\", \"type\": \"long\", \"default\": 4000000000},\n     {\"name\": \"float_default\", \"type\": \"float\", \"default\": 12.3},\n     {\"name\": \"double_default\", \"type\": \"double\", \"default\": 23.2},\n     {\"name\": \"bytes_default\", \"type\": \"bytes\", \"default\": \"bytes\"},\n     {\"name\": \"string_default\", \"type\": \"string\", \"default\": \"default string\"}\n]\n}");
    private static final Schema recordWithAliasesSchema = new Schema.Parser().parse("{\"namespace\": \"namespace\",\n \"type\": \"record\",\n \"name\": \"test\",\n \"aliases\": [\"test\"],\n \"fields\": [\n     {\"name\": \"null\", \"type\": \"null\"},\n     {\"name\": \"boolean\", \"type\": \"boolean\"},\n     {\"name\": \"int\", \"type\": \"int\"},\n     {\"name\": \"long\", \"type\": \"long\"},\n     {\"name\": \"float\", \"type\": \"float\"},\n     {\"name\": \"double\", \"type\": \"double\"},\n     {\"name\": \"bytes\", \"type\": \"bytes\"},\n     {\"name\": \"string\", \"type\": \"string\", \"aliases\": [\"string_alias\"]},\n     {\"name\": \"null_default\", \"type\": \"null\", \"default\": null},\n     {\"name\": \"boolean_default\", \"type\": \"boolean\", \"default\": false},\n     {\"name\": \"int_default\", \"type\": \"int\", \"default\": 24},\n     {\"name\": \"long_default\", \"type\": \"long\", \"default\": 4000000000},\n     {\"name\": \"float_default\", \"type\": \"float\", \"default\": 12.3},\n     {\"name\": \"double_default\", \"type\": \"double\", \"default\": 23.2},\n     {\"name\": \"bytes_default\", \"type\": \"bytes\", \"default\": \"bytes\"},\n     {\"name\": \"string_default\", \"type\": \"string\", \"default\": \"default string\"}\n]\n}");
    private static final Schema recordWithFieldDocSchema = new Schema.Parser().parse("{\"namespace\": \"namespace\",\n \"type\": \"record\",\n \"name\": \"test\",\n \"fields\": [\n     {\"name\": \"null\", \"type\": \"null\", \"doc\": \"test\"},\n     {\"name\": \"boolean\", \"type\": \"boolean\"},\n     {\"name\": \"int\", \"type\": \"int\"},\n     {\"name\": \"long\", \"type\": \"long\"},\n     {\"name\": \"float\", \"type\": \"float\"},\n     {\"name\": \"double\", \"type\": \"double\"},\n     {\"name\": \"bytes\", \"type\": \"bytes\"},\n     {\"name\": \"string\", \"type\": \"string\", \"aliases\": [\"string_alias\"]},\n     {\"name\": \"null_default\", \"type\": \"null\", \"default\": null},\n     {\"name\": \"boolean_default\", \"type\": \"boolean\", \"default\": false},\n     {\"name\": \"int_default\", \"type\": \"int\", \"default\": 24},\n     {\"name\": \"long_default\", \"type\": \"long\", \"default\": 4000000000},\n     {\"name\": \"float_default\", \"type\": \"float\", \"default\": 12.3},\n     {\"name\": \"double_default\", \"type\": \"double\", \"default\": 23.2},\n     {\"name\": \"bytes_default\", \"type\": \"bytes\", \"default\": \"bytes\"},\n     {\"name\": \"string_default\", \"type\": \"string\", \"default\": \"default string\"}\n]\n}");
    private static final Schema recordWithFieldAliasesSchema = new Schema.Parser().parse("{\"namespace\": \"namespace\",\n \"type\": \"record\",\n \"name\": \"test\",\n \"fields\": [\n     {\"name\": \"null\", \"type\": \"null\", \"aliases\": [\"test\"]},\n     {\"name\": \"boolean\", \"type\": \"boolean\"},\n     {\"name\": \"int\", \"type\": \"int\"},\n     {\"name\": \"long\", \"type\": \"long\"},\n     {\"name\": \"float\", \"type\": \"float\"},\n     {\"name\": \"double\", \"type\": \"double\"},\n     {\"name\": \"bytes\", \"type\": \"bytes\"},\n     {\"name\": \"string\", \"type\": \"string\", \"aliases\": [\"string_alias\"]},\n     {\"name\": \"null_default\", \"type\": \"null\", \"default\": null},\n     {\"name\": \"boolean_default\", \"type\": \"boolean\", \"default\": false},\n     {\"name\": \"int_default\", \"type\": \"int\", \"default\": 24},\n     {\"name\": \"long_default\", \"type\": \"long\", \"default\": 4000000000},\n     {\"name\": \"float_default\", \"type\": \"float\", \"default\": 12.3},\n     {\"name\": \"double_default\", \"type\": \"double\", \"default\": 23.2},\n     {\"name\": \"bytes_default\", \"type\": \"bytes\", \"default\": \"bytes\"},\n     {\"name\": \"string_default\", \"type\": \"string\", \"default\": \"default string\"}\n]\n}");
    private static final Schema arraySchema = new Schema.Parser().parse("{\"namespace\": \"namespace\",\n \"type\": \"array\",\n \"name\": \"test\",\n \"items\": \"string\"\n}");
    private static final Schema arraySchemaWithDefault = new Schema.Parser().parse("{\"namespace\": \"namespace\",\n \"type\": \"array\",\n \"name\": \"test\",\n \"items\": \"string\",\n \"default\": []\n}");
    private static final Schema mapSchema = new Schema.Parser().parse("{\"namespace\": \"namespace\",\n \"type\": \"map\",\n \"name\": \"test\",\n \"values\": \"string\"\n}");
    private static final Schema mapSchemaWithDefault = new Schema.Parser().parse("{\"namespace\": \"namespace\",\n \"type\": \"map\",\n \"name\": \"test\",\n \"values\": \"string\",\n \"default\": {}\n}");
    private static final Schema unionSchema = new Schema.Parser().parse("{\"type\": \"record\",\n \"name\": \"test\",\n \"fields\": [\n     {\"name\": \"union\", \"type\": [\"string\", \"int\"]}\n]}");
    private static final Schema unionSchemaWithDefault = new Schema.Parser().parse("{\"type\": \"record\",\n \"name\": \"test\",\n \"fields\": [\n     {\"name\": \"union\", \"type\": [\"string\", \"int\"], \"default\": \"\"}\n]}");
    private static final Schema enumSchema = new Schema.Parser().parse("{ \"type\": \"enum\",\n  \"name\": \"Suit\",\n  \"symbols\" : [\"SPADES\", \"HEARTS\", \"DIAMONDS\", \"CLUBS\"]\n}");
    private static final Schema enumSchema2 = new Schema.Parser().parse("{ \"type\": \"enum\",\n  \"name\": \"Suit\",\n  \"symbols\" : [\"SPADES\", \"HEARTS\", \"DIAMONDS\"]\n}");
    private static final Schema enumSchemaWithDefault = new Schema.Parser().parse("{ \"type\": \"enum\",\n  \"name\": \"Suit\",\n  \"symbols\" : [\"SPADES\", \"HEARTS\", \"DIAMONDS\", \"CLUBS\"],\n  \"default\" : \"HEARTS\"\n}");

    @Test
    public void testHasTopLevelField() {
        AvroSchema parsedSchema = new AvroSchema(recordSchema);
        Assert.assertTrue((boolean)parsedSchema.hasTopLevelField("null"));
        Assert.assertFalse((boolean)parsedSchema.hasTopLevelField("doesNotExist"));
    }

    @Test
    public void testGetReservedFields() {
        Metadata reservedFieldMetadata = new Metadata(Collections.emptyMap(), Collections.singletonMap("confluent:reserved", "null, boolean"), Collections.emptySet());
        AvroSchema parsedSchema = new AvroSchema(recordSchema.toString(), Collections.emptyList(), Collections.emptyMap(), reservedFieldMetadata, null, null, false);
        Assert.assertEquals((Object)ImmutableSet.of((Object)"null", (Object)"boolean"), (Object)parsedSchema.getReservedFields());
    }

    @Test
    public void testPrimitiveTypesToAvro() throws Exception {
        Object result = AvroSchemaUtils.toObject((JsonNode)null, (AvroSchema)AvroSchemaTest.createPrimitiveSchema("null"));
        Assert.assertNull((Object)result);
        result = AvroSchemaUtils.toObject((JsonNode)AvroSchemaTest.jsonTree("true"), (AvroSchema)AvroSchemaTest.createPrimitiveSchema("boolean"));
        Assert.assertEquals((Object)true, (Object)result);
        result = AvroSchemaUtils.toObject((JsonNode)AvroSchemaTest.jsonTree("false"), (AvroSchema)AvroSchemaTest.createPrimitiveSchema("boolean"));
        Assert.assertEquals((Object)false, (Object)result);
        result = AvroSchemaUtils.toObject((JsonNode)AvroSchemaTest.jsonTree("12"), (AvroSchema)AvroSchemaTest.createPrimitiveSchema("int"));
        Assert.assertTrue((boolean)(result instanceof Integer));
        Assert.assertEquals((Object)12, (Object)result);
        result = AvroSchemaUtils.toObject((JsonNode)AvroSchemaTest.jsonTree("12"), (AvroSchema)AvroSchemaTest.createPrimitiveSchema("long"));
        Assert.assertTrue((boolean)(result instanceof Long));
        Assert.assertEquals((Object)12L, (Object)result);
        result = AvroSchemaUtils.toObject((JsonNode)AvroSchemaTest.jsonTree("5000000000"), (AvroSchema)AvroSchemaTest.createPrimitiveSchema("long"));
        Assert.assertTrue((boolean)(result instanceof Long));
        Assert.assertEquals((Object)5000000000L, (Object)result);
        result = AvroSchemaUtils.toObject((JsonNode)AvroSchemaTest.jsonTree("23.2"), (AvroSchema)AvroSchemaTest.createPrimitiveSchema("float"));
        Assert.assertTrue((boolean)(result instanceof Float));
        Assert.assertEquals((Object)Float.valueOf(23.2f), (Object)result);
        result = AvroSchemaUtils.toObject((JsonNode)AvroSchemaTest.jsonTree("23"), (AvroSchema)AvroSchemaTest.createPrimitiveSchema("float"));
        Assert.assertTrue((boolean)(result instanceof Float));
        Assert.assertEquals((Object)Float.valueOf(23.0f), (Object)result);
        result = AvroSchemaUtils.toObject((JsonNode)AvroSchemaTest.jsonTree("23.2"), (AvroSchema)AvroSchemaTest.createPrimitiveSchema("double"));
        Assert.assertTrue((boolean)(result instanceof Double));
        Assert.assertEquals((Object)23.2, (Object)result);
        result = AvroSchemaUtils.toObject((JsonNode)AvroSchemaTest.jsonTree("23"), (AvroSchema)AvroSchemaTest.createPrimitiveSchema("double"));
        Assert.assertTrue((boolean)(result instanceof Double));
        Assert.assertEquals((Object)23.0, (Object)result);
        result = AvroSchemaUtils.toObject((JsonNode)new TextNode("hello"), (AvroSchema)AvroSchemaTest.createPrimitiveSchema("bytes"));
        Assert.assertTrue((boolean)(result instanceof ByteBuffer));
        Assert.assertArrayEquals((byte[])Base64.getEncoder().encode("hello".getBytes()), (byte[])Base64.getEncoder().encode(((ByteBuffer)result).array()));
        result = AvroSchemaUtils.toObject((JsonNode)AvroSchemaTest.jsonTree("\"a string\""), (AvroSchema)AvroSchemaTest.createPrimitiveSchema("string"));
        Assert.assertTrue((boolean)(result instanceof Utf8));
        Assert.assertEquals((Object)new Utf8("a string"), (Object)result);
    }

    @Test
    public void testPrimitiveTypeToAvroSchemaMismatches() {
        AvroSchemaTest.expectConversionException(AvroSchemaTest.jsonTree("12"), AvroSchemaTest.createPrimitiveSchema("null"));
        AvroSchemaTest.expectConversionException(AvroSchemaTest.jsonTree("12"), AvroSchemaTest.createPrimitiveSchema("boolean"));
        AvroSchemaTest.expectConversionException(AvroSchemaTest.jsonTree("false"), AvroSchemaTest.createPrimitiveSchema("int"));
        AvroSchemaTest.expectConversionException(AvroSchemaTest.jsonTree("5000000000"), AvroSchemaTest.createPrimitiveSchema("int"));
        AvroSchemaTest.expectConversionException(AvroSchemaTest.jsonTree("false"), AvroSchemaTest.createPrimitiveSchema("long"));
        AvroSchemaTest.expectConversionException(AvroSchemaTest.jsonTree("false"), AvroSchemaTest.createPrimitiveSchema("float"));
        AvroSchemaTest.expectConversionException(AvroSchemaTest.jsonTree("false"), AvroSchemaTest.createPrimitiveSchema("double"));
        AvroSchemaTest.expectConversionException(AvroSchemaTest.jsonTree("false"), AvroSchemaTest.createPrimitiveSchema("bytes"));
        AvroSchemaTest.expectConversionException(AvroSchemaTest.jsonTree("false"), AvroSchemaTest.createPrimitiveSchema("string"));
    }

    @Test
    public void testRecordToAvro() throws Exception {
        String json = "{\n    \"null\": null,\n    \"boolean\": true,\n    \"int\": 12,\n    \"long\": 5000000000,\n    \"float\": 23.4,\n    \"double\": 800.25,\n    \"bytes\": \"hello\",\n    \"string\": \"string\",\n    \"null_default\": null,\n    \"boolean_default\": false,\n    \"int_default\": 24,\n    \"long_default\": 4000000000,\n    \"float_default\": 12.3,\n    \"double_default\": 23.2,\n    \"bytes_default\": \"bytes\",\n    \"string_default\": \"default\"\n}";
        Object result = AvroSchemaUtils.toObject((JsonNode)AvroSchemaTest.jsonTree(json), (AvroSchema)new AvroSchema(recordSchema));
        Assert.assertTrue((boolean)(result instanceof GenericRecord));
        GenericRecord resultRecord = (GenericRecord)result;
        Assert.assertNull((Object)resultRecord.get("null"));
        Assert.assertEquals((Object)true, (Object)resultRecord.get("boolean"));
        Assert.assertEquals((Object)12, (Object)resultRecord.get("int"));
        Assert.assertEquals((Object)5000000000L, (Object)resultRecord.get("long"));
        Assert.assertEquals((Object)Float.valueOf(23.4f), (Object)resultRecord.get("float"));
        Assert.assertEquals((Object)800.25, (Object)resultRecord.get("double"));
        Assert.assertArrayEquals((byte[])Base64.getEncoder().encode("hello".getBytes()), (byte[])Base64.getEncoder().encode(((ByteBuffer)resultRecord.get("bytes")).array()));
        Assert.assertEquals((Object)"string", (Object)resultRecord.get("string").toString());
    }

    @Test
    public void testArrayToAvro() throws Exception {
        String json = "[\"one\", \"two\", \"three\"]";
        Object result = AvroSchemaUtils.toObject((JsonNode)AvroSchemaTest.jsonTree(json), (AvroSchema)new AvroSchema(arraySchema));
        Assert.assertTrue((boolean)(result instanceof GenericArray));
        Assert.assertArrayEquals((Object[])new Utf8[]{new Utf8("one"), new Utf8("two"), new Utf8("three")}, (Object[])((GenericArray)result).toArray());
    }

    @Test
    public void testMapToAvro() throws Exception {
        String json = "{\"first\": \"one\", \"second\": \"two\"}";
        Object result = AvroSchemaUtils.toObject((JsonNode)AvroSchemaTest.jsonTree(json), (AvroSchema)new AvroSchema(mapSchema));
        Assert.assertTrue((boolean)(result instanceof Map));
        Assert.assertEquals((long)2L, (long)((Map)result).size());
    }

    @Test
    public void testUnionToAvro() throws Exception {
        Object result = AvroSchemaUtils.toObject((JsonNode)AvroSchemaTest.jsonTree("{\"union\":{\"string\":\"test string\"}}"), (AvroSchema)new AvroSchema(unionSchema));
        Assert.assertTrue((boolean)(((GenericRecord)result).get("union") instanceof Utf8));
        result = AvroSchemaUtils.toObject((JsonNode)AvroSchemaTest.jsonTree("{\"union\":{\"int\":12}}"), (AvroSchema)new AvroSchema(unionSchema));
        Assert.assertTrue((boolean)(((GenericRecord)result).get("union") instanceof Integer));
        try {
            AvroSchemaUtils.toObject((JsonNode)AvroSchemaTest.jsonTree("12.4"), (AvroSchema)new AvroSchema(unionSchema));
            Assert.fail((String)"Trying to convert floating point number to union(string,int) schema should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testEnumToAvro() throws Exception {
        Object result = AvroSchemaUtils.toObject((JsonNode)AvroSchemaTest.jsonTree("\"SPADES\""), (AvroSchema)new AvroSchema(enumSchema));
        Assert.assertTrue((boolean)(result instanceof GenericEnumSymbol));
    }

    @Test
    public void testEnumCompatibility() {
        AvroSchema schema1 = new AvroSchema(enumSchema);
        AvroSchema schema2 = new AvroSchema(enumSchema2);
        Assert.assertFalse((boolean)schema2.isBackwardCompatible((ParsedSchema)schema1).isEmpty());
    }

    @Test
    public void testPrimitiveTypesToJson() throws Exception {
        JsonNode result = objectMapper.readTree(AvroSchemaUtils.toJson((Object)0));
        Assert.assertTrue((boolean)result.isNumber());
        result = objectMapper.readTree(AvroSchemaUtils.toJson((Object)0L));
        Assert.assertTrue((boolean)result.isNumber());
        result = objectMapper.readTree(AvroSchemaUtils.toJson((Object)Float.valueOf(0.1f)));
        Assert.assertTrue((boolean)result.isNumber());
        result = objectMapper.readTree(AvroSchemaUtils.toJson((Object)0.1));
        Assert.assertTrue((boolean)result.isNumber());
        result = objectMapper.readTree(AvroSchemaUtils.toJson((Object)true));
        Assert.assertTrue((boolean)result.isBoolean());
        result = objectMapper.readTree(AvroSchemaUtils.toJson((Object)"abcdefg"));
        Assert.assertTrue((boolean)result.isTextual());
        Assert.assertEquals((Object)"abcdefg", (Object)result.textValue());
        result = objectMapper.readTree(AvroSchemaUtils.toJson((Object)ByteBuffer.wrap("hello".getBytes())));
        Assert.assertTrue((boolean)result.isTextual());
        Assert.assertEquals((Object)"hello", (Object)result.textValue());
    }

    @Test
    public void testUnsupportedJavaPrimitivesToJson() {
        AvroSchemaTest.expectConversionException((byte)0);
        AvroSchemaTest.expectConversionException(Character.valueOf('\u0000'));
        AvroSchemaTest.expectConversionException((short)0);
    }

    @Test
    public void testRecordToJson() throws Exception {
        GenericData.Record data = new GenericRecordBuilder(recordSchema).set("null", null).set("boolean", (Object)true).set("int", (Object)12).set("long", (Object)5000000000L).set("float", (Object)Float.valueOf(23.4f)).set("double", (Object)800.25).set("bytes", (Object)ByteBuffer.wrap("bytes".getBytes())).set("string", (Object)"string").build();
        JsonNode result = objectMapper.readTree(AvroSchemaUtils.toJson((Object)data));
        Assert.assertTrue((boolean)result.isObject());
        Assert.assertTrue((boolean)result.get("null").isNull());
        Assert.assertTrue((boolean)result.get("boolean").isBoolean());
        Assert.assertTrue((boolean)result.get("boolean").booleanValue());
        Assert.assertTrue((boolean)result.get("int").isIntegralNumber());
        Assert.assertEquals((long)12L, (long)result.get("int").intValue());
        Assert.assertTrue((boolean)result.get("long").isIntegralNumber());
        Assert.assertEquals((long)5000000000L, (long)result.get("long").longValue());
        Assert.assertTrue((boolean)result.get("float").isFloatingPointNumber());
        Assert.assertEquals((double)23.4f, (double)result.get("float").floatValue(), (double)0.1);
        Assert.assertTrue((boolean)result.get("double").isFloatingPointNumber());
        Assert.assertEquals((double)800.25, (double)result.get("double").doubleValue(), (double)0.01);
        Assert.assertTrue((boolean)result.get("bytes").isTextual());
        Assert.assertEquals((Object)"bytes", (Object)result.get("bytes").textValue());
        Assert.assertTrue((boolean)result.get("string").isTextual());
        Assert.assertEquals((Object)"string", (Object)result.get("string").textValue());
    }

    @Test
    public void testArrayToJson() throws Exception {
        GenericData.Array data = new GenericData.Array(arraySchema, Arrays.asList("one", "two", "three"));
        JsonNode result = objectMapper.readTree(AvroSchemaUtils.toJson((Object)data));
        Assert.assertTrue((boolean)result.isArray());
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((Object)JsonNodeFactory.instance.textNode("one"), (Object)result.get(0));
        Assert.assertEquals((Object)JsonNodeFactory.instance.textNode("two"), (Object)result.get(1));
        Assert.assertEquals((Object)JsonNodeFactory.instance.textNode("three"), (Object)result.get(2));
    }

    @Test
    public void testMapToJson() throws Exception {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("first", "one");
        data.put("second", "two");
        JsonNode result = objectMapper.readTree(AvroSchemaUtils.toJson(data));
        Assert.assertTrue((boolean)result.isObject());
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertNotNull((Object)result.get("first"));
        Assert.assertEquals((Object)"one", (Object)result.get("first").asText());
        Assert.assertNotNull((Object)result.get("second"));
        Assert.assertEquals((Object)"two", (Object)result.get("second").asText());
    }

    @Test
    public void testEnumToJson() throws Exception {
        JsonNode result = objectMapper.readTree(AvroSchemaUtils.toJson((Object)new GenericData.EnumSymbol(enumSchema, "SPADES")));
        Assert.assertTrue((boolean)result.isTextual());
        Assert.assertEquals((Object)"SPADES", (Object)result.textValue());
    }

    @Test
    public void testInvalidDefault() {
        AvroSchemaProvider provider = new AvroSchemaProvider();
        Map<String, String> configs = Collections.singletonMap("avro.validate.defaults", "false");
        provider.configure(configs);
        Optional schema = provider.parseSchema(recordInvalidDefaultSchema, Collections.emptyList(), true, false);
        Assert.assertTrue((boolean)schema.isPresent());
        configs = Collections.singletonMap("avro.validate.defaults", "true");
        provider.configure(configs);
        schema = provider.parseSchema(recordInvalidDefaultSchema, Collections.emptyList(), true, false);
        Assert.assertFalse((boolean)schema.isPresent());
    }

    @Test
    public void testInvalidDefaultDuringNormalize() {
        AvroSchemaProvider provider = new AvroSchemaProvider();
        Optional schema = provider.parseSchema(recordInvalidDefaultSchema, Collections.emptyList(), true, true);
        Assert.assertFalse((boolean)schema.isPresent());
    }

    @Test
    public void testMetaInequalities() {
        AvroSchema schema = new AvroSchema(recordSchema);
        AvroSchema schema1 = new AvroSchema(recordWithDocSchema);
        AvroSchema schema2 = new AvroSchema(recordWithAliasesSchema);
        AvroSchema schema3 = new AvroSchema(recordWithFieldDocSchema);
        AvroSchema schema4 = new AvroSchema(recordWithFieldAliasesSchema);
        Assert.assertNotEquals((Object)schema, (Object)schema1);
        Assert.assertNotEquals((Object)schema, (Object)schema2);
        Assert.assertNotEquals((Object)schema, (Object)schema3);
        Assert.assertNotEquals((Object)schema, (Object)schema4);
    }

    @Test
    public void testNormalization() {
        String schemaString = "{\"type\":\"record\",\"name\":\"myrecord\",\"doc\":\"hi\\\"there\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\",\"doc\":\"bye\\\"now\"}]}";
        String normalized = "{\"type\":\"record\",\"name\":\"myrecord\",\"doc\":\"hi\\\"there\",\"fields\":[{\"name\":\"f1\",\"type\":\"string\",\"doc\":\"bye\\\"now\"}]}";
        AvroSchema schema = new AvroSchema(schemaString);
        Assert.assertEquals((Object)normalized, (Object)schema.canonicalString());
        AvroSchema normalizedSchema = schema.normalize();
        Assert.assertEquals((Object)normalized, (Object)normalizedSchema.canonicalString());
    }

    @Test
    public void testNormalizationPreservesMetadataForPrimitiveTypes() {
        String schemaString = "{\"connect.name\": \"some.scope.Envelope\",\"fields\": [{\"default\": null,\"name\": \"before\",\"type\": [\"null\",{\"connect.name\": \"some.scope.Value\",\"fields\": [{\"name\": \"created_at\",\"type\": {\"connect.name\": \"io.debezium.time.Timestamp\",\"connect.version\": 1,\"type\": \"long\"}},{\"name\":\"normal_long\",\"type\":\"long\"}],\"name\": \"Value\",\"type\": \"record\"}]},{\"default\": null,\"name\": \"after\",\"type\": [\"null\",\"Value\"]}],\"name\": \"Envelope\",\"namespace\": \"some.scope\",\"type\": \"record\"}";
        String normalized = "{\"type\":\"record\",\"name\":\"Envelope\",\"namespace\":\"some.scope\",\"fields\":[{\"name\":\"before\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"Value\",\"fields\":[{\"name\":\"created_at\",\"type\":{\"type\":\"long\",\"connect.name\":\"io.debezium.time.Timestamp\",\"connect.version\":1}},{\"name\":\"normal_long\",\"type\":\"long\"}],\"connect.name\":\"some.scope.Value\"}],\"default\":null},{\"name\":\"after\",\"type\":[\"null\",\"Value\"],\"default\":null}],\"connect.name\":\"some.scope.Envelope\"}";
        AvroSchema schema = new AvroSchema(schemaString);
        Assert.assertEquals((Object)normalized, (Object)schema.canonicalString());
        AvroSchema normalizedSchema = schema.normalize();
        Assert.assertEquals((Object)normalized, (Object)normalizedSchema.canonicalString());
    }

    @Test
    public void testArrayWithDefault() {
        Assert.assertNotEquals((Object)new AvroSchema(mapSchema), (Object)new AvroSchema(mapSchemaWithDefault));
    }

    @Test
    public void testMapWithDefault() {
        Assert.assertNotEquals((Object)new AvroSchema(arraySchema), (Object)new AvroSchema(arraySchemaWithDefault));
    }

    @Test
    public void testUnionWithDefault() {
        Assert.assertNotEquals((Object)new AvroSchema(unionSchema), (Object)new AvroSchema(unionSchemaWithDefault));
    }

    @Test
    public void testEnumWithDefault() {
        Assert.assertNotEquals((Object)new AvroSchema(enumSchema), (Object)new AvroSchema(enumSchemaWithDefault));
    }

    @Test
    public void testBasicAddAndRemoveTags() {
        String schemaString = "{\n  \"name\": \"sampleRecord\",\n  \"namespace\": \"com.example.mynamespace\",\n  \"type\": \"record\",\n  \"doc\": \"Sample schema to help you get started.\",\n  \"fields\": [\n    {\n      \"name\": \"my_field1\",\n      \"type\": {\n        \"name\": \"nestedRecordWithoutNamespace\",\n        \"type\": \"record\",\n        \"fields\": [\n          {\n            \"name\": \"nested_field1\",\n            \"type\": \"string\"\n          },\n          {\n            \"default\": 0,\n            \"name\": \"nested_field2\",\n            \"type\": \"double\",\n            \"confluent:tags\": [ \"PRIVATE\" ]\n          }\n        ]\n      }\n    },\n    {\n      \"name\": \"my_field2\",\n      \"namespace\": \"com.example.mynamespace.nested\",\n      \"type\": {\n        \"name\": \"nestedRecordWithNamespace\",\n        \"type\": \"record\",\n        \"fields\": [\n          {\n            \"name\": \"nested_field1\",\n            \"type\": \"string\"\n          },\n          {\n            \"default\": 0,\n            \"name\": \"nested_field2\",\n            \"type\": \"double\",\n            \"confluent:tags\": [ \"PRIVATE\" ]\n          }\n        ]\n      }\n    },\n    {\n      \"doc\": \"The double type is a double precision (64-bit) IEEE 754 floating-point number.\",\n      \"name\": \"my_field3\",\n      \"type\": \"double\"\n    }\n  ]\n}\n";
        String addedTagSchema = "{\n  \"type\" : \"record\",\n  \"name\" : \"sampleRecord\",\n  \"namespace\" : \"com.example.mynamespace\",\n  \"doc\" : \"Sample schema to help you get started.\",\n  \"fields\" : [ {\n    \"name\" : \"my_field1\",\n    \"type\" : {\n      \"type\" : \"record\",\n      \"name\" : \"nestedRecordWithoutNamespace\",\n      \"fields\" : [ {\n        \"name\" : \"nested_field1\",\n        \"type\" : \"string\",\n        \"confluent:tags\" : [ \"PII\" ]\n      }, {\n        \"name\" : \"nested_field2\",\n        \"type\" : \"double\",\n        \"default\" : 0,\n        \"confluent:tags\" : [ \"PRIVATE\" ]\n      } ]\n    }\n  }, {\n    \"name\" : \"my_field2\",\n    \"type\" : {\n      \"type\" : \"record\",\n      \"name\" : \"nestedRecordWithNamespace\",\n      \"fields\" : [ {\n        \"name\" : \"nested_field1\",\n        \"type\" : \"string\"\n      }, {\n        \"name\" : \"nested_field2\",\n        \"type\" : \"double\",\n        \"default\" : 0,\n        \"confluent:tags\" : [ \"PRIVATE\",\"PII\" ]\n      } ],\n      \"confluent:tags\": [ \"PII\" ]\n    },\n    \"namespace\" : \"com.example.mynamespace.nested\"\n  }, {\n    \"name\" : \"my_field3\",\n    \"type\" : \"double\",\n    \"doc\" : \"The double type is a double precision (64-bit) IEEE 754 floating-point number.\",\n    \"confluent:tags\" : [ \"PII\" ]\n  } ],\n  \"confluent:tags\": [ \"PII\" ]\n}\n";
        AvroSchema schema = new AvroSchema(schemaString);
        AvroSchema expectSchema = new AvroSchema(addedTagSchema);
        HashMap<SchemaEntity, Set<String>> tags = new HashMap<SchemaEntity, Set<String>>();
        tags.put(new SchemaEntity("com.example.mynamespace.nestedRecordWithoutNamespace.nested_field1", SchemaEntity.EntityType.SR_FIELD), Collections.singleton("PII"));
        tags.put(new SchemaEntity("com.example.mynamespace.nested.nestedRecordWithNamespace.nested_field2", SchemaEntity.EntityType.SR_FIELD), Collections.singleton("PII"));
        tags.put(new SchemaEntity("com.example.mynamespace.sampleRecord.my_field3", SchemaEntity.EntityType.SR_FIELD), Collections.singleton("PII"));
        tags.put(new SchemaEntity("com.example.mynamespace.sampleRecord", SchemaEntity.EntityType.SR_RECORD), Collections.singleton("PII"));
        tags.put(new SchemaEntity("com.example.mynamespace.nested.nestedRecordWithNamespace", SchemaEntity.EntityType.SR_RECORD), Collections.singleton("PII"));
        ParsedSchema resultSchema = schema.copy(tags, Collections.emptyMap());
        Assert.assertEquals((Object)expectSchema.canonicalString(), (Object)resultSchema.canonicalString());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"PII", (Object)"PRIVATE"), (Object)resultSchema.inlineTags());
        resultSchema = resultSchema.copy(Collections.emptyMap(), tags);
        Assert.assertEquals((Object)schema.canonicalString(), (Object)resultSchema.canonicalString());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"PRIVATE"), (Object)resultSchema.inlineTags());
        Map<String, Set<String>> pathTags = Collections.singletonMap("some.path", Collections.singleton("EXTERNAL"));
        Metadata metadata = new Metadata(pathTags, null, null);
        resultSchema = resultSchema.copy(metadata, null);
        Assert.assertEquals((Object)ImmutableSet.of((Object)"PRIVATE", (Object)"EXTERNAL"), (Object)resultSchema.tags());
    }

    @Test
    public void testComplexAddAndRemoveTags() {
        String schemaString = "[\n  \"null\",\n  {\n    \"name\": \"sampleRecord\",\n    \"namespace\": \"com.example.mynamespace\",\n    \"type\": \"record\",\n    \"doc\": \"Sample schema to help you get started.\",\n    \"fields\": [\n      {\n        \"name\": \"my_field1\",\n        \"type\": {\n          \"name\": \"nestedRecord\",\n          \"type\": \"record\",\n          \"fields\": [\n            {\n              \"name\": \"nested_field1\",\n              \"type\": \"string\"\n            },\n            {\n              \"default\": 0,\n              \"name\": \"nested_field2\",\n              \"type\": \"double\",\n              \"confluent:tags\": [ \"PRIVATE\" ]\n            }\n          ]\n        }\n      }, \n      {\n        \"type\": \"int\",\n        \"name\": \"my_field2\"\n      }\n    ]\n  },\n  {\n    \"type\": \"array\",\n    \"items\" : {\n      \"name\": \"recordItem\",\n      \"namespace\": \"com.example.mynamespace.nested\",\n      \"type\": \"record\",\n      \"doc\": \"Sample schema to help you get started.\",\n      \"fields\": [\n        {\n          \"name\": \"my_field1\",\n          \"type\": {\n            \"name\": \"nestedRecord2\",\n            \"type\": \"record\",\n            \"fields\": [\n              {\n                \"name\": \"nested_field1\",\n                \"type\": \"string\"\n              },\n              {\n                \"default\": 0,\n                \"name\": \"nested_field2\",\n                \"type\": \"double\",\n                \"confluent:tags\": [ \"PRIVATE\" ]\n              }\n            ]\n          }\n        }\n      ]\n    },\n    \"default\": []\n  },\n  {\n    \"type\": \"map\",\n    \"values\" : {\n      \"name\": \"recordMapValue\",\n      \"type\": \"record\",\n      \"doc\": \"Sample schema to help you get started.\",\n      \"fields\": [\n        {\n          \"name\": \"my_field1\",\n          \"type\": {\n            \"name\": \"nestedRecord3\",\n            \"type\": \"record\",\n            \"fields\": [\n              {\n                \"name\": \"nested_field1\",\n                \"type\": \"string\"\n              },\n              {\n                \"default\": 0,\n                \"name\": \"nested_field2\",\n                \"type\": \"double\",\n                \"confluent:tags\": [ \"PRIVATE\" ]\n              }\n            ]\n          }\n        }\n      ]\n    },\n    \"default\": {}\n  }\n]\n";
        String addedTagSchema = "[ \"null\", {\n  \"type\" : \"record\",\n  \"name\" : \"sampleRecord\",\n  \"namespace\" : \"com.example.mynamespace\",\n  \"doc\" : \"Sample schema to help you get started.\",\n  \"fields\" : [ {\n    \"name\" : \"my_field1\",\n    \"type\" : {\n      \"type\" : \"record\",\n      \"name\" : \"nestedRecord\",\n      \"fields\" : [ {\n        \"name\" : \"nested_field1\",\n        \"type\" : \"string\"\n      }, {\n        \"name\" : \"nested_field2\",\n        \"type\" : \"double\",\n        \"default\" : 0,\n        \"confluent:tags\" : [ \"PRIVATE\" ]\n      } ]\n    },\n    \"confluent:tags\" : [ \"PII\" ]\n  }, {\n    \"name\" : \"my_field2\",\n    \"type\" : \"int\"\n  } ]\n}, {\n  \"type\" : \"array\",\n  \"items\" : {\n    \"type\" : \"record\",\n    \"name\" : \"recordItem\",\n    \"namespace\" : \"com.example.mynamespace.nested\",\n    \"doc\" : \"Sample schema to help you get started.\",\n    \"fields\" : [ {\n      \"name\" : \"my_field1\",\n      \"type\" : {\n        \"type\" : \"record\",\n        \"name\" : \"nestedRecord2\",\n        \"fields\" : [ {\n          \"name\" : \"nested_field1\",\n          \"type\" : \"string\"\n        }, {\n          \"name\" : \"nested_field2\",\n          \"type\" : \"double\",\n          \"default\" : 0,\n          \"confluent:tags\" : [ \"PRIVATE\", \"PII\" ]\n        } ]\n      }\n    } ],\n    \"confluent:tags\" : [ \"PII\" ]\n  },\n  \"default\" : [ ]\n}, {\n  \"type\" : \"map\",\n  \"values\" : {\n    \"type\" : \"record\",\n    \"name\" : \"recordMapValue\",\n    \"doc\" : \"Sample schema to help you get started.\",\n    \"fields\" : [ {\n      \"name\" : \"my_field1\",\n      \"type\" : {\n        \"type\" : \"record\",\n        \"name\" : \"nestedRecord3\",\n        \"fields\" : [ {\n          \"name\" : \"nested_field1\",\n          \"type\" : \"string\"\n        }, {\n          \"name\" : \"nested_field2\",\n          \"type\" : \"double\",\n          \"default\" : 0,\n          \"confluent:tags\" : [ \"PRIVATE\", \"PII\" ]\n        } ]\n      },\n      \"confluent:tags\" : [ \"PII\" ]\n    } ],\n    \"confluent:tags\" : [ \"PII\" ]\n  },\n  \"default\" : { }\n} ]\n";
        AvroSchema schema = new AvroSchema(schemaString);
        AvroSchema expectSchema = new AvroSchema(addedTagSchema);
        HashMap<SchemaEntity, Set<String>> tags = new HashMap<SchemaEntity, Set<String>>();
        tags.put(new SchemaEntity("com.example.mynamespace.sampleRecord.my_field1", SchemaEntity.EntityType.SR_FIELD), Collections.singleton("PII"));
        tags.put(new SchemaEntity("com.example.mynamespace.nested.nestedRecord2.nested_field2", SchemaEntity.EntityType.SR_FIELD), Collections.singleton("PII"));
        tags.put(new SchemaEntity("recordMapValue.my_field1", SchemaEntity.EntityType.SR_FIELD), Collections.singleton("PII"));
        tags.put(new SchemaEntity("nestedRecord3.nested_field2", SchemaEntity.EntityType.SR_FIELD), Collections.singleton("PII"));
        tags.put(new SchemaEntity("com.example.mynamespace.nested.recordItem", SchemaEntity.EntityType.SR_RECORD), Collections.singleton("PII"));
        tags.put(new SchemaEntity("recordMapValue", SchemaEntity.EntityType.SR_RECORD), Collections.singleton("PII"));
        ParsedSchema resultSchema = schema.copy(tags, Collections.emptyMap());
        Assert.assertEquals((Object)expectSchema.canonicalString(), (Object)resultSchema.canonicalString());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"PII", (Object)"PRIVATE"), (Object)resultSchema.inlineTags());
        resultSchema = resultSchema.copy(Collections.emptyMap(), tags);
        Assert.assertEquals((Object)schema.canonicalString(), (Object)resultSchema.canonicalString());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"PRIVATE"), (Object)resultSchema.inlineTags());
    }

    @Test
    public void testNamespace() {
        String schemaString = "[\n  {\n    \"name\": \"sampleRecord\",\n    \"namespace\": \"com.example.mynamespace1\",\n    \"type\": \"record\",\n    \"fields\": [\n      {\n        \"name\": \"my_field1\",\n        \"type\": \"string\"\n      }, \n      {\n        \"type\": \"int\",\n        \"name\": \"my_field2\"\n      }\n    ]\n  },\n  {\n    \"name\": \"sampleRecord\",\n    \"namespace\": \"com.example.mynamespace2\",\n    \"type\": \"record\",\n    \"fields\": [\n      {\n        \"name\": \"my_field1\",\n        \"type\": \"double\"\n      }, \n      {\n        \"type\": \"int\",\n        \"name\": \"my_field2\"\n      }\n    ]\n  }\n]\n";
        String addedTagSchema = "[\n  {\n    \"name\": \"sampleRecord\",\n    \"namespace\": \"com.example.mynamespace1\",\n    \"type\": \"record\",\n    \"fields\": [\n      {\n        \"name\": \"my_field1\",\n        \"type\": \"string\",\n        \"confluent:tags\": [ \"tag1\" ]\n      }, \n      {\n        \"type\": \"int\",\n        \"name\": \"my_field2\"\n      }\n    ]\n  },\n  {\n    \"name\": \"sampleRecord\",\n    \"namespace\": \"com.example.mynamespace2\",\n    \"type\": \"record\",\n    \"fields\": [\n      {\n        \"name\": \"my_field1\",\n        \"type\": \"double\",\n        \"confluent:tags\": [ \"tag2\" ]\n      }, \n      {\n        \"type\": \"int\",\n        \"name\": \"my_field2\"\n      }\n    ],\n    \"confluent:tags\" : [ \"PII\" ]\n  }\n]\n";
        AvroSchema schema = new AvroSchema(schemaString);
        AvroSchema expectSchema = new AvroSchema(addedTagSchema);
        HashMap<SchemaEntity, Set<String>> tags = new HashMap<SchemaEntity, Set<String>>();
        tags.put(new SchemaEntity("com.example.mynamespace1.sampleRecord.my_field1", SchemaEntity.EntityType.SR_FIELD), Collections.singleton("tag1"));
        tags.put(new SchemaEntity("com.example.mynamespace2.sampleRecord.my_field1", SchemaEntity.EntityType.SR_FIELD), Collections.singleton("tag2"));
        tags.put(new SchemaEntity("com.example.mynamespace2.sampleRecord", SchemaEntity.EntityType.SR_RECORD), Collections.singleton("PII"));
        ParsedSchema resultSchema = schema.copy(tags, Collections.emptyMap());
        Assert.assertEquals((Object)expectSchema.canonicalString(), (Object)resultSchema.canonicalString());
    }

    @Test
    public void testTagsInsertionOrder() {
        String schemaString = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\"}]}";
        String addedTagSchema = "{\"type\":\"record\",\"name\":\"myrecord\",\"fields\":[{\"type\":\"string\",\"name\":\"f1\",\"confluent:tags\":[\"tag1\",\"tag2\"]\n}]}";
        AvroSchema schema = new AvroSchema(schemaString);
        AvroSchema expectSchema = new AvroSchema(addedTagSchema);
        LinkedHashMap tags = new LinkedHashMap();
        LinkedHashSet<String> tagNames = new LinkedHashSet<String>();
        tagNames.add("tag1");
        tagNames.add("tag2");
        tags.put(new SchemaEntity("myrecord.f1", SchemaEntity.EntityType.SR_FIELD), tagNames);
        ParsedSchema resultSchema = schema.copy(tags, Collections.emptyMap());
        Assert.assertEquals((Object)expectSchema.canonicalString(), (Object)resultSchema.canonicalString());
    }

    private static void expectConversionException(JsonNode obj, AvroSchema schema) {
        try {
            AvroSchemaUtils.toObject((JsonNode)obj, (AvroSchema)schema);
            Assert.fail((String)("Expected conversion of " + (obj == null ? "null" : obj.toString()) + " to schema " + schema.toString() + " to fail"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void expectConversionException(Object obj) {
        try {
            AvroSchemaUtils.getSchema((Object)obj);
            Assert.fail((String)("Expected conversion of " + (obj == null ? "null" : obj + " (" + obj.getClass().getName() + ")") + " to fail"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static AvroSchema createPrimitiveSchema(String type) {
        String schemaString = String.format("{\"type\" : \"%s\"}", type);
        return new AvroSchema(parser.parse(schemaString));
    }

    private static JsonNode jsonTree(String jsonData) {
        try {
            return objectMapper.readTree(jsonData);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse JSON", e);
        }
    }
}

