/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.dekregistry.storage;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.dekregistry.client.rest.entities.Dek;
import io.confluent.dekregistry.client.rest.entities.KeyType;
import io.confluent.dekregistry.storage.DataEncryptionKeyId;
import io.confluent.dekregistry.storage.EncryptionKey;
import io.confluent.kafka.schemaregistry.encryption.tink.DekFormat;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DataEncryptionKey
extends EncryptionKey {
    private final String kekName;
    private final String subject;
    private final DekFormat algorithm;
    private final int version;
    private final String encryptedKeyMaterial;
    private String keyMaterial;

    @JsonCreator
    public DataEncryptionKey(@JsonProperty(value="kekName") String kekName, @JsonProperty(value="subject") String subject, @JsonProperty(value="algorithm") DekFormat algorithm, @JsonProperty(value="version") int version, @JsonProperty(value="encryptedKeyMaterial") String encryptedKeyMaterial, @JsonProperty(value="deleted") boolean deleted) {
        super(KeyType.DEK, deleted);
        this.kekName = kekName;
        this.subject = subject;
        this.algorithm = algorithm;
        this.version = version;
        this.encryptedKeyMaterial = encryptedKeyMaterial;
    }

    @JsonProperty(value="kekName")
    public String getKekName() {
        return this.kekName;
    }

    @JsonProperty(value="subject")
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="algorithm")
    public DekFormat getAlgorithm() {
        return this.algorithm;
    }

    @JsonProperty(value="version")
    public int getVersion() {
        return this.version;
    }

    @JsonProperty(value="encryptedKeyMaterial")
    public String getEncryptedKeyMaterial() {
        return this.encryptedKeyMaterial;
    }

    @JsonIgnore
    public String getKeyMaterial() {
        return this.keyMaterial;
    }

    @JsonIgnore
    public void setKeyMaterial(String keyMaterial) {
        this.keyMaterial = keyMaterial;
    }

    @JsonIgnore
    public boolean isEquivalent(DataEncryptionKey that) {
        return Objects.equals(this.kekName, that.kekName) && Objects.equals(this.subject, that.subject) && this.algorithm == that.algorithm && this.version == that.version && Objects.equals(this.encryptedKeyMaterial, that.encryptedKeyMaterial);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DataEncryptionKey that = (DataEncryptionKey)o;
        return Objects.equals(this.kekName, that.kekName) && Objects.equals(this.subject, that.subject) && this.algorithm == that.algorithm && this.version == that.version && Objects.equals(this.encryptedKeyMaterial, that.encryptedKeyMaterial);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.kekName, this.subject, this.algorithm, this.version, this.encryptedKeyMaterial);
    }

    @Override
    public DataEncryptionKeyId toKey(String tenant) {
        return new DataEncryptionKeyId(tenant, this.kekName, this.subject, this.algorithm, this.version);
    }

    public Dek toDekEntity() {
        return new Dek(this.kekName, this.subject, this.version, this.algorithm, this.encryptedKeyMaterial, this.keyMaterial, this.timestamp, this.deleted ? Boolean.valueOf(true) : null);
    }
}

