/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.log4j;

import com.mapr.log4j.MaprfsLogAppender;
import java.io.File;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class CentralTaskLogAppender
extends MaprfsLogAppender {
    private String taskId;
    private int maxEvents = 0;
    private static final int EVENT_SIZE = 100;
    private Queue<LoggingEvent> tail = null;
    private Boolean isCleanup;
    static final String ISCLEANUP_PROPERTY = "hadoop.tasklog.iscleanup";
    static final String TASKID_PROPERTY = "hadoop.tasklog.taskid";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activateOptions() {
        CentralTaskLogAppender centralTaskLogAppender = this;
        synchronized (centralTaskLogAppender) {
            this.setOptionsFromSystemProperties();
            if (this.maxEvents > 0) {
                this.tail = new LinkedList<LoggingEvent>();
            }
            String localSyslogName = TaskLog.getTaskLogFile((TaskAttemptID)TaskAttemptID.forName((String)this.taskId), (boolean)this.isCleanup, (TaskLog.LogName)TaskLog.LogName.SYSLOG).toString();
            String centralSyslogName = this.getCentralRelativePathStr(localSyslogName);
            super.setFile(centralSyslogName);
            super.activateOptions();
        }
    }

    private String getCentralRelativePathStr(String localSyslogName) {
        String userlogs_substr = File.separator + "userlogs" + File.separator;
        int userLogDirPos = localSyslogName.indexOf(userlogs_substr);
        if (userLogDirPos != -1) {
            return this.getFrameworkType() + userlogs_substr + localSyslogName.substring(userLogDirPos + userlogs_substr.length());
        }
        return this.getFrameworkType() + userlogs_substr + localSyslogName;
    }

    protected String getFrameworkType() {
        return "mapred";
    }

    @Override
    public void setFile(String fileName) {
        LogLog.debug((String)(this.getClass() + ".setFile is a NOP, fileName=" + fileName));
    }

    private synchronized void setOptionsFromSystemProperties() {
        if (this.isCleanup == null) {
            String propValue = System.getProperty(ISCLEANUP_PROPERTY, "false");
            this.isCleanup = Boolean.valueOf(propValue);
        }
        if (this.taskId == null) {
            this.taskId = System.getProperty(TASKID_PROPERTY);
        }
        this.setTotalLogFileSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(LoggingEvent event) {
        CentralTaskLogAppender centralTaskLogAppender = this;
        synchronized (centralTaskLogAppender) {
            if (this.tail == null) {
                super.append(event);
            } else {
                if (this.tail.size() >= this.maxEvents) {
                    this.tail.remove();
                }
                this.tail.add(event);
            }
        }
    }

    @Override
    public synchronized void close() {
        if (this.tail != null) {
            for (LoggingEvent event : this.tail) {
                super.append(event);
            }
        }
        super.close();
    }

    public synchronized String getTaskId() {
        return this.taskId;
    }

    public synchronized void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public synchronized long getTotalLogFileSize() {
        return this.maxEvents * 100;
    }

    public synchronized void setTotalLogFileSize() {
        Long fileSizeLimit = this.getFileSizeLimit();
        if (fileSizeLimit != null && fileSizeLimit > 0L) {
            this.maxEvents = (int)(fileSizeLimit / 100L);
        }
    }

    protected Long getFileSizeLimit() {
        return null;
    }

    public synchronized void setIsCleanup(boolean isCleanup) {
        this.isCleanup = isCleanup;
    }

    public synchronized boolean getIsCleanup() {
        return this.isCleanup;
    }
}

