/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Installation {
    private static final Logger log = LoggerFactory.getLogger(Installation.class);
    private static final String MAPR_HOME_PATH_DEFAULT = Installation.isOsWindows() ? "C:\\opt\\mapr" : "/opt/mapr";
    private static final boolean osWindows = Installation.findIfOsWindows();
    private static final String mapRHome = Installation.findMapRHome();
    private static final String maprConfDir = Installation.getMapRHome() + File.separator + "conf";
    private static final String maprClusterCfgLocation = Installation.getMaprConfDir() + File.separator + "mapr-clusters.conf";
    private static final AtomicReference<Object> hadoopHome = new AtomicReference();
    private static final AtomicReference<Object> coreSiteXmlURL = new AtomicReference();

    private static String findMapRHome() {
        String mHome = System.getenv("MAPR_HOME");
        if (mHome == null && (mHome = System.getProperty("mapr.home.dir")) == null) {
            mHome = MAPR_HOME_PATH_DEFAULT;
        }
        return mHome;
    }

    private static boolean findIfOsWindows() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.indexOf("win") >= 0;
    }

    private static String findHadoopHome() {
        String hHomePath;
        Object hHome = System.getenv("HADOOP_HOME");
        if (hHome == null && (hHome = System.getProperty("hadoop.home.dir")) == null) {
            String hadoopBase = Installation.getMapRHome() + "/hadoop";
            String hadoopVersionFileName = hadoopBase + "/hadoopversion";
            Path hadoopVersionPath = Paths.get(hadoopVersionFileName, new String[0]);
            Preconditions.checkState((boolean)Files.exists(hadoopVersionPath, new LinkOption[0]), (String)"Unable to find 'hadoopversion' file at %s", (Object)hadoopVersionFileName);
            String hadoopVersion = Files.readString(hadoopVersionPath).trim();
            hHome = hadoopBase + "/hadoop-" + hadoopVersion;
        }
        if (!new File(hHomePath = Paths.get((String)hHome, new String[0]).toAbsolutePath().toString()).isDirectory()) {
            log.warn("Hadoop home was determined at {}, but either doesn't exist or is not a directory.", hHome);
        }
        return hHomePath;
    }

    private static URL findCoreSiteXml() {
        URL coreSiteUrl;
        ClassLoader cl = Configuration.class.getClassLoader();
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
            Preconditions.checkState((cl != null ? 1 : 0) != 0, (Object)"Unable to locate a classloader");
        }
        if ((coreSiteUrl = cl.getResource("core-site.xml")) != null) {
            if ("jar".equalsIgnoreCase(coreSiteUrl.getProtocol())) {
                log.warn("core-site.xml in found in a JAR file at {}.", (Object)coreSiteUrl);
            } else {
                log.debug("Found core-site.xml in classpath at {}.", (Object)coreSiteUrl);
            }
        } else {
            log.warn("core-site.xml in not found in classpath, searching MapR installation");
            String hHome = Installation.getHadoopHome();
            Path coreSitePath = Paths.get(hHome, "/etc/hadoop/core-site.xml");
            if (!Files.exists(coreSitePath, new LinkOption[0])) {
                log.warn("core-site.xml was determined at {} but does not exist.", (Object)coreSitePath);
            }
            coreSiteUrl = coreSitePath.toUri().toURL();
        }
        return coreSiteUrl;
    }

    public static void main(String[] args) {
        System.out.println(Installation.isOsWindows());
        System.out.println(Installation.getMapRHome());
        System.out.println(Installation.getMaprConfDir());
        System.out.println(Installation.getMaprClusterCfgLocation());
        System.out.println(Installation.getHadoopHome());
        System.out.println(Installation.getCoreSiteXmlURL());
    }

    public static boolean isOsWindows() {
        return osWindows;
    }

    public static String getMapRHome() {
        return mapRHome;
    }

    public static String getMaprConfDir() {
        return maprConfDir;
    }

    public static String getMaprClusterCfgLocation() {
        return maprClusterCfgLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHadoopHome() {
        Object value = hadoopHome.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = hadoopHome;
            synchronized (atomicReference) {
                value = hadoopHome.get();
                if (value == null) {
                    String actualValue = Installation.findHadoopHome();
                    value = actualValue == null ? hadoopHome : actualValue;
                    hadoopHome.set(value);
                }
            }
        }
        return (String)(value == hadoopHome ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL getCoreSiteXmlURL() {
        Serializable value = coreSiteXmlURL.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = coreSiteXmlURL;
            synchronized (atomicReference) {
                value = coreSiteXmlURL.get();
                if (value == null) {
                    URL actualValue = Installation.findCoreSiteXml();
                    value = actualValue == null ? coreSiteXmlURL : actualValue;
                    coreSiteXmlURL.set(value);
                }
            }
        }
        return (URL)(value == coreSiteXmlURL ? null : value);
    }
}

