/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.security;

import com.mapr.baseutils.utils.TTLCache;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyCloakUserGroupHelper {
    private static KeyCloakUserGroupHelper instance;
    private static final Logger LOG;
    private String keyCloakUrl = "";
    private String keyCloakRealm = "";
    private String keyCloakClientId = "";
    private String keyCloakClientSecret = "";
    private int PAGE_SIZE = 100;
    private TTLCache<String, Integer> usernameToUid;
    private TTLCache<Integer, String> uidToUsername;
    private TTLCache<String, List<Integer>> usernameToGids;
    private TTLCache<Integer, String> gidToGroupname;
    private TTLCache<String, Integer> groupnameToGid;
    private TTLCache<String, String> userNameToUuid;
    private TTLCache<String, String> groupNameToUuid;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KeyCloakUserGroupHelper getInstance(int expiry) {
        if (instance != null) return instance;
        Class<KeyCloakUserGroupHelper> clazz = KeyCloakUserGroupHelper.class;
        synchronized (KeyCloakUserGroupHelper.class) {
            if (instance != null) return instance;
            instance = new KeyCloakUserGroupHelper(expiry);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public KeyCloakUserGroupHelper(int expiry) {
        this.usernameToUid = new TTLCache(expiry);
        this.uidToUsername = new TTLCache(expiry);
        this.usernameToGids = new TTLCache(expiry);
        this.gidToGroupname = new TTLCache(expiry);
        this.groupnameToGid = new TTLCache(expiry);
        this.userNameToUuid = new TTLCache(expiry);
        this.groupNameToUuid = new TTLCache(expiry);
    }

    public KeyCloakUserGroupHelper() {
    }

    public void setKeyCloakUrlandRealm(String endPoint) {
        String[] split = this.getUrlAndRealm(endPoint, "/");
        if (split.length == 2) {
            this.keyCloakUrl = split[0];
            this.keyCloakRealm = split[1];
        }
    }

    public void setkeyCloakUrl(String keyCloakUrl) {
        this.keyCloakUrl = keyCloakUrl;
    }

    public String getkeyCloakUrl() {
        return this.keyCloakUrl;
    }

    public void setkeyCloakRealm(String keyCloakRealm) {
        this.keyCloakRealm = keyCloakRealm;
    }

    public String getkeyCloakRealm() {
        return this.keyCloakRealm;
    }

    public void setkeyCloakClientId(String keyCloakClientId) {
        this.keyCloakClientId = keyCloakClientId;
    }

    public String getkeyCloakClientId() {
        return this.keyCloakClientId;
    }

    public void setkeyCloakClientSecret(String keyCloakClientSecret) {
        this.keyCloakClientSecret = keyCloakClientSecret;
    }

    public String getkeyCloakClientSecret() {
        return this.keyCloakClientSecret;
    }

    public KeyCloakUserGroupHelper(String endPoint, String clientId, String clientSecret) {
        String[] split = this.getUrlAndRealm(endPoint, "/");
        if (split.length == 2) {
            this.keyCloakUrl = split[0];
            this.keyCloakRealm = split[1];
        }
        this.keyCloakClientId = clientId;
        this.keyCloakClientSecret = clientSecret;
    }

    public String[] getUrlAndRealm(String endPoint, String delimiter) {
        int lastDelimiterIndex = endPoint.lastIndexOf(delimiter);
        int secondToLastDelimiterIndex = -1;
        if (lastDelimiterIndex != -1) {
            secondToLastDelimiterIndex = endPoint.lastIndexOf(delimiter, lastDelimiterIndex - 1);
        }
        if (secondToLastDelimiterIndex == -1) {
            return new String[]{endPoint};
        }
        return new String[]{endPoint.substring(0, secondToLastDelimiterIndex), endPoint.substring(lastDelimiterIndex + delimiter.length())};
    }

    public int getUserId(String username) {
        Integer cachedUid = this.usernameToUid.get(username);
        if (cachedUid != null) {
            LOG.debug("Found entry in usernameToUid cache");
            LOG.debug("UID is :" + cachedUid);
            return cachedUid;
        }
        try {
            LOG.debug("User name is {}, Other variables are url {}, realm {}, clientid {}, clientsecret {}", new Object[]{username, this.keyCloakUrl, this.keyCloakRealm, this.keyCloakClientId, this.keyCloakClientSecret});
            String token = this.fetchTokenFromKeycloak();
            LOG.debug("token is :" + token);
            String response = this.fetchUsingQuery("username", username, token);
            String uid = this.getAttr(response, "uid", "username", username);
            LOG.debug("UID is :" + uid);
            int uidInt = Integer.valueOf(uid);
            this.usernameToUid.put(username, uidInt);
            return uidInt;
        }
        catch (Exception e) {
            LOG.error("User not found with username {} " + e.getMessage(), (Object)username);
            return -2;
        }
    }

    public int[] getGroups(String username) {
        List<Integer> cachedGids = this.usernameToGids.get(username);
        if (cachedGids != null) {
            LOG.debug("Found entry in usernameToGids cache");
            int[] allGids = cachedGids.stream().mapToInt(Integer::intValue).toArray();
            LOG.debug("Gids are :" + allGids);
            return allGids;
        }
        try {
            String token = this.fetchTokenFromKeycloak();
            LOG.debug("token is :" + token);
            String response = this.fetchUsingQuery("username", username, token);
            String keyid = this.getValue(response, "id", "username", username);
            response = this.fetchGroupsUsingKeyCloakUid(keyid, token);
            List<Integer> gids = this.extractKeyCloakGid(response);
            if (gids.size() > 0) {
                this.usernameToGids.put(username, gids);
            }
            int[] allGids = gids.stream().mapToInt(Integer::intValue).toArray();
            LOG.debug("Gids are :" + allGids);
            return allGids;
        }
        catch (Exception e) {
            LOG.error("Groups not found for username " + username + " Got exception: " + e.getMessage());
            return null;
        }
    }

    public static int[] convertStringToIntArray(String jsonString) {
        JSONArray jsonArray = new JSONArray(jsonString);
        int[] intArray = new int[jsonArray.length()];
        for (int i = 0; i < jsonArray.length(); ++i) {
            intArray[i] = Integer.parseInt(jsonArray.getString(i));
        }
        return intArray;
    }

    public int getGroupId(String groupname) {
        Integer cachedGid = this.groupnameToGid.get(groupname);
        if (cachedGid != null) {
            LOG.debug("Found entry in groupnameToGid cache");
            LOG.debug("GID is :" + cachedGid);
            return cachedGid;
        }
        try {
            String token = this.fetchTokenFromKeycloak();
            String response = this.fetchGroupUsingQuery(groupname, token);
            String id = this.getValue(response, "id", "name", groupname);
            response = this.fetchGroupUsingId(id, token);
            String gid = this.getAttrFromObject(response, "gidNumber");
            Integer gidInt = Integer.valueOf(gid);
            this.groupnameToGid.put(groupname, gidInt);
            LOG.debug("GID is :" + gidInt);
            return gidInt;
        }
        catch (Exception e) {
            LOG.error("Group Not found with groupname: " + groupname + "Got Exception: " + e.getMessage());
            return -1;
        }
    }

    public String getUsername(int uid) {
        String cachedUsername = this.uidToUsername.get(uid);
        if (cachedUsername != null) {
            LOG.debug("Found entry in uidToUsername cache");
            LOG.debug("Username is :" + cachedUsername);
            return cachedUsername;
        }
        try {
            String token = this.fetchTokenFromKeycloak();
            String response = this.fetchUsingQuery("uid", String.valueOf(uid), token);
            String username = this.getValueForMatchingAttribute(response, "username", "uid", String.valueOf(uid));
            if (username.length() > 0) {
                this.uidToUsername.put(uid, username);
            }
            LOG.debug("Username is :" + username);
            return username;
        }
        catch (Exception e) {
            LOG.error("User Not found with uid " + uid + " Got Exception:" + e.getMessage());
            return "";
        }
    }

    public String getGroupname(int gid) {
        String cachedGroupname = this.gidToGroupname.get(gid);
        if (cachedGroupname != null) {
            LOG.debug("Found entry in gidToGroupname cache");
            LOG.debug("Groupname is :" + cachedGroupname);
            return cachedGroupname;
        }
        try {
            String token = this.fetchTokenFromKeycloak();
            this.fetchAllGroups(token);
            String groupName = this.gidToGroupname.getOrDefault(gid, "");
            if (groupName.length() > 0) {
                this.gidToGroupname.put(gid, groupName);
            }
            return groupName;
        }
        catch (Exception e) {
            LOG.error(String.format("Group Not found with gid {} Got Exception:", gid) + e.getMessage());
            return "";
        }
    }

    private void fetchAllGroups(String token) throws Exception {
        CloseableHttpClient client = HttpClients.createDefault();
        int firstResult = 0;
        while (true) {
            String url = String.format(this.keyCloakUrl + "/admin/realms/" + this.keyCloakRealm + "/groups?first=" + firstResult + "&max=" + this.PAGE_SIZE, new Object[0]);
            HttpGet get = new HttpGet(url);
            get.setHeader("Authorization", "Bearer " + token);
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)get);){
                HttpEntity entity;
                String responseString;
                JSONArray groups;
                LOG.debug("Response Code " + response.getStatusLine().getStatusCode() + "URL" + url);
                if (response.getStatusLine().getStatusCode() != 200 || (groups = new JSONArray(responseString = EntityUtils.toString((HttpEntity)(entity = response.getEntity()), (String)"UTF-8"))).length() == 0) break;
                this.processGroups(groups, token);
            }
            firstResult += this.PAGE_SIZE;
        }
    }

    private void processGroups(JSONArray groups, String token) {
        try {
            for (int i = 0; i < groups.length(); ++i) {
                JSONObject jsonObject = groups.getJSONObject(i);
                String id = jsonObject.getString("id");
                String groupName = jsonObject.getString("name");
                String response = this.fetchGroupUsingId(id, token);
                String gid = this.getAttrFromObject(response, "gidNumber");
                this.gidToGroupname.put(Integer.valueOf(gid), groupName);
            }
        }
        catch (Exception e) {
            LOG.error("Exception while queryin groups " + e.getMessage());
        }
    }

    public String[] getGroupInfo(String groupName) {
        return new String[]{"aa", "bb"};
    }

    private String getValue(String response, String key, String query, String value) {
        JSONArray jsonArray = new JSONArray(response);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String valInResponse = jsonObject.getString(query);
            if (!valInResponse.equals(value)) continue;
            LOG.debug(String.format("Got matching value for query: %s value: %s and key: %s", query, value, key));
            return jsonObject.getString(key);
        }
        return "";
    }

    private String getValueForMatchingAttribute(String response, String key, String query, String value) {
        JSONArray jsonArray = new JSONArray(response);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            JSONObject attributes = jsonObject.getJSONObject("attributes");
            String valInResponse = attributes.getJSONArray(query).getString(0);
            if (!valInResponse.equals(value)) continue;
            LOG.debug(String.format("Got matching value for query: %s value: %s and key: %s", query, value, key));
            return jsonObject.getString(key);
        }
        return "";
    }

    private String getAttr(String response, String attr, String query, String value) {
        JSONArray jsonArray = new JSONArray(response);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String valInResponse = jsonObject.getString(query);
            if (!value.equals(valInResponse)) continue;
            LOG.debug(String.format("Got matching value for query: %s value: %s and attr: %s", query, value, attr));
            JSONObject attributes = jsonObject.getJSONObject("attributes");
            String val = attributes.getJSONArray(attr).getString(0);
            return val;
        }
        return "";
    }

    private List<Integer> extractKeyCloakGid(String response) {
        try {
            ArrayList<Integer> gids = new ArrayList<Integer>();
            JSONArray groups = new JSONArray(response);
            for (int i = 0; i < groups.length(); ++i) {
                JSONObject jsonObject = groups.getJSONObject(i);
                String groupName = jsonObject.getString("name");
                int gid = this.getGroupId(groupName);
                gids.add(gid);
            }
            return gids;
        }
        catch (Exception e) {
            LOG.error("Exception while queryin groups " + e.getMessage());
            return null;
        }
    }

    private String getAttrFromObject(String response, String attr) {
        JSONObject jsonObject = new JSONObject(response);
        JSONObject attributes = jsonObject.getJSONObject("attributes");
        String val = attributes.getJSONArray(attr).getString(0);
        LOG.debug(val);
        return val;
    }

    private String getAttrList(String response, String attr) {
        JSONArray jsonArray = new JSONArray(response);
        JSONObject jsonObject = jsonArray.getJSONObject(0);
        JSONObject attributes = jsonObject.getJSONObject("attributes");
        String val = attributes.getJSONArray(attr).toString();
        return val;
    }

    public String fetchTokenFromKeycloakUsingParams(List<BasicNameValuePair> params) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        CloseableHttpClient client = HttpClients.createDefault();
        String url = this.keyCloakUrl + "/realms/" + this.keyCloakRealm + "/protocol/openid-connect/token";
        HttpPost post = new HttpPost(url);
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        String access_token = "";
        try (CloseableHttpResponse response = client.execute((HttpUriRequest)post);){
            if (response.getStatusLine().getStatusCode() == 200) {
                HttpEntity entity = response.getEntity();
                String responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                JSONObject json = new JSONObject(responseString);
                access_token = json.getString("access_token");
            }
            String string = access_token;
            return string;
        }
    }

    public String fetchTokenFromKeycloak() throws IOException, NoSuchAlgorithmException, KeyManagementException {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("grant_type", "client_credentials"));
        params.add(new BasicNameValuePair("client_id", this.keyCloakClientId));
        params.add(new BasicNameValuePair("client_secret", this.keyCloakClientSecret));
        return this.fetchTokenFromKeycloakUsingParams(params);
    }

    private String fetchGroupsUsingKeyCloakUid(String id, String token) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        CloseableHttpClient client = HttpClients.createDefault();
        String url = String.format(this.keyCloakUrl + "/admin/realms/" + this.keyCloakRealm + "/users/%s/groups", id);
        HttpGet get = new HttpGet(url);
        get.setHeader("Authorization", "Bearer " + token);
        try (CloseableHttpResponse response = client.execute((HttpUriRequest)get);){
            LOG.debug("Response Code " + response.getStatusLine().getStatusCode() + "URL" + url);
            if (response.getStatusLine().getStatusCode() == 200) {
                String responseString;
                HttpEntity entity = response.getEntity();
                String string = responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                return string;
            }
            String string = "";
            return string;
        }
    }

    private String fetchUsingQuery(String query, String val, String token) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        CloseableHttpClient client = HttpClients.createDefault();
        String url = String.format(this.keyCloakUrl + "/admin/realms/" + this.keyCloakRealm + "/users?q=%s:" + val, query);
        HttpGet get = new HttpGet(url);
        get.setHeader("Authorization", "Bearer " + token);
        try (CloseableHttpResponse response = client.execute((HttpUriRequest)get);){
            LOG.debug("Response Code " + response.getStatusLine().getStatusCode() + "URL" + url);
            if (response.getStatusLine().getStatusCode() == 200) {
                String responseString;
                HttpEntity entity = response.getEntity();
                String string = responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                return string;
            }
            String string = "";
            return string;
        }
    }

    private String fetchGroupUsingQuery(String groupname, String token) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        CloseableHttpClient client = HttpClients.createDefault();
        String url = String.format(this.keyCloakUrl + "/admin/realms/" + this.keyCloakRealm + "/groups?search=%s", groupname);
        HttpGet get = new HttpGet(url);
        get.setHeader("Authorization", "Bearer " + token);
        try (CloseableHttpResponse response = client.execute((HttpUriRequest)get);){
            LOG.debug("Response Code " + response.getStatusLine().getStatusCode() + "URL" + url);
            if (response.getStatusLine().getStatusCode() == 200) {
                String responseString;
                HttpEntity entity = response.getEntity();
                String string = responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                return string;
            }
            String string = "";
            return string;
        }
    }

    private String fetchGroupUsingId(String id, String token) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        CloseableHttpClient client = HttpClients.createDefault();
        String url = String.format(this.keyCloakUrl + "/admin/realms/" + this.keyCloakRealm + "/groups/%s", id);
        HttpGet get = new HttpGet(url);
        get.setHeader("Authorization", "Bearer " + token);
        try (CloseableHttpResponse response = client.execute((HttpUriRequest)get);){
            LOG.debug("Response Code " + response.getStatusLine().getStatusCode() + "URL" + url);
            if (response.getStatusLine().getStatusCode() == 200) {
                String responseString;
                HttpEntity entity = response.getEntity();
                String string = responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                return string;
            }
            String string = "";
            return string;
        }
    }

    private String excecuteGet(String uri) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        CloseableHttpClient client = HttpClients.createDefault();
        String token = this.fetchTokenFromKeycloak();
        String url = String.format(this.keyCloakUrl + "/admin/realms/" + this.keyCloakRealm + uri, new Object[0]);
        HttpGet get = new HttpGet(url);
        get.setHeader("Authorization", "Bearer " + token);
        try (CloseableHttpResponse response = client.execute((HttpUriRequest)get);){
            LOG.debug("Response Code " + response.getStatusLine().getStatusCode() + "URL" + url);
            if (response.getStatusLine().getStatusCode() == 200) {
                HttpEntity entity = response.getEntity();
                String responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                LOG.debug("Response from keycloak: " + responseString);
                String string = responseString;
                return string;
            }
            String string = "";
            return string;
        }
    }

    public String getUuidForUserName(String username) {
        String cachedUuid = this.userNameToUuid.get(username);
        if (cachedUuid != null) {
            LOG.debug("Found entry in userNameToUuid cache");
            LOG.debug("UUID is :" + cachedUuid);
            return cachedUuid;
        }
        try {
            LOG.debug("User name is {}, Other variables are url {}, realm {}, clientid {}, clientsecret {}", new Object[]{username, this.keyCloakUrl, this.keyCloakRealm, this.keyCloakClientId, this.keyCloakClientSecret});
            String token = this.fetchTokenFromKeycloak();
            LOG.debug("token is :" + token);
            String response = this.fetchUsingQuery("username", username, token);
            if (response == null || response.trim().isEmpty()) {
                return null;
            }
            String uuid = this.getValue(response, "id", "username", username);
            LOG.debug("UUID is :" + uuid);
            this.userNameToUuid.put(username, uuid);
            return uuid;
        }
        catch (Exception e) {
            LOG.error("User not found with username {} " + e.getMessage(), (Object)username);
            return null;
        }
    }

    public String getUuidForGroupName(String groupname) {
        String cachedUuid = this.groupNameToUuid.get(groupname);
        if (cachedUuid != null) {
            LOG.debug("Found entry in groupNameToUuid cache");
            LOG.debug("UUID is :" + cachedUuid);
            return cachedUuid;
        }
        try {
            String token = this.fetchTokenFromKeycloak();
            String response = this.fetchGroupUsingQuery(groupname, token);
            String uuid = this.getValue(response, "id", "name", groupname);
            this.groupNameToUuid.put(groupname, uuid);
            LOG.debug("UUID is :" + uuid);
            return uuid;
        }
        catch (Exception e) {
            LOG.error("Group Not found with groupname: " + groupname + "Got Exception: " + e.getMessage());
            return null;
        }
    }

    public List<String> getRealmMappingsForUser(String userName) {
        String uuid = this.getUuidForUserName(userName);
        if (uuid == null || uuid.trim().isEmpty()) {
            return null;
        }
        try {
            String response = this.excecuteGet("/users/" + uuid + "/role-mappings");
            JSONObject jsonObject = new JSONObject(response);
            JSONArray realmMappings = jsonObject.getJSONArray("realmMappings");
            LOG.debug("Got realmMappings: {}", (Object)realmMappings);
            return this.extractListAttr(realmMappings, "name");
        }
        catch (Exception e) {
            LOG.error("Could not fetch role mapping for: " + userName + " . Error: " + e.getMessage());
            return null;
        }
    }

    private List<String> extractListAttr(JSONArray arr, String atr) {
        try {
            ArrayList<String> attributes = new ArrayList<String>();
            for (int i = 0; i < arr.length(); ++i) {
                JSONObject mapping = arr.getJSONObject(i);
                String name = mapping.getString(atr);
                attributes.add(name);
            }
            LOG.debug("exracted attributes: " + attributes);
            return attributes;
        }
        catch (Exception e) {
            LOG.error("Exception while parsing array " + e.getMessage());
            return null;
        }
    }

    static {
        LOG = LoggerFactory.getLogger(KeyCloakUserGroupHelper.class);
    }
}

