/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils;

import java.util.BitSet;

public class BitSetBytesHelperUtils {
    public static byte[] toByteArray(BitSet bits) {
        byte[] bytes = new byte[(bits.length() + 7) / 8];
        for (int i = 0; i < bits.length(); ++i) {
            if (!bits.get(i)) continue;
            int n = bytes.length - i / 8 - 1;
            bytes[n] = (byte)(bytes[n] | 1 << i % 8);
        }
        return bytes;
    }

    public static BitSet fromByteArray(byte[] bytes) {
        BitSet bits = new BitSet();
        for (int i = 0; i < bytes.length * 8; ++i) {
            if ((bytes[bytes.length - i / 8 - 1] & 1 << i % 8) == 0) continue;
            bits.set(i);
        }
        return bits;
    }

    public static long convert(BitSet bits) {
        int i;
        long value = 0L;
        for (i = 0; i < bits.length() && i < 64; ++i) {
            value |= bits.get(i) ? 1L << i : 0L;
        }
        for (i = 64; i < bits.length(); ++i) {
            int j = i - 64;
            if (!bits.get(i) || bits.get(j)) continue;
            value |= 1L << j;
        }
        return value;
    }

    public static BitSet convert(long value) {
        BitSet bits = new BitSet();
        int index = 0;
        while (value != 0L) {
            if (value % 2L != 0L) {
                bits.set(index);
            }
            ++index;
            value >>>= 1;
        }
        return bits;
    }
}

