/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.security.simplesasl;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.apache.commons.codec.binary.Base64;

public class SimpleSaslClient
implements SaslClient {
    private boolean completed;
    private final String currentId;

    public SimpleSaslClient() {
        AccessControlContext context = AccessController.getContext();
        Subject subject = Subject.getSubject(context);
        if (subject != null && !subject.getPrincipals().isEmpty()) {
            Principal clientPrincipal = subject.getPrincipals().iterator().next();
            this.currentId = clientPrincipal.getName();
        } else {
            this.currentId = "";
        }
    }

    @Override
    public void dispose() throws SaslException {
    }

    @Override
    public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
        if (this.completed) {
            throw new IllegalStateException("SimpleSasl authentication already completed");
        }
        byte[] authRequestBytes = Base64.encodeBase64((byte[])this.currentId.getBytes());
        this.completed = true;
        return authRequestBytes;
    }

    @Override
    public String getMechanismName() {
        return "SIMPLE-SECURITY";
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        return null;
    }

    @Override
    public boolean hasInitialResponse() {
        return true;
    }

    @Override
    public boolean isComplete() {
        return this.completed;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        return incoming;
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        return outgoing;
    }

    public static class SaslSimpleClientFactory
    implements SaslClientFactory {
        @Override
        public String[] getMechanismNames(Map<String, ?> props) {
            return new String[]{"SIMPLE-SECURITY"};
        }

        @Override
        public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
            if (mechanisms != null) {
                for (String mechanism : mechanisms) {
                    if (!"SIMPLE-SECURITY".equals(mechanism)) continue;
                    return new SimpleSaslClient();
                }
            }
            return null;
        }
    }
}

