/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.sso.roles;

import java.util.HashMap;
import java.util.Map;

public enum SSORole {
    DEVELOPER("developer"),
    INFRASTRUCTURE_ADMIN("infrastructure-admin"),
    FABRIC_MANAGER("fabric-manager");

    private static final Map<String, SSORole> roleNameMap;
    public final String roleName;

    private SSORole(String roleName) {
        this.roleName = roleName;
    }

    public static SSORole getByName(String roleName) {
        return roleNameMap.get(roleName);
    }

    public String getRoleName() {
        return this.roleName;
    }

    static {
        roleNameMap = new HashMap<String, SSORole>();
        for (SSORole ssoRole : SSORole.values()) {
            roleNameMap.put(ssoRole.roleName, ssoRole);
        }
    }
}

