/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.fsrpcutils;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.baseutils.fsrpcutils.CidInfo;
import com.mapr.baseutils.fsrpcutils.GetMsgStatus;
import com.mapr.baseutils.fsrpcutils.Utils;
import com.mapr.baseutils.utils.Util;
import com.mapr.fs.Rpc;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import com.mapr.security.JNISecurity;
import com.mapr.security.MaprSecurityAuthException;
import com.mapr.security.MaprSecurityException;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSRpcUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FSRpcUtils.class);
    private static final int maxCidEntries = 0x10000000;
    private String clusterName;
    private Security.CredentialsMsg creds;
    private int maxRetry;
    private int srcPort;
    private Security.ServerKeyType keyToUse;
    Map<Integer, CidInfo> cidHash;
    ReentrantLock lock;

    public FSRpcUtils(String clusterName, Security.CredentialsMsg creds, int maxRetry, Security.ServerKeyType keyToUse, int srcPort) {
        this(clusterName, creds, maxRetry, keyToUse, srcPort, 0x10000000);
    }

    public FSRpcUtils(String clusterName, Security.CredentialsMsg creds, int maxRetry, Security.ServerKeyType keyToUse, int srcPort, final int maxCapacity) {
        this.clusterName = clusterName;
        this.creds = creds;
        this.maxRetry = maxRetry;
        this.keyToUse = keyToUse;
        this.srcPort = srcPort;
        this.cidHash = new LinkedHashMap<Integer, CidInfo>(32, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Integer, CidInfo> eldest) {
                return this.size() > maxCapacity;
            }
        };
        this.lock = new ReentrantLock();
    }

    public boolean CHasMServer(int cid) {
        CidInfo cidInfo = null;
        cidInfo = this.cidHash.get(cid);
        if (cidInfo == null) {
            return false;
        }
        if (cidInfo.cInfo == null) {
            return false;
        }
        return cidInfo.cInfo.hasMServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int SendRequestToCid(int cid, boolean toMaster, int programid, int procid, MessageLite req, GetMsgStatus getMsgStatus) throws Exception {
        int nretry = 0;
        int status = 0;
        int sleepTimeInMillis = 5000;
        this.lock.lock();
        CidInfo cidInfo = null;
        try {
            cidInfo = this.cidHash.get(cid);
            if (cidInfo == null) {
                cidInfo = new CidInfo(cid);
                this.cidHash.put(cid, cidInfo);
            }
        }
        finally {
            this.lock.unlock();
        }
        do {
            cidInfo.rwLock.readLock().lock();
            if (cidInfo.needUpdate(toMaster)) {
                cidInfo.rwLock.readLock().unlock();
                cidInfo.rwLock.writeLock().lock();
                status = 0;
                if (cidInfo.needUpdate(toMaster)) {
                    status = this.UpdateCidInfo(cid, cidInfo);
                }
                cidInfo.rwLock.writeLock().unlock();
                if (status == 0 && cidInfo.needUpdate(toMaster)) {
                    LOG.info("Could not get the required server for cid " + cid + " returning EAGAIN caller should retry after waiting for sometime.  current cid info" + cidInfo);
                    return 11;
                }
                if (status == 11 && nretry < this.maxRetry) {
                    ++nretry;
                    try {
                        Thread.sleep(sleepTimeInMillis);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                if (status == 0) continue;
                LOG.error("Failed to update cid info for container " + cid + " failing with error " + status);
                return status;
            }
            status = this.SendRequestToServer(cidInfo, toMaster, programid, procid, req, getMsgStatus);
            cidInfo.rwLock.readLock().unlock();
            if (status != 0) {
                LOG.error("SendRequestToServer failed to send request cid " + cid + " programid " + programid + " procid " + procid + " status " + status);
            }
            if (status == 11 && nretry < this.maxRetry) {
                ++nretry;
                try {
                    Thread.sleep(sleepTimeInMillis);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            if (status != 0) {
                LOG.error("SendRequestToServer failing the send request cid " + cid + " programid " + programid + " procid " + procid + " status " + status + " nretry " + nretry + " cidinfo " + cidInfo + " toMaster " + toMaster);
            }
            return status;
        } while (nretry < this.maxRetry);
        LOG.error("SendRequestToServer failing the send request cid " + cid + " programid " + programid + " procid " + procid + " status " + status + " nretry " + nretry + " cidinfo " + cidInfo + " toMaster " + toMaster);
        return status;
    }

    private int SendRequestToServer(CidInfo cidInfo, boolean toMaster, int programid, int procid, MessageLite req, GetMsgStatus getMsgStatus) throws Exception {
        Common.Server s = null;
        s = toMaster ? cidInfo.getMasterServer() : cidInfo.getNextReplicaServer();
        int status = this.SendRequestToServer(s, programid, procid, req, getMsgStatus);
        if (status != 0) {
            if (status == 11) {
                return status;
            }
            if (status == 19 || status == 119 || status == 3 || status == 104 || status == 20028 || status == 134) {
                status = this.ReportServerFailure(cidInfo, toMaster, s);
                if (status == 0) {
                    status = 11;
                }
                return status;
            }
            return 0;
        }
        return 0;
    }

    public int SendRequestToServer(Common.Server s, int programid, int procid, MessageLite req, GetMsgStatus getMsgStatus) throws Exception {
        MutableInt mutableerr;
        Security.TicketAndKey ticket;
        if (s == null) {
            LOG.error("Null server passed to send request");
            return 22;
        }
        List<Common.IPAddress> ipList = Util.getIPAddressList(s, false);
        byte[][] ips = new byte[ipList.size()][];
        for (int i = 0; i < ipList.size(); ++i) {
            Common.IPAddress ipAddress = ipList.get(i);
            ips[i] = ipAddress.hasHostIpAddr() ? Util.ipAddrMsgToByteArray(ipAddress.getHostIpAddr()) : Util.intToByteArray(ipAddress.getHost());
        }
        if (JNISecurity.IsSecurityEnabled(this.clusterName) && (ticket = Security.GetTicketAndKeyForCluster(this.keyToUse, this.clusterName, mutableerr = new MutableInt())) == null) {
            String ticketFile = CLDBRpcCommonUtils.getInstance().getPathToServerTicketFile();
            int err = Security.SetTicketAndKeyFile(ticketFile);
            if (err != 0) {
                LOG.error("Error " + err + " in loading " + ticketFile);
            }
            if ((ticket = Security.GetTicketAndKeyForCluster(this.keyToUse, this.clusterName, mutableerr)) == null) {
                LOG.error("Error " + mutableerr.GetValue() + " in finding ticket for cluster: " + this.clusterName);
                return 11;
            }
        }
        int flags = CLDBRpcCommonUtils.getInstance().getFlagsForBinding(this.clusterName, true);
        int port = Util.getPort(s, 0);
        long binding = this.srcPort > 0 ? Rpc.createBindingForIpsWithSrcPort2(ips, port, this.srcPort, this.clusterName, this.keyToUse.getNumber(), flags) : Rpc.createBindingForIps2(ips, port, this.clusterName, this.keyToUse.getNumber(), flags);
        byte[] data = null;
        try {
            data = Rpc.sendRequest(binding, programid, procid, req);
            if (data == null) {
                LOG.info("Request send failed for program id " + programid + " procedureid " + procid + " server " + Utils.PrintServerIpAddress(s));
                return 104;
            }
            getMsgStatus.init(data);
        }
        catch (Exception e) {
            LOG.error("Request send failed for program id " + programid + " procedureid " + procid + " server " + Utils.PrintServerIpAddress(s), (Throwable)e);
            if (e instanceof MaprSecurityAuthException) {
                return 134;
            }
            if (e instanceof MaprSecurityException) {
                return 11;
            }
            return 9;
        }
        int status = getMsgStatus.GetStatus();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request send for program id " + programid + " procedureid " + procid + " server " + Utils.PrintServerIpAddress(s) + " returned status " + status);
        }
        return status;
    }

    private int ReportServerFailure(CidInfo cidInfo, boolean toMaster, Common.Server s) throws Exception {
        int status = 0;
        cidInfo.rwLock.readLock().unlock();
        cidInfo.rwLock.writeLock().lock();
        if (toMaster) {
            status = this.ReportMasterServerFailure(cidInfo, toMaster, s);
        } else {
            cidInfo.incNextReplicaServer();
        }
        cidInfo.rwLock.writeLock().unlock();
        cidInfo.rwLock.readLock().lock();
        return status;
    }

    private int ReportMasterServerFailure(CidInfo cidInfo, boolean toMaster, Common.Server s) throws Exception {
        CLDBProto.ContainerOnFileServerFailResponse resp;
        CLDBProto.ContainerOnFileServerFailRequest.Builder req = CLDBProto.ContainerOnFileServerFailRequest.newBuilder();
        byte[] data = null;
        int cid = cidInfo.cid;
        req.setContainerId(cid);
        req.setCreds(this.creds);
        req.setServerId(s.getServerId());
        data = CLDBRpcCommonUtils.getInstance().sendRequest(this.clusterName, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ContainerOnFileServerFailProc.getNumber(), (MessageLite)req.build(), CLDBProto.ContainerOnFileServerFailResponse.class, this.keyToUse, this.srcPort);
        if (data == null) {
            LOG.error("Can not talk to CLDB while reporting fileserver failure response  clustername " + this.clusterName + " cid " + cid);
            return 11;
        }
        try {
            resp = CLDBProto.ContainerOnFileServerFailResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error("Exception in reporting fileserver failure response  clustername " + this.clusterName + " cid " + cid, (Throwable)e);
            return 10003;
        }
        if (resp.getStatus() != 0) {
            LOG.error("Failed to report fileserver failure  clustername " + this.clusterName + " cid " + cid + " error " + resp.getStatus());
            return resp.getStatus();
        }
        cidInfo.UpdateContainerInfo(resp.getContainer());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updated the container info " + cidInfo);
        }
        return 0;
    }

    private int UpdateCidInfo(int cid, CidInfo cidInfo) throws Exception {
        CLDBProto.ContainerLookupResponse resp;
        CLDBProto.ContainerLookupRequest.Builder req = CLDBProto.ContainerLookupRequest.newBuilder();
        byte[] data = null;
        req.addContainerId(cid);
        req.setCreds(this.creds);
        data = CLDBRpcCommonUtils.getInstance().sendRequest(this.clusterName, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ContainerLookupProc.getNumber(), (MessageLite)req.build(), CLDBProto.ContainerLookupResponse.class, this.keyToUse, this.srcPort);
        if (data == null) {
            return 11;
        }
        try {
            resp = CLDBProto.ContainerLookupResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error("Exception in process container lookup response  clustername " + this.clusterName + " cid " + cid, (Throwable)e);
            return 10003;
        }
        if (resp.getStatus() != 0) {
            LOG.error("Failed to get container lookup response  clustername " + this.clusterName + " cid " + cid + " error " + resp.getStatus());
            return resp.getStatus();
        }
        cidInfo.UpdateContainerInfo((CLDBProto.ContainerInfo)resp.getContainersList().get(0));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updated the container info " + cidInfo);
        }
        return 0;
    }
}

