/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.web.security;

import com.google.common.base.Strings;

public enum KeystoreFileType {
    JKS(".jks"),
    PEM(".pem"),
    PKCS12(".p12"),
    BCFKS(".bcfks");

    private final String defaultFileExtension;
    private final String name;

    private KeystoreFileType(String defaultFileExtension) {
        this.defaultFileExtension = defaultFileExtension;
        this.name = this.name().toLowerCase();
    }

    public static KeystoreFileType fromName(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            return null;
        }
        return KeystoreFileType.valueOf(name.toUpperCase());
    }

    public String getDefaultFileExtension() {
        return this.defaultFileExtension;
    }

    public String getName() {
        return this.name;
    }
}

