/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.login;

import com.mapr.baseutils.JVMProperties;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordAuthentication {
    public static final String PASSWORD_PAM_JAAS_CONFIGUATION = "jpamLogin";
    private static Logger LOG;

    public static boolean authenticate(String user, String pass) {
        try {
            LoginContext ctx = new LoginContext(PASSWORD_PAM_JAAS_CONFIGUATION, new JAASCallbackHandler(user, pass));
            ctx.login();
        }
        catch (LoginException e) {
            LOG.info("Failed authentication for user " + user + ": " + e);
            LOG.debug("exception:", (Throwable)e);
            return false;
        }
        return true;
    }

    public static void main(String[] argv) throws Exception {
        ((org.apache.log4j.Logger)LOG).addAppender((Appender)new ConsoleAppender());
        String u = argv[0];
        String p = argv[1];
        System.out.println("Authenticating user = " + u + " password = " + p);
        if (PasswordAuthentication.authenticate(u, p)) {
            System.out.println("Success.");
        } else {
            System.out.println("Failure.");
        }
    }

    static {
        JVMProperties.init();
        LOG = LoggerFactory.getLogger(PasswordAuthentication.class);
    }

    static class JAASCallbackHandler
    implements CallbackHandler {
        private String user;
        private String pass;

        public JAASCallbackHandler(String user, String pass) {
            this.user = user;
            this.pass = pass;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof NameCallback) {
                    ((NameCallback)callbacks[i]).setName(this.user);
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    ((PasswordCallback)callbacks[i]).setPassword(this.pass.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i], "unsupported callback - " + callbacks[i].getClass().getName());
            }
        }
    }
}

