/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.security;

import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.fs.proto.Security;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.security.AbstractMapRTicketGenerator;
import org.apache.hadoop.yarn.util.YarnAppUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRTicketGenerator
extends AbstractMapRTicketGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(MapRTicketGenerator.class);

    public void generateMapRLoginTicket(ApplicationId appId, String username, Configuration conf) throws IOException {
        String appIdStr = appId.toString();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path appStagingDir = YarnAppUtil.getRMStagingDir((String)appIdStr, (FileSystem)fs, (Configuration)conf);
        Path existingTicketPath = YarnAppUtil.getMapRTicketPath((Path)appStagingDir);
        boolean isExistingTicketExpired = false;
        FSDataInputStream fsin = null;
        if (fs.isFile(existingTicketPath)) {
            fsin = fs.open(existingTicketPath);
        }
        if (fsin != null) {
            try {
                MutableInt err = new MutableInt();
                String currentClusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
                Security.TicketAndKey ticketKey = Security.GetTicketAndKeyForCluster(Security.ServerKeyType.ServerKey, currentClusterName, err);
                if (!Security.IsTicketAndKeyUsable(ticketKey)) {
                    fsin.close();
                    fsin = null;
                    isExistingTicketExpired = true;
                    LOG.debug("Existing ticket " + existingTicketPath + " has expired. Closing input stream");
                }
            }
            catch (Throwable t) {
                throw new IOException("Getting expiry time for existing security ticket for app: " + appId + " and user: " + username + " failed", t);
            }
        }
        Path appSystemDir = YarnAppUtil.getRMSystemDir((String)appIdStr, (FileSystem)fs, (Configuration)conf);
        FileSystem.mkdirs((FileSystem)fs, (Path)appSystemDir, (FsPermission)YarnAppUtil.APP_DIR_PERMISSION);
        Path ticketPath = YarnAppUtil.getMapRTicketPath((Path)appSystemDir);
        FSDataOutputStream outTicket = FileSystem.create((FileSystem)fs, (Path)ticketPath, (FsPermission)new FsPermission(YarnAppUtil.APP_FILE_PERMISSION));
        long expiration = System.currentTimeMillis() + Long.parseLong(conf.get("yarn.mapr.ticket.expiration"));
        try {
            block20: {
                if (fsin != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Cloning MapR ticket for app: " + appId + " user: " + username + " at " + ticketPath);
                    }
                    try {
                        Security.CloneAndGenerateTicketFile((DataInputStream)fsin, expiration, (DataOutputStream)outTicket);
                    }
                    catch (IOException e) {
                        String errMsg = e.getMessage();
                        if (errMsg != null && errMsg.contains("62")) {
                            fsin.close();
                            fsin = null;
                            isExistingTicketExpired = true;
                        }
                        if (isExistingTicketExpired) break block20;
                        throw new IOException(e);
                    }
                }
            }
            if (fsin == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Generating MapR ticket for app: " + appId + " user: " + username + " at " + ticketPath);
                }
                Security.MergeAndGenerateTicketFile((DataInputStream)fsin, username, expiration, (DataOutputStream)outTicket);
                if (isExistingTicketExpired) {
                    LOG.debug("Deleting existing expired ticket: " + existingTicketPath);
                    fs.delete(existingTicketPath, true);
                }
            }
        }
        catch (Throwable t) {
            throw new IOException("Security Ticket for app: " + appId + " and user: " + username + " failed", t);
        }
        finally {
            if (fsin != null) {
                fsin.close();
            }
            outTicket.close();
            if (LOG.isDebugEnabled()) {
                LOG.error("Retained staged ticket dir from MFS: " + appStagingDir);
            }
        }
    }
}

