/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.security;

import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.fs.proto.Security;
import com.mapr.login.common.TicketOptionalParams;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.log4j.BasicConfigurator;

public class MapRCloneTicketTest {
    public static final long DEFAULT_MAPR_TICKET_EXPIRY = 604800000L;
    public static final String TEST_TICKET_FILE = "/tmp/ticket-file";
    public static final String TEST_KEY_FILE = "/tmp/key-file";

    public static void generateMapRLoginTicket() throws Exception {
        String userName = System.getProperty("user.name");
        System.out.println("Generating MapR ticket for user " + userName + " at /tmp/ticket-file");
        DataInputStream fsin = new DataInputStream(new FileInputStream(TEST_TICKET_FILE));
        DataOutputStream outTicket = new DataOutputStream(new FileOutputStream("/tmp/ticket-file.new"));
        long expiration = System.currentTimeMillis() + 604800000L;
        try {
            if (fsin != null) {
                System.out.println("Cloning existing ticket");
                Security.CloneAndGenerateTicketFile((DataInputStream)fsin, (long)expiration, (DataOutputStream)outTicket);
            }
        }
        catch (Throwable t) {
            throw new IOException("Security Ticket for user: " + userName + " failed", t);
        }
        finally {
            if (fsin != null) {
                fsin.close();
            }
            outTicket.close();
        }
    }

    public static void setUp() throws Exception {
        MutableInt err = new MutableInt();
        Security.Key k = Security.GenerateRandomKey();
        byte[] fileData = Security.EncodeDataForWritingToKeyFile((byte[])k.toByteArray(), (MutableInt)err);
        FileOutputStream fout = new FileOutputStream(TEST_KEY_FILE);
        fout.write(fileData);
        fout.write(new String("\n").getBytes("UTF-8"));
        fout.close();
        Security.SetKeyFile((Security.ServerKeyType)Security.ServerKeyType.ServerKey, (String)TEST_KEY_FILE);
        int[] gids = new int[]{0};
        TicketOptionalParams tOptionalParams = new TicketOptionalParams();
        tOptionalParams.setIsExternal(true);
        Security.TicketAndKey ticketAndKey = Security.GenerateTicketAndKey((Security.ServerKeyType)Security.ServerKeyType.ServerKey, (String)"root", (int)0, (int[])gids, (long)Security.MAX_EXPIRY_TIME, (long)0L, (TicketOptionalParams)tOptionalParams, (MutableInt)err);
        fileData = Security.EncodeDataForWritingToKeyFile((byte[])ticketAndKey.toByteArray(), (MutableInt)err);
        String clusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        System.out.println("Current cluster name is " + clusterName);
        fout = new FileOutputStream(TEST_TICKET_FILE);
        fout.write(clusterName.getBytes("UTF-8"));
        fout.write(new String(" ").getBytes("UTF-8"));
        fout.write(fileData);
        fout.write(new String("\n").getBytes("UTF-8"));
        fout.close();
        Security.SetTicketAndKeyFile((String)TEST_TICKET_FILE);
    }

    public static void main(String[] args) throws Exception {
        System.loadLibrary("MapRClient");
        BasicConfigurator.configure();
        MapRCloneTicketTest.setUp();
        System.out.println("Cloning MapR ticket");
        MapRCloneTicketTest.generateMapRLoginTicket();
        System.out.println("Successfully cloned MapR ticket at /tmp/ticket-file.new");
    }
}

