/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.cldbutils;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.BaseUtilsHelper;
import com.mapr.baseutils.Errno;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtilsException;
import com.mapr.baseutils.utils.Util;
import com.mapr.fs.Rpc;
import com.mapr.fs.ShimLoader;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import com.mapr.login.client.MapRLoginHttpsClient;
import com.mapr.security.JNISecurity;
import com.mapr.security.MaprSecurityAuthException;
import com.mapr.security.MaprSecurityException;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import com.mapr.security.UnixUserGroupHelper;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CLDBRpcCommonUtils {
    private int RPC_INTERNAL = 1;
    private int RPC_EXTERNAL = 2;
    private int RPC_CLIENT = 8;
    private int RPC_DISABLE_MERGE_IPS = 32;
    private static final Logger LOG = LoggerFactory.getLogger(CLDBRpcCommonUtils.class);
    private static final String MAPR_CLUSTER_FILE_NAME = "/conf/mapr-clusters.conf";
    private static final String MAPR_SERVER_TICKET_FILE_NAME = "/conf/maprserverticket";
    private static final int CLDB_PORT_DEFAULT = 7222;
    public static final String CLDB_LOCAL_HOST = "127.0.0.1";
    public static final String IPV6_CLDB_LOCAL_HOST = "::1";
    private boolean partOfServer = false;
    private boolean isCldbUsage = false;
    public static final int listenPortForPS = 30;
    public static final int listenPortForS3 = 40;
    public static final int listenPortForClusterGroup = 50;
    public static final int IPV4_ADDR_SIZE = 4;
    public static final int IPV6_ADDR_SIZE = 16;
    private Map<String, List<IpPort>> clustersMap = new ConcurrentHashMap<String, List<IpPort>>();
    private Map<String, List<IpPort>> clusterGroupIpPortMap = new ConcurrentHashMap<String, List<IpPort>>();
    private Map<String, List<IpPort>> originalClustersMap = new ConcurrentHashMap<String, List<IpPort>>();
    private Map<String, CLDBProto.ClusterGroupConf> clustersGroupMap = new ConcurrentHashMap<String, CLDBProto.ClusterGroupConf>();
    private Map<String, CLDBProto.ExternalServer> externalServerMap = new ConcurrentHashMap<String, CLDBProto.ExternalServer>();
    private static CLDBRpcCommonUtils s_instance;
    private Map<String, Common.IPType> clusterIpTypes = new ConcurrentHashMap<String, Common.IPType>();
    private volatile String defaultClusterName = "default";
    private String origClusterName;
    private Map<String, String> zkConnectStringMap = new HashMap<String, String>();
    private Map<String, String> hostMap = new ConcurrentHashMap<String, String>();
    private Boolean ipv6Support = false;

    private CLDBRpcCommonUtils() {
        this.loadMaprClusterConf();
    }

    public Boolean isIpv6Supported() {
        return this.ipv6Support;
    }

    public String getLocalHost() {
        return CLDB_LOCAL_HOST;
    }

    public static CLDBRpcCommonUtils getInstance() {
        return s_instance;
    }

    public synchronized void setPartOfServer(boolean partOfServer) {
        this.partOfServer = partOfServer;
    }

    public synchronized String getZkConnect() {
        if (this.defaultClusterName == null) {
            LOG.error("Default cluster name is null. Can not get ZK string");
            return null;
        }
        return this.getZkConnect(this.defaultClusterName);
    }

    public synchronized String getZkConnect(String clusterName) {
        if (clusterName == null || !this.clustersMap.containsKey(clusterName)) {
            this.reloadClusterMap(clusterName);
        }
        if (clusterName == null || !this.clustersMap.containsKey(clusterName)) {
            LOG.error("Invalid cluster name specified: " + clusterName);
            return null;
        }
        String zkConnectString = this.zkConnectStringMap.get(clusterName);
        if (zkConnectString != null) {
            return zkConnectString;
        }
        try {
            byte[] responseData = this.sendRequest(clusterName, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.IsCLDBMasterProc.getNumber(), (MessageLite)CLDBProto.isCLDBMasterRequest.newBuilder().build(), CLDBProto.isCLDBMasterResponse.class);
            if (responseData == null) {
                LOG.error("No data is received from any cldb");
                return null;
            }
            try {
                CLDBProto.isCLDBMasterResponse response = CLDBProto.isCLDBMasterResponse.parseFrom((byte[])responseData);
                if (response.getStatus() != 0) {
                    LOG.error("Non-valid status received from isCLDBMasterResponse: " + Errno.toString(response.getStatus()));
                }
                zkConnectString = response.getZkconnect();
                this.zkConnectStringMap.put(clusterName, zkConnectString);
                LOG.info("ZKConnect: " + zkConnectString);
                return zkConnectString;
            }
            catch (InvalidProtocolBufferException e) {
                LOG.error("Exception while parsing response from isCLDBMasterResponse", (Throwable)e);
                return null;
            }
        }
        catch (Throwable t) {
            LOG.error("Exception while trying to send RPC to CLDB", t);
            return null;
        }
    }

    public void initInstanceForCldb() {
        this.isCldbUsage = true;
        LOG.info("CLDBRpcCommonUtils instance inited for CLDB usage.");
    }

    private synchronized void loadMaprClusterConf() {
        LOG.debug("loadMaprClusterConf");
        String tempClusterName = null;
        HashMap tempMap = new HashMap();
        String maprHome = BaseUtilsHelper.getPathToMaprHome();
        String clusterConfFile = maprHome + MAPR_CLUSTER_FILE_NAME;
        try {
            String strLine;
            BufferedReader bfr = new BufferedReader(new FileReader(clusterConfFile));
            while ((strLine = bfr.readLine()) != null) {
                String[] tokens;
                if (strLine.matches("^\\s*#.*") || (tokens = strLine.split("[\\s]+")).length < 2) continue;
                String clusterName = tokens[0];
                ArrayList<IpPort> ipList = new ArrayList<IpPort>();
                for (int i = 1; i < tokens.length; ++i) {
                    if (tokens[i].contains("=")) {
                        String[] arr = tokens[i].split("=");
                        if (arr.length == 2 && JNISecurity.SetClusterOption(clusterName, arr[0], arr[1]) == 0) continue;
                        LOG.error("Invalid Conf options:" + tokens[i] + " for cluster " + clusterName);
                        continue;
                    }
                    String[] cldbIps = tokens[i].split(";");
                    IpPort ipPort = new IpPort();
                    for (int j = 0; j < cldbIps.length; ++j) {
                        int port = 7222;
                        int delimIndex = cldbIps[j].lastIndexOf(":");
                        String host = "";
                        host = delimIndex != -1 ? cldbIps[j].substring(0, delimIndex).replaceAll("\\[|\\]", "") : cldbIps[j].replaceAll("\\[|\\]", "");
                        this.hostMap.put(host, clusterName);
                        int index = host.indexOf(44);
                        if (index != -1) {
                            host = index < host.length() - 1 ? host.substring(index + 1) : host.substring(0, index);
                        }
                        if (delimIndex != -1) {
                            String strPort = cldbIps[j].substring(delimIndex + 1);
                            try {
                                port = Integer.valueOf(strPort);
                            }
                            catch (NumberFormatException nfe) {
                                LOG.error("Port is not Integer: " + strPort + ". Using default CLDB port: 7222");
                            }
                            if (port < 0 || port > 65535) {
                                LOG.error("Port is invalid number: " + strPort + ". Skipping " + cldbIps[j]);
                                continue;
                            }
                        }
                        ipPort.addIPOrHost(host, port);
                    }
                    if (ipPort.getNumIPs() <= 0) continue;
                    ipList.add(ipPort);
                }
                if (tempClusterName == null) {
                    this.defaultClusterName = clusterName;
                    tempClusterName = clusterName;
                }
                if (ipList.isEmpty()) {
                    LOG.error("No CLDBs defined for cluster: " + clusterName);
                    continue;
                }
                tempMap.put(clusterName, ipList);
            }
            this.clustersMap.putAll(tempMap);
            for (Map.Entry<String, List<IpPort>> entry : this.clustersMap.entrySet()) {
                if (tempMap.containsKey(entry.getKey())) continue;
                this.clustersMap.remove(entry.getKey());
            }
        }
        catch (FileNotFoundException bfr) {
        }
        catch (Throwable t) {
            LOG.error("Exception during loadMaprClusterConf", t);
        }
        JNISecurity.SetParsingDone();
        if (this.clustersMap.size() == 0) {
            ArrayList<IpPort> ipList = new ArrayList<IpPort>();
            IpPort ipPort = new IpPort();
            ipPort.addIPOrHost(CLDB_LOCAL_HOST, 7222);
            ipPort.addIPOrHost(IPV6_CLDB_LOCAL_HOST, 7222);
            ipList.add(ipPort);
            this.clustersMap.put(this.defaultClusterName, ipList);
        }
        this.originalClustersMap.putAll(this.clustersMap);
    }

    private synchronized void fetchAndLoadClusterGroup() {
        if (this.isCldbUsage) {
            LOG.debug("fetchAndLoadClusterGroup: running as cldb, nothing to do.");
            return;
        }
        LOG.debug("fetchAndLoadClusterGroup: fetching cluster-group members from cldb.");
        List<CLDBProto.ClusterGroupConf> cgConfs = CLDBRpcCommonUtils.fetchClusterGroupConfs();
        if (cgConfs == null) {
            LOG.error("fetchAndLoadClusterGroup: failed to load cluster group entries, got null");
            return;
        }
        if (cgConfs.isEmpty()) {
            LOG.error("fetchAndLoadClusterGroup: failed to load cluster group entries, no entries found.");
            return;
        }
        for (CLDBProto.ClusterGroupConf cgConf : cgConfs) {
            String clusterName = cgConf.getClusterName();
            LOG.debug("fetchAndLoadClusterGroup: processing cluster " + clusterName);
            this.loadClusterGroupConf(cgConf);
        }
    }

    public static List<CLDBProto.ClusterGroupConf> fetchClusterGroupConfs() {
        CLDBProto.ClusterGroupListRequest req = CLDBProto.ClusterGroupListRequest.newBuilder().setCreds(CLDBRpcCommonUtils.getUsersCredentials()).build();
        try {
            byte[] data = s_instance.sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ClusterGroupListProc.getNumber(), (MessageLite)req, CLDBProto.ClusterGroupListResponse.class);
            if (data == null) {
                LOG.error("fetchClusterGroupConfs: Couldn't connect to the CLDB service");
                return null;
            }
            CLDBProto.ClusterGroupListResponse resp = CLDBProto.ClusterGroupListResponse.parseFrom((byte[])data);
            if (resp.getStatus() != 0) {
                LOG.error("fetchClusterGroupConfs: Request failed with error " + resp.getErrMsg() + ":" + resp.getStatus());
                return null;
            }
            return resp.getCcConfsList();
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error("fetchClusterGroupConfs: caught InvalidProtocolBufferException", (Object)e.getMessage());
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("fetchClusterGroupConfs: cought Exception", (Throwable)e);
            }
            LOG.error("fetchClusterGroupConfs: cought Exception", (Object)e.getMessage());
        }
        return null;
    }

    private static Security.CredentialsMsg getUsersCredentials() {
        UnixUserGroupHelper ui = new UnixUserGroupHelper();
        String user = ui.getLoggedinUsername();
        int uid = ui.getUserId(user);
        int[] gids = ui.getGroups(user);
        Security.CredentialsMsg.Builder msg = Security.CredentialsMsg.newBuilder().setUid(uid);
        for (int gid : gids) {
            msg.addGids(gid);
        }
        return msg.build();
    }

    private Security.TicketAndKey getClusterCcTicket(CLDBProto.ClusterGroupConf cgConf) {
        String clusterName = cgConf.getClusterName();
        if (!cgConf.hasCcTicket()) {
            LOG.error("getClusterCcTicket: : cross cluster ticket missing for cluster " + clusterName);
            return null;
        }
        MutableInt err = new MutableInt();
        byte[] ticketBytes = Security.DecodeDataFromKeyFile(cgConf.getCcTicket().getBytes(), err);
        if (err.GetValue() != 0 || ticketBytes == null || ticketBytes.length == 0) {
            LOG.error("getClusterCcTicket: Failed to get bytes from serialized ticket");
            return null;
        }
        try {
            return Security.TicketAndKey.parseFrom((byte[])ticketBytes);
        }
        catch (InvalidProtocolBufferException e) {
            String error = "failed to parse TicketAndKey";
            LOG.error("updateClusterConfInfos: " + error, (Throwable)e);
            return null;
        }
    }

    private synchronized void loadClusterGroupConf(CLDBProto.ClusterGroupConf cgConf) {
        ArrayList<IpPort> ipPorts = new ArrayList<IpPort>();
        String clusterName = cgConf.getClusterName();
        LOG.debug("loadClusterGroupConf: processing cluster " + clusterName);
        if (cgConf.hasCldbIps()) {
            if (!cgConf.getCldbIps().isEmpty()) {
                this.addIpPortsToList(cgConf.getCldbIps(), ipPorts);
            } else {
                LOG.info("loadClusterGroupConf: found empty internal cldb ips for cluster " + clusterName);
            }
        } else {
            LOG.info("loadClusterGroupConf: cluster " + clusterName + " don't have internal cldb ips");
        }
        if (cgConf.hasCldbExtIps()) {
            if (!cgConf.getCldbExtIps().isEmpty()) {
                this.addIpPortsToList(cgConf.getCldbExtIps(), ipPorts);
            } else {
                LOG.info("loadClusterGroupConf: found empty external cldb ips for cluster " + clusterName);
            }
        } else {
            LOG.info("loadClusterGroupConf: cluster " + clusterName + " don't have external cldb ips");
        }
        if (ipPorts.isEmpty()) {
            LOG.error("loadClusterGroupConf: didnt find any IP for cluster " + clusterName);
            return;
        }
        Security.TicketAndKey cctkt = this.getClusterCcTicket(cgConf);
        if (cctkt == null) {
            LOG.error("loadClusterGroupConf: failed to set ticket for cluster " + clusterName);
            return;
        }
        this.clustersMap.put(clusterName, ipPorts);
        Security.SetTicketAndKey(Security.ServerKeyType.ClusterKey, clusterName, cctkt);
        LOG.info("loadClusterGroupConf: added cluster " + clusterName + ", ipPorts: " + ((Object)ipPorts).toString().replaceAll("[\n]{1,}", " "));
    }

    private void addIpPortsToList(String ipPortsStr, List<IpPort> ipPorts) {
        if (ipPorts == null) {
            LOG.error("addIpPortsToList: null ipPorts.");
            return;
        }
        for (String cldbIpPort : ipPortsStr.split(" ")) {
            IpPort ipPort = this.getIpPortFromStr(cldbIpPort);
            if (ipPort == null) {
                LOG.error("loadClusterGroupConf: invalid external ip or port");
                continue;
            }
            ipPorts.add(ipPort);
        }
    }

    private long init(int cldbPort, List<IpAddr> cldbHostIps, String clusterName, Security.ServerKeyType keyType, int srcPort) throws CLDBRpcCommonUtilsException {
        MutableInt mutableerr;
        Security.TicketAndKey ticket;
        if (cldbHostIps == null || cldbHostIps.size() == 0) {
            return 0L;
        }
        byte[][] cldbIps = new byte[cldbHostIps.size()][];
        int idx = 0;
        for (IpAddr cldbIp : cldbHostIps) {
            cldbIps[idx] = cldbIp.toByteArray();
            ++idx;
        }
        try {
            int port = Rpc.initialize(0, 0, clusterName);
            if (port < 0) {
                throw new IOException("Error in RPC init");
            }
        }
        catch (Exception e) {
            throw new CLDBRpcCommonUtilsException("Exception in Rpc.initialize " + e);
        }
        if (JNISecurity.IsSecurityEnabled(clusterName) && (ticket = Security.GetTicketAndKeyForCluster(keyType, clusterName, mutableerr = new MutableInt())) == null) {
            int err = Security.SetTicketAndKeyFile(this.getPathToServerTicketFile());
            if (err != 0) {
                LOG.error("Error " + err + " in loading " + this.getPathToServerTicketFile());
            }
            ticket = Security.GetTicketAndKeyForCluster(keyType, clusterName, mutableerr);
        }
        int flags = this.getFlagsForBinding(clusterName, false);
        long binding = srcPort > 0 ? Rpc.createBindingForIpsWithSrcPort2(cldbIps, cldbPort, srcPort, clusterName, keyType.getNumber(), flags) : Rpc.createBindingForIps2(cldbIps, cldbPort, clusterName, keyType.getNumber(), flags);
        return binding;
    }

    private IpPort getIpPortFromStr(String cldbIpPort) {
        SocketAddr cldbSockAddr = Util.parseSocket(cldbIpPort);
        if (cldbSockAddr == null) {
            LOG.error("lookupInClusterMaps: Invalid socket address: " + cldbSockAddr);
            return null;
        }
        IpPort ipPort = new IpPort();
        ipPort.addIPOrHost(cldbSockAddr);
        return ipPort;
    }

    private void updateIpPortsFromClusterConf(CLDBProto.ClusterGroupConf conf) {
        if (conf == null) {
            return;
        }
        if (conf.hasCldbIps() || conf.hasCldbExtIps()) {
            IpPort ipPort;
            IpPort extIpPort;
            int i;
            ArrayList<IpPort> ipPorts = new ArrayList<IpPort>();
            List<Object> cldbIpPorts = new ArrayList();
            List<Object> cldbExtIpPorts = new ArrayList();
            if (conf.hasCldbIps() && !conf.getCldbIps().isEmpty()) {
                cldbIpPorts = Arrays.asList(conf.getCldbIps().split(" "));
            }
            if (conf.hasCldbExtIps() && !conf.getCldbExtIps().isEmpty()) {
                cldbExtIpPorts = Arrays.asList(conf.getCldbExtIps().split(" "));
            }
            int numElementsToBeZigZag = 0;
            if (cldbIpPorts.size() != 0 && cldbExtIpPorts.size() != 0) {
                numElementsToBeZigZag = cldbIpPorts.size() <= cldbExtIpPorts.size() ? cldbIpPorts.size() : cldbExtIpPorts.size();
                LOG.debug("updateIpPortsFromClusterConf: numElementsToBeZigZag: " + numElementsToBeZigZag);
                for (i = 0; i < numElementsToBeZigZag; ++i) {
                    if (!((String)cldbExtIpPorts.get(i)).isEmpty()) {
                        extIpPort = this.getIpPortFromStr((String)cldbExtIpPorts.get(i));
                        if (extIpPort == null) {
                            LOG.error("updateIpPortsFromClusterConf: invalid external ip or port in zig zag: " + (String)cldbExtIpPorts.get(i));
                        } else {
                            LOG.debug("updateIpPortsFromClusterConf: adding ext in zigzag ipPort: " + extIpPort.toString());
                            ipPorts.add(extIpPort);
                        }
                    }
                    if (((String)cldbIpPorts.get(i)).isEmpty()) continue;
                    ipPort = this.getIpPortFromStr((String)cldbIpPorts.get(i));
                    if (ipPort == null) {
                        LOG.error("updateIpPortsFromClusterConf: invalid ip or port in zig zag: " + (String)cldbIpPorts.get(i));
                        continue;
                    }
                    LOG.debug("updateIpPortsFromClusterConf: adding internal in zigzag ipPort: " + ipPort.toString());
                    ipPorts.add(ipPort);
                }
            }
            if (cldbExtIpPorts.size() > numElementsToBeZigZag) {
                for (i = numElementsToBeZigZag; i < cldbExtIpPorts.size(); ++i) {
                    if (((String)cldbExtIpPorts.get(i)).isEmpty()) continue;
                    extIpPort = this.getIpPortFromStr((String)cldbExtIpPorts.get(i));
                    if (extIpPort == null) {
                        LOG.error("updateIpPortsFromClusterConf: invalid ext ip or port: " + (String)cldbExtIpPorts.get(i));
                        continue;
                    }
                    LOG.debug("updateIpPortsFromClusterConf: adding ext in ipPort: " + extIpPort.toString());
                    ipPorts.add(extIpPort);
                }
            }
            if (cldbIpPorts.size() > numElementsToBeZigZag) {
                for (i = numElementsToBeZigZag; i < cldbIpPorts.size(); ++i) {
                    if (((String)cldbIpPorts.get(i)).isEmpty()) continue;
                    ipPort = this.getIpPortFromStr((String)cldbIpPorts.get(i));
                    if (ipPort == null) {
                        LOG.error("updateIpPortsFromClusterConf: invalid ip or port: " + (String)cldbIpPorts.get(i));
                        continue;
                    }
                    LOG.debug("updateIpPortsFromClusterConf: adding in internal ipPort: " + ipPort.toString());
                    ipPorts.add(ipPort);
                }
            }
            if (ipPorts.size() > 0) {
                this.clusterGroupIpPortMap.put(conf.getClusterName(), ipPorts);
            }
        }
    }

    private List<IpPort> lookupInClusterGroupIpPortsMaps(String clusterName) {
        List<IpPort> ipPorts = null;
        ipPorts = this.clusterGroupIpPortMap.get(clusterName);
        if (ipPorts == null) {
            LOG.debug("lookupInClusterGroupIpPortsMaps: didnt find any IP for clusterName " + clusterName);
        }
        LOG.debug("Read IpPorts {} for clustername {} , from clusterGroupIpPortMap", ipPorts, (Object)clusterName);
        return ipPorts;
    }

    public List<IpPort> lookupInClusterMaps(String clusterName) {
        List<IpPort> ipPorts = null;
        ipPorts = this.clustersMap.get(clusterName);
        if (ipPorts == null) {
            LOG.debug("lookupInClusterMaps: entry: {} not present in clustersMap", (Object)clusterName);
            CLDBProto.ClusterGroupConf conf = this.clustersGroupMap.get(clusterName);
            ipPorts = new ArrayList<IpPort>();
            if (conf != null) {
                IpPort ipPort;
                SocketAddr cldbSockAddr;
                if (conf.hasCldbIps()) {
                    for (String cldbIpPort : conf.getCldbIps().split(" ")) {
                        if (conf.getCldbIps().isEmpty()) {
                            LOG.info("lookupInClusterMaps: found empty internal cldb ips for cluster {}", (Object)clusterName);
                            continue;
                        }
                        cldbSockAddr = Util.parseSocket(cldbIpPort);
                        if (cldbSockAddr == null) {
                            LOG.error("lookupInClusterMaps: Invalid socket address: " + cldbSockAddr);
                            continue;
                        }
                        LOG.debug("lookupInClusterMaps: adding internal {} - ip {}", (Object)clusterName, (Object)cldbSockAddr.toString());
                        ipPort = new IpPort();
                        ipPort.addIPOrHost(cldbSockAddr);
                        ipPorts.add(ipPort);
                    }
                } else {
                    LOG.debug("lookupInClusterMaps  clustersGroupMap.get  don't have internal cldb ips for cluster {}", (Object)clusterName);
                }
                if (conf.hasCldbExtIps()) {
                    for (String cldbIpPort : conf.getCldbExtIps().split(" ")) {
                        if (cldbIpPort.isEmpty()) {
                            LOG.info("lookupInClusterMaps: found empty external cldb ips for cluster {}", (Object)clusterName);
                            continue;
                        }
                        cldbSockAddr = Util.parseSocket(cldbIpPort);
                        if (cldbSockAddr == null) {
                            LOG.error("lookupInClusterMaps: Invalid socket address: " + cldbSockAddr);
                            continue;
                        }
                        LOG.debug("lookupInClusterMaps: adding external {} - ip {}", (Object)clusterName, (Object)cldbSockAddr.toString());
                        ipPort = new IpPort();
                        ipPort.addIPOrHost(cldbSockAddr);
                        ipPorts.add(ipPort);
                    }
                } else {
                    LOG.debug("lookupInClusterMaps: clustersGroupMap.get  don't have external  cldb ips for cluster {}", (Object)clusterName);
                }
            }
            if (ipPorts != null && !ipPorts.isEmpty()) {
                LOG.info("lookupInClusterMaps: adding IpPorts {} for clustername {} ,from cgMap", ipPorts, (Object)clusterName);
                this.clustersMap.put(clusterName, ipPorts);
            } else {
                LOG.info("lookupInClusterMaps: didnt find any IP for clusterName " + clusterName);
                ipPorts = null;
            }
        } else {
            LOG.debug("lookupInClusterMaps: found in main map for clustername " + clusterName + ipPorts.toString());
        }
        return ipPorts;
    }

    public byte[] sendRequest(int programId, int procedureId, MessageLite request, Class<? extends MessageLite> responseClass) throws Exception {
        return this.sendRequest(this.defaultClusterName, programId, procedureId, request, responseClass, Security.ServerKeyType.ServerKey);
    }

    public byte[] sendRequest(int programId, int procedureId, MessageLite request, Class<? extends MessageLite> responseClass, int cldbPort) throws Exception {
        return this.sendRequest(this.defaultClusterName, programId, procedureId, request, responseClass, Security.ServerKeyType.ServerKey, 0, cldbPort);
    }

    public byte[] sendRequest(String clusterName, int programId, int procedureId, MessageLite request, Class<? extends MessageLite> responseClass) throws Exception {
        return this.sendRequest(clusterName, programId, procedureId, request, responseClass, Security.ServerKeyType.ServerKey);
    }

    public byte[] sendRequest(String clusterName, int programId, int procedureId, MessageLite request, Class<? extends MessageLite> responseClass, Security.ServerKeyType keyType) throws Exception {
        return this.sendRequest(clusterName, programId, procedureId, request, responseClass, keyType, 0);
    }

    public byte[] sendRequest(String clusterName, int programId, int procedureId, MessageLite request, Class<? extends MessageLite> responseClass, Security.ServerKeyType keyType, int srcPort) throws Exception {
        return this.sendRequest(clusterName, programId, procedureId, request, responseClass, keyType, srcPort, 0);
    }

    public byte[] sendRequest(String clusterName, int programId, int procedureId, MessageLite request, Class<? extends MessageLite> responseClass, Security.ServerKeyType keyType, int srcPort, int cldbPort) throws Exception {
        if (this.lookupInClusterMaps(clusterName) == null) {
            this.reloadClusterMap(clusterName);
            if (this.lookupInClusterMaps(clusterName) == null) {
                try {
                    Method newBuilder = responseClass.getMethod("newBuilder", new Class[0]);
                    Object returnObject = newBuilder.invoke(null, new Object[0]);
                    Method statusMethod = returnObject.getClass().getMethod("setStatus", Integer.TYPE);
                    returnObject = statusMethod.invoke(returnObject, 133);
                    Method build = returnObject.getClass().getMethod("build", new Class[0]);
                    MessageLite buildObject = (MessageLite)build.invoke(returnObject, new Object[0]);
                    byte[] bytes = buildObject.toByteArray();
                    LOG.error("Unable to reach cluster with name: " + clusterName + ". No entry found in file /conf/mapr-clusters.conf for cluster " + clusterName + ". Failing the CLDB RPC with status 133");
                    return bytes;
                }
                catch (Exception e) {
                    LOG.error("Error while trying to construct erroneous response", (Throwable)e);
                    LOG.error("Cluster with name: " + clusterName + " is not found. Can not proceed with CLDB RPC");
                    return null;
                }
            }
        }
        if (this.clustersMap.get(clusterName) == null || this.clustersMap.get(clusterName).isEmpty()) {
            this.reloadClusterMap(null);
        }
        if (cldbPort > 0) {
            IpPort cldbCredentials = new IpPort();
            cldbCredentials.addIPOrHost(CLDB_LOCAL_HOST, cldbPort);
            for (IpAddr cldbCredential : cldbCredentials.getAddr()) {
                LOG.debug("CLDB credentials IpAddr: " + cldbCredential.toString());
            }
            byte[] retBytes = this.getDataForParticularCLDB(clusterName, cldbCredentials, programId, procedureId, request, responseClass, keyType, srcPort);
            return retBytes;
        }
        ArrayList clusterCredentials = new ArrayList(this.clustersMap.get(clusterName));
        int origSize = clusterCredentials.size();
        Iterator iter = clusterCredentials.iterator();
        byte[] retBytes = null;
        while (iter.hasNext()) {
            IpPort cldbCredentials = (IpPort)iter.next();
            try {
                retBytes = this.getDataForParticularCLDB(clusterName, cldbCredentials, programId, procedureId, request, responseClass, keyType, srcPort);
            }
            catch (MaprSecurityAuthException e) {
                iter.remove();
                continue;
            }
            if (retBytes != null) break;
            iter.remove();
            LOG.info("Bad CLDB credentials removed: " + cldbCredentials);
        }
        if (clusterCredentials.size() != origSize) {
            this.clustersMap.put(clusterName, clusterCredentials);
        }
        if (clusterCredentials.size() == 0) {
            this.clustersMap.remove(clusterName);
        }
        return retBytes;
    }

    public byte[] sendCGRequest(String clusterName, int programId, int procedureId, MessageLite request, Class<? extends MessageLite> responseClass, Security.ServerKeyType keyType, int srcPort) throws Exception {
        if (this.lookupInClusterGroupIpPortsMaps(clusterName) == null) {
            LOG.error("sendCGRequest: cluster: " + clusterName + " not available in lookupInClusterGroupIpPortsMaps");
            return null;
        }
        ArrayList clusterCredentials = new ArrayList(this.clusterGroupIpPortMap.get(clusterName));
        int origSize = clusterCredentials.size();
        Iterator iter = clusterCredentials.iterator();
        byte[] retBytes = null;
        while (iter.hasNext()) {
            IpPort cldbCredentials = (IpPort)iter.next();
            try {
                LOG.debug("sendCGRequest: cldbCredentials being tried: " + cldbCredentials.toString());
                retBytes = this.getDataForParticularCLDB(clusterName, cldbCredentials, programId, procedureId, request, responseClass, keyType, srcPort);
            }
            catch (MaprSecurityAuthException e) {
                iter.remove();
                continue;
            }
            if (retBytes != null) break;
            iter.remove();
            LOG.info("Bad CLDB credentials removed: " + cldbCredentials);
        }
        return retBytes;
    }

    public boolean isValidClusterName(String clusterName) {
        if (this.lookupInClusterMaps(clusterName) != null) {
            return true;
        }
        this.loadMaprClusterConf();
        if (this.clustersMap.get(clusterName) != null) {
            return true;
        }
        this.fetchAndLoadClusterGroup();
        if (this.clustersMap.get(clusterName) != null) {
            return true;
        }
        LOG.error("Cluster with name: " + clusterName + " not found");
        return false;
    }

    public String getPathToClustersConfFile() {
        String maprHome = BaseUtilsHelper.getPathToMaprHome();
        return maprHome + MAPR_CLUSTER_FILE_NAME;
    }

    public String getPathToServerTicketFile() {
        String maprHome = BaseUtilsHelper.getPathToMaprHome();
        return maprHome + MAPR_SERVER_TICKET_FILE_NAME;
    }

    private byte[] getDataForParticularCLDB(String clusterName, IpPort cldbCredentials, int programId, int procedureId, MessageLite request, Class<? extends MessageLite> responseClass, Security.ServerKeyType keyType, int srcPort) throws Exception {
        try {
            byte[] retBytes;
            MapRLoginHttpsClient loginClient = new MapRLoginHttpsClient();
            if (keyType == Security.ServerKeyType.ServerKey && !loginClient.hasGoodServerKey(clusterName) && loginClient.hasGoodClusterKey(clusterName)) {
                keyType = Security.ServerKeyType.ClusterKey;
            }
            loginClient.quietAuthenticateIfNeeded(clusterName, keyType);
            long binding = this.init(cldbCredentials.getPort(), cldbCredentials.getAddr(), clusterName, keyType, srcPort);
            if (binding == 0L) {
                return null;
            }
            if (procedureId != CLDBProto.CLDBProg.ContainerRootLookupProc.getNumber()) {
                Common.IPType ipType = this.getIPTypeForCluster(clusterName, srcPort);
                LOG.debug("Got iptype " + ipType + " for procid " + procedureId);
                request = this.embedIpTypeInRequest(programId, procedureId, request, ipType);
            }
            Method parseFromMethod = responseClass.getMethod("parseFrom", ByteString.class);
            int MAX_ATTEMPTS = 6;
            int nAttempt = 0;
            Integer status = 0;
            do {
                if ((retBytes = Rpc.sendRequest(binding, programId, procedureId, request)) != null) {
                    Object returnObject = parseFromMethod.invoke(null, ByteString.copyFrom((byte[])retBytes));
                    Method statusMethod = returnObject.getClass().getMethod("getStatus", new Class[0]);
                    status = (Integer)statusMethod.invoke(returnObject, new Object[0]);
                    if (status == null) {
                        LOG.error("Return Status is not Integer: " + status);
                        continue;
                    }
                    if (status == 30) {
                        LOG.info(cldbCredentials.toString() + " is READ_ONLY CLDB. Trying another one");
                        continue;
                    }
                    if (status == 3) {
                        if (++nAttempt == 1) {
                            LOG.info(cldbCredentials.toString() + " is attempting to become a master. Retrying RPC " + programId + "." + procedureId);
                        }
                        if (nAttempt >= 6) continue;
                        Thread.sleep((2 * nAttempt + 1) * 1000);
                        continue;
                    }
                    return retBytes;
                }
                LOG.error("No data returned in RPC: " + programId + "." + procedureId + " from " + cldbCredentials.toString() + ". Continue searching for correct CLDB");
            } while (retBytes != null && status == 3 && nAttempt < 6);
        }
        catch (CLDBRpcCommonUtilsException e) {
            LOG.error("Exception while trying to bind on: " + cldbCredentials.toString());
        }
        catch (MaprSecurityException se) {
            LOG.error("", (Throwable)se);
            throw se;
        }
        catch (Exception ex) {
            LOG.error("Exception while trying to send RPC to CLDB: " + cldbCredentials.toString() + ". Trying another host/port", (Throwable)ex);
        }
        return null;
    }

    public synchronized IpPort getCurrentValidIpPort(String clusterName) {
        if (this.clustersMap.get(clusterName) != null && this.clustersMap.containsKey(clusterName)) {
            return this.clustersMap.get(clusterName).get(0);
        }
        return null;
    }

    public IpPort getCurrentValidIpPort() {
        return this.getCurrentValidIpPort(this.defaultClusterName);
    }

    public String getCurrentClusterName() {
        return this.defaultClusterName;
    }

    public List<CLDBProto.ClusterGroupConf> getClusterGroupConfs() {
        return new ArrayList<CLDBProto.ClusterGroupConf>(this.clustersGroupMap.values());
    }

    public CLDBProto.ClusterGroupConf addClusterGroupConf(CLDBProto.ClusterGroupConf cgConf) {
        CLDBProto.ClusterGroupConf ret = null;
        if (cgConf != null) {
            ret = this.clustersGroupMap.put(cgConf.getClusterName(), cgConf);
            this.updateIpPortsFromClusterConf(cgConf);
            this.clustersMap.remove(cgConf.getClusterName());
            LOG.debug("addClusterGroup " + cgConf.getClusterName());
        }
        return ret;
    }

    public void clearClusterGroupMap() {
        this.clustersGroupMap.clear();
    }

    public CLDBProto.ClusterGroupConf removeClusterGroupConf(String clustername) {
        CLDBProto.ClusterGroupConf ret = null;
        if (clustername != null) {
            ret = this.clustersGroupMap.remove(clustername);
            this.clusterGroupIpPortMap.remove(clustername);
            this.clustersMap.remove(clustername);
            LOG.debug("removeClusterGroup " + clustername);
        }
        return ret;
    }

    public CLDBProto.ClusterGroupConf getClusterGroupConf(String clusterName) {
        CLDBProto.ClusterGroupConf ret = null;
        if (clusterName != null) {
            ret = this.clustersGroupMap.get(clusterName);
            LOG.debug("getClusterGroup " + clusterName);
        }
        return ret;
    }

    public String getPrimaryClusterName() {
        for (CLDBProto.ClusterGroupConf cgc : this.getClusterGroupConfs()) {
            if (!cgc.getIsClusterGroupPrimary()) continue;
            LOG.debug("getClusterGroupPrimary: found master flag on {}", (Object)cgc.getClusterName());
            return cgc.getClusterName();
        }
        return null;
    }

    public int getClusterGroupSize() {
        return this.clustersGroupMap.size();
    }

    private boolean isClusterGroupMember(String clusterName) {
        return this.clustersGroupMap.containsKey(clusterName);
    }

    public boolean isExternalServerMember(String extName) {
        return this.externalServerMap.containsKey(extName);
    }

    public boolean isGnsMember(String extServerName) {
        return this.isClusterGroupMember(extServerName) || this.isExternalServerMember(extServerName);
    }

    public List<CLDBProto.ExternalServer> getExternalServers() {
        return new ArrayList<CLDBProto.ExternalServer>(this.externalServerMap.values());
    }

    public ArrayList<String> getExternalServerNames() {
        return new ArrayList<String>(this.externalServerMap.keySet());
    }

    public CLDBProto.ExternalServer getExternalServer(String extServerName) {
        CLDBProto.ExternalServer ret = null;
        if (extServerName != null) {
            ret = this.externalServerMap.get(extServerName);
            LOG.debug("getExternalServer " + extServerName);
        }
        return ret;
    }

    public boolean isS3ExternalServer(String extName) {
        CLDBProto.ExternalServer ret = this.externalServerMap.get(extName);
        if (ret != null) {
            return ret.getExternalServerOneOfCase() == CLDBProto.ExternalServer.ExternalServerOneOfCase.EXTS3;
        }
        return false;
    }

    public boolean isNFSExternalServer(String extName) {
        CLDBProto.ExternalServer ret = this.externalServerMap.get(extName);
        if (ret != null) {
            return ret.getExternalServerOneOfCase() == CLDBProto.ExternalServer.ExternalServerOneOfCase.EXTNFS;
        }
        return false;
    }

    public CLDBProto.ExternalServer addExternalServer(CLDBProto.ExternalServer extServer) {
        CLDBProto.ExternalServer ret = null;
        if (extServer != null) {
            if (extServer.getExternalServerOneOfCase() == CLDBProto.ExternalServer.ExternalServerOneOfCase.EXTNFS) {
                ret = this.externalServerMap.put(extServer.getExtNfs().getName(), extServer);
                LOG.info("add to in-mem map ExternalServer NFS:" + extServer.getExtNfs().getName());
            } else if (extServer.getExternalServerOneOfCase() == CLDBProto.ExternalServer.ExternalServerOneOfCase.EXTS3) {
                ret = this.externalServerMap.put(extServer.getExtS3().getName(), extServer);
                LOG.info("add to in-mem map ExternalServer S3:" + extServer.getExtNfs().getName());
            } else {
                LOG.info("Failed to add inmem, addExternalServer of unknown type");
            }
        }
        return ret;
    }

    public CLDBProto.ExternalServer removeExternalServer(String extServerName) {
        CLDBProto.ExternalServer ret = null;
        if (extServerName != null) {
            ret = this.externalServerMap.remove(extServerName);
            LOG.info("Removed from in memeory map, ExternalServer " + extServerName);
        }
        return ret;
    }

    public synchronized boolean updateExternalNFSExports(CLDBProto.ExternalNfsServer server) {
        if (server.getName() == null || server.getIps() == null || server.getExportsList().isEmpty()) {
            return false;
        }
        CLDBProto.ExternalServer ret = this.externalServerMap.get(server.getName());
        if (ret == null || ret.getExternalServerOneOfCase() != CLDBProto.ExternalServer.ExternalServerOneOfCase.EXTNFS || ret.getExtNfs().getIps() == null) {
            return false;
        }
        boolean matchedIp = false;
        for (String ip : ret.getExtNfs().getIps().split(",")) {
            if (!ip.equals(server.getIps())) continue;
            matchedIp = true;
            break;
        }
        if (!matchedIp) {
            return false;
        }
        CLDBProto.ExternalNfsServer newServer = CLDBProto.ExternalNfsServer.newBuilder((CLDBProto.ExternalNfsServer)ret.getExtNfs()).clearExports().setSize(server.getSize()).setUsed(server.getUsed()).setAvail(server.getAvail()).addAllExports((Iterable)server.getExportsList()).build();
        CLDBProto.ExternalServer extServ = CLDBProto.ExternalServer.newBuilder().setExtNfs(newServer).build();
        this.externalServerMap.put(server.getName(), extServ);
        CLDBProto.ExternalServer ret2 = this.externalServerMap.get(server.getName());
        LOG.info("Added Exports for ExternalServer " + ret2.getExtNfs().getName() + " numExports " + ret2.getExtNfs().getExportsCount());
        return true;
    }

    public synchronized void setCurrentClusterName(String clusterName) {
        if (!this.clustersMap.containsKey(clusterName)) {
            throw new IllegalArgumentException("Cluster " + clusterName + " is not known");
        }
        if (this.origClusterName == null) {
            this.origClusterName = this.defaultClusterName;
        }
        this.defaultClusterName = clusterName;
    }

    public synchronized void resetCurrentClusterName() {
        if (this.origClusterName != null) {
            this.defaultClusterName = this.origClusterName;
        }
    }

    public Map<String, List<IpPort>> getClusterMap() {
        return this.clustersMap;
    }

    public void reloadClusterMap(String clusterName) {
        if (clusterName == null || this.clustersMap.get(clusterName) == null) {
            this.loadMaprClusterConf();
        }
        if (clusterName == null || this.clustersMap.get(clusterName) == null) {
            this.fetchAndLoadClusterGroup();
        }
    }

    public Map<String, List<IpPort>> getOriginalClusterMap() {
        return this.originalClustersMap;
    }

    public Map<String, String> getHostMap() {
        return this.hostMap;
    }

    public List<IpPort> getDefaultClusterIpPort() {
        return this.clustersMap.get(this.defaultClusterName);
    }

    public String getDefaultClusterName() {
        return this.defaultClusterName;
    }

    public synchronized long[] getCldbBindings(String clusterName) throws CLDBRpcCommonUtilsException {
        List<IpPort> ipPorts = this.lookupInClusterMaps(clusterName);
        if (ipPorts == null || ipPorts.isEmpty()) {
            this.reloadClusterMap(null);
        }
        if ((ipPorts = this.clustersMap.get(clusterName)) == null || ipPorts.isEmpty()) {
            LOG.error("Unable to get CLDB bindings for cluster " + clusterName);
            return null;
        }
        long[] cldbBindings = new long[ipPorts.size()];
        Iterator<IpPort> itr = ipPorts.iterator();
        int index = 0;
        while (itr.hasNext()) {
            IpPort ipPort = itr.next();
            cldbBindings[index++] = this.init(ipPort.getPort(), ipPort.getAddr(), clusterName, Security.ServerKeyType.ServerKey, 0);
        }
        return cldbBindings;
    }

    public Common.IPType getIPTypeForCluster(String clusterName) {
        return this.getIPTypeForCluster(clusterName, 0);
    }

    public Common.IPType getIPTypeForCluster(String clusterName, int srcPort) {
        if (clusterName == null || clusterName.equals(this.defaultClusterName)) {
            return Common.IPType.INTERNAL_ONLY;
        }
        Common.IPType clusterIpType = this.clusterIpTypes.get(clusterName);
        if (clusterIpType != null) {
            return clusterIpType;
        }
        CLDBProto.ContainerRootLookupResponse resp = null;
        CLDBProto.ContainerRootLookupRequest req = CLDBProto.ContainerRootLookupRequest.newBuilder().setRootPath("mapr.cluster.root").setWantCldbIps(true).build();
        byte[] data = null;
        Security.ServerKeyType keyType = Security.ServerKeyType.ServerKey;
        if (this.partOfServer) {
            keyType = Security.ServerKeyType.ClusterKey;
        }
        LOG.error("Using Key type " + keyType);
        try {
            data = this.sendRequest(clusterName, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.ContainerRootLookupProc.getNumber(), (MessageLite)req, CLDBProto.ContainerRootLookupResponse.class, keyType, srcPort);
        }
        catch (Exception e) {
            LOG.error("getIPTypeForCluster : Exception during container root lookup for " + clusterName + " exception : " + e.getMessage());
        }
        if (data == null) {
            LOG.error("getIPTypeForCluster : Could not get container root lookup response for " + clusterName);
            this.clusterIpTypes.put(clusterName, Common.IPType.EXTERNAL_ONLY);
            return Common.IPType.EXTERNAL_ONLY;
        }
        try {
            resp = CLDBProto.ContainerRootLookupResponse.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error("getIPTypeForCluster : Could not parse container root lookup response for " + clusterName);
            return Common.IPType.EXTERNAL_ONLY;
        }
        boolean internalOnly = false;
        boolean externalOnly = false;
        List<IpPort> configuredIps = this.clustersMap.get(clusterName);
        ArrayList<CallSite> configuredHosts = new ArrayList<CallSite>();
        for (IpPort ipPort : configuredIps) {
            List<IpAddr> ips = ipPort.getAddr();
            int port = ipPort.getPort();
            for (IpAddr ipAddr : ips) {
                configuredHosts.add((CallSite)((Object)(ipAddr.toString() + ":" + port)));
            }
        }
        LOG.debug("Configured host:port for cluster " + clusterName + " are " + configuredHosts);
        List internalIpsGotten = resp.getIpPortsList();
        LOG.info("RootContainerLookup response to cluster " + clusterName + " returned internal host:port as " + this.printIPPortList(internalIpsGotten));
        block6: for (Object internalIpPort : internalIpsGotten) {
            List internalHostsGotten = internalIpPort.getHostsList();
            int port = internalIpPort.getPort();
            for (Integer host : internalHostsGotten) {
                if (!configuredHosts.contains(host + ":" + port)) continue;
                internalOnly = true;
                continue block6;
            }
        }
        List list = resp.getExternalIPPortsList();
        LOG.info("RootContainerLookup response to cluster " + clusterName + " returned external host:port as " + this.printIPPortList(internalIpsGotten));
        block8: for (Common.IPPort externalIpPort : list) {
            List externalHostsGotten = externalIpPort.getHostsList();
            int n = externalIpPort.getPort();
            for (Integer host : externalHostsGotten) {
                if (!configuredHosts.contains(host + ":" + n)) continue;
                externalOnly = true;
                continue block8;
            }
        }
        Common.IPType ipType = Common.IPType.INTERNAL_ONLY;
        if (internalOnly && externalOnly) {
            ipType = Common.IPType.INTERNAL_EXTERNAL_BOTH;
        } else if (externalOnly) {
            ipType = Common.IPType.EXTERNAL_ONLY;
        }
        LOG.info("Detected cluster " + clusterName + " as " + ipType);
        this.clusterIpTypes.put(clusterName, ipType);
        return ipType;
    }

    private String printIPPortList(List<Common.IPPort> ipPorts) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Common.IPPort ipPort : ipPorts) {
            List hostsGotten = ipPort.getHostsList();
            int port = ipPort.getPort();
            for (Integer host : hostsGotten) {
                sb.append(host);
                sb.append(":");
                sb.append(port);
                sb.append(", ");
            }
        }
        sb.append("]");
        return sb.toString();
    }

    private MessageLite embedIpTypeInRequest(int programId, int procId, MessageLite request, Common.IPType ipType) {
        if (programId != Common.MapRProgramId.CldbProgramId.getNumber()) {
            return request;
        }
        MessageLite modifiedReq = request;
        if (procId == CLDBProto.CLDBProg.ContainerLookupProc.getNumber()) {
            CLDBProto.ContainerLookupRequest oldReq = (CLDBProto.ContainerLookupRequest)request;
            modifiedReq = CLDBProto.ContainerLookupRequest.newBuilder((CLDBProto.ContainerLookupRequest)oldReq).setIpType(ipType).build();
        } else if (procId == CLDBProto.CLDBProg.ContainerOnFileServerFailProc.getNumber()) {
            CLDBProto.ContainerOnFileServerFailRequest oldReq = (CLDBProto.ContainerOnFileServerFailRequest)request;
            modifiedReq = CLDBProto.ContainerOnFileServerFailRequest.newBuilder((CLDBProto.ContainerOnFileServerFailRequest)oldReq).setIpType(ipType).build();
        } else if (procId == CLDBProto.CLDBProg.VolumeLookupProc.getNumber()) {
            CLDBProto.VolumeLookupRequest oldReq = (CLDBProto.VolumeLookupRequest)request;
            modifiedReq = CLDBProto.VolumeLookupRequest.newBuilder((CLDBProto.VolumeLookupRequest)oldReq).setIpType(ipType).build();
        } else if (procId == CLDBProto.CLDBProg.VolumeContainersMapProc.getNumber()) {
            CLDBProto.VolumeContainersMapRequest oldReq = (CLDBProto.VolumeContainersMapRequest)request;
            modifiedReq = CLDBProto.VolumeContainersMapRequest.newBuilder((CLDBProto.VolumeContainersMapRequest)oldReq).setIpType(ipType).build();
        } else if (procId == CLDBProto.CLDBProg.SnapshotContainersMapProc.getNumber()) {
            CLDBProto.SnapshotContainersMapRequest oldSCMReq = (CLDBProto.SnapshotContainersMapRequest)request;
            modifiedReq = CLDBProto.SnapshotContainersMapRequest.newBuilder((CLDBProto.SnapshotContainersMapRequest)oldSCMReq).setIpType(ipType).build();
        }
        return modifiedReq;
    }

    public int getFlagsForBinding(String clusterName, boolean isConnectionToMfs) {
        int flags = this.RPC_CLIENT;
        if (!isConnectionToMfs) {
            return flags |= this.RPC_INTERNAL | this.RPC_EXTERNAL | this.RPC_DISABLE_MERGE_IPS;
        }
        if (clusterName.equals(this.defaultClusterName)) {
            flags |= this.RPC_INTERNAL;
        } else {
            Common.IPType ipType = this.getIPTypeForCluster(clusterName);
            switch (ipType) {
                case INTERNAL_EXTERNAL_BOTH: {
                    flags |= this.RPC_INTERNAL | this.RPC_EXTERNAL;
                    break;
                }
                case EXTERNAL_ONLY: {
                    flags |= this.RPC_EXTERNAL;
                    break;
                }
                default: {
                    flags |= this.RPC_INTERNAL;
                }
            }
        }
        return flags;
    }

    static {
        ShimLoader.load();
        s_instance = new CLDBRpcCommonUtils();
    }

    public static class IpPort {
        private List<IpAddr> ips;
        private List<IpAddr> originalAddr;
        private int port;

        public IpPort() {
            this.port = 7222;
            this.ips = new ArrayList<IpAddr>();
            this.originalAddr = new ArrayList<IpAddr>();
        }

        public IpPort(int port) {
            this.port = port;
            this.ips = new ArrayList<IpAddr>();
            this.originalAddr = new ArrayList<IpAddr>();
        }

        public IpPort(List<IpAddr> ipAddrList) {
            this.port = 7222;
            this.ips = ipAddrList;
            this.originalAddr = ipAddrList;
        }

        public IpPort(List<IpAddr> ipAddrList, int port) {
            this.port = port;
            this.ips = ipAddrList;
            this.originalAddr = ipAddrList;
        }

        public Common.IPPort toIPPort() {
            Common.IPPort.Builder ipPortBuilder = Common.IPPort.newBuilder();
            for (IpAddr ipAddr : this.ips) {
                if (ipAddr.hasIpv4().booleanValue()) {
                    ipPortBuilder.addHosts(ipAddr.toInt().intValue());
                    continue;
                }
                if (ipAddr.hasIpv6().booleanValue()) {
                    ipPortBuilder.addHostIpAddrs(ipAddr.toIpAddrMsg());
                    continue;
                }
                LOG.error("Skipping invalid IP " + ipAddr.toString());
            }
            ipPortBuilder.setPort(this.port);
            return ipPortBuilder.build();
        }

        public void addIPOrHost(SocketAddr sockAddr) {
            IpAddr ipAddr = sockAddr.getIpAddr();
            if (ipAddr.isValid().booleanValue()) {
                this.ips.add(ipAddr);
                this.originalAddr.add(ipAddr);
                this.port = sockAddr.getPort();
            }
        }

        public void addIPOrHost(String host, int port) {
            IpAddr ipAddr = new IpAddr(host);
            if (ipAddr.isValid().booleanValue()) {
                this.ips.add(ipAddr);
                this.originalAddr.add(ipAddr);
                this.port = port;
            }
        }

        public int getNumIPs() {
            return this.ips.size();
        }

        public List<IpAddr> getAddr() {
            return this.ips;
        }

        public List<IpAddr> getOriginalAddr() {
            return this.originalAddr;
        }

        public int getPort() {
            return this.port;
        }

        public String toString() {
            Object ipStr = "";
            for (IpAddr ip : this.ips) {
                ipStr = (String)ipStr + ip.toString() + "-";
            }
            return "CLDB Ips: " + (String)ipStr + ", Port: " + this.port;
        }
    }

    public static class IpAddr {
        private InetAddress inetAddr = null;
        private IpFamily ipFamily = IpFamily.IPUNSPEC;
        private String hostName = null;

        public IpAddr() {
            this.inetAddr = null;
            this.ipFamily = IpFamily.IPUNSPEC;
            this.hostName = null;
        }

        public IpAddr(InetAddress iaAddr) {
            this.init(iaAddr);
        }

        public IpAddr(String addr) {
            if (addr != null && !addr.isEmpty()) {
                InetAddress iaAddr = this.getInetAddrObj(addr);
                this.init(iaAddr);
            }
        }

        public IpAddr(byte[] ipAddr) {
            InetAddress iaAddr = this.getInetAddrObj(ipAddr);
            this.init(iaAddr);
        }

        public void init(InetAddress iaAddr) {
            if (iaAddr != null) {
                if (iaAddr instanceof Inet4Address) {
                    this.setIpFamily(IpFamily.IPV4);
                } else if (iaAddr instanceof Inet6Address) {
                    this.setIpFamily(IpFamily.IPV6);
                } else {
                    this.setIpFamily(IpFamily.IPUNSPEC);
                }
                this.inetAddr = iaAddr;
            }
        }

        private void debugPrint() {
            StringJoiner strMessage = new StringJoiner(" ");
            if (this.isValid().booleanValue()) {
                strMessage.add(String.format("IPv%d Address: %s", this.hasIpv4() != false ? 4 : 6, this.toString()));
                strMessage.add(String.format("Hostname: %s", this.hostName));
            } else {
                strMessage.add("Invalid IP Address");
            }
            LOG.info(strMessage.toString());
        }

        public void clear() {
            this.inetAddr = null;
            this.ipFamily = IpFamily.IPUNSPEC;
            this.hostName = null;
        }

        public void setHostName(String host) {
            this.hostName = host;
        }

        public String getHostName() {
            if (this.hostName == null) {
                this.hostName = this.isValid() != false ? this.inetAddr.getCanonicalHostName() : null;
            }
            return this.hostName;
        }

        private InetAddress getInetAddrObj(String addr) {
            InetAddress iaAddr = null;
            try {
                iaAddr = InetAddress.getByName(addr);
            }
            catch (Exception e) {
                LOG.error("FromString: Failed to create IpAddr object: " + e.getMessage());
                LOG.error(Util.exceptionToString(e));
            }
            return iaAddr;
        }

        private InetAddress getInetAddrObj(byte[] addr) {
            InetAddress iaAddr = null;
            try {
                iaAddr = InetAddress.getByAddress(addr);
            }
            catch (Exception e) {
                LOG.error("FromByteArray: Failed to create IpAddr object: " + e.getMessage());
                LOG.error(Util.exceptionToString(e));
            }
            return iaAddr;
        }

        public InetAddress getInetAddr() {
            return this.inetAddr;
        }

        public void copyFrom(IpAddr ipAddr) {
            this.inetAddr = ipAddr.inetAddr;
            this.ipFamily = ipAddr.ipFamily;
            this.hostName = ipAddr.hostName;
        }

        public void copyFrom(String hostip) {
            InetAddress iaAddr = this.getInetAddrObj(hostip);
            this.init(iaAddr);
        }

        public void copyFrom(Common.IPAddress ipAddress) {
            if (ipAddress.hasHostname()) {
                this.setHostName(ipAddress.getHostname());
            }
            if (ipAddress.hasHostIpAddr()) {
                this.copyFrom(ipAddress.getHostIpAddr());
            } else {
                this.copyFrom(ipAddress.getHost());
            }
        }

        public boolean isEmpty() {
            return this.inetAddr == null && this.hostName == null && this.ipFamily == IpFamily.IPUNSPEC;
        }

        public int hashCode() {
            return this.inetAddr.hashCode();
        }

        public void copyFrom(Integer addr) {
            InetAddress iaAddr = this.getInetAddrObj(Util.intToIp(addr));
            this.init(iaAddr);
        }

        public void copyFrom(byte[] ipAddr) {
            InetAddress iaAddr = this.getInetAddrObj(ipAddr);
            this.init(iaAddr);
        }

        public void copyFrom(Security.IpAddrMsg ipAddrMsg) {
            InetAddress iaAddr = this.getInetAddrObj(ipAddrMsg.getIpv6().getAddr().toByteArray());
            this.init(iaAddr);
        }

        public void copyFrom(Common.IPPort ipPort) {
            if (ipPort.getHostIpAddrsCount() > 0) {
                this.copyFrom((Security.IpAddrMsg)ipPort.getHostIpAddrsList().get(0));
            } else {
                this.copyFrom((Integer)ipPort.getHostsList().get(0));
            }
        }

        public Security.IpAddrMsg toIpAddrMsg() {
            Security.IpAddrMsg.Builder ipAddrMsgBuilder = Security.IpAddrMsg.newBuilder();
            if (this.hasIpv4().booleanValue()) {
                Security.Ipv4AddrMsg.Builder ipv4AddrMsgBuilder = Security.Ipv4AddrMsg.newBuilder();
                ipv4AddrMsgBuilder.setAddr(this.toInt().intValue());
                ipAddrMsgBuilder.setIpv4(ipv4AddrMsgBuilder.build());
            } else if (this.hasIpv6().booleanValue()) {
                Security.Ipv6AddrMsg.Builder ipv6AddrMsgBuilder = Security.Ipv6AddrMsg.newBuilder();
                ipv6AddrMsgBuilder.setAddr(ByteString.copyFrom((byte[])this.toByteArray()));
                ipAddrMsgBuilder.setIpv6(ipv6AddrMsgBuilder.build());
            } else {
                LOG.error("Skipping invalid IP " + this.toString());
                return null;
            }
            return ipAddrMsgBuilder.build();
        }

        public Boolean hasIpv4() {
            return this.getIpFamily() == IpFamily.IPV4;
        }

        public Boolean hasIpv6() {
            return this.getIpFamily() == IpFamily.IPV6;
        }

        public Boolean isValid() {
            return this.getIpFamily() != IpFamily.IPUNSPEC;
        }

        public byte[] toByteArray() {
            if (this.hasIpv4().booleanValue()) {
                return Util.intToByteArray(this.toInt());
            }
            if (this.hasIpv6().booleanValue()) {
                return this.inetAddr.getAddress();
            }
            return new byte[0];
        }

        public boolean equals(Object objAddr) {
            if (objAddr == this) {
                return true;
            }
            if (objAddr instanceof IpAddr) {
                IpAddr ipAddr = (IpAddr)objAddr;
                return this.getInetAddr().equals(ipAddr.getInetAddr());
            }
            return false;
        }

        public String toString() {
            return this.isValid() != false ? this.inetAddr.toString().split("/")[1] : null;
        }

        public IpFamily getIpFamily() {
            return this.ipFamily;
        }

        private void setIpFamily(IpFamily family) {
            this.ipFamily = family;
        }

        public Integer toInt() {
            Integer num = 0;
            if (this.hasIpv4().booleanValue()) {
                for (String part : this.toString().split("\\.")) {
                    num = num << 8;
                    num = num | Integer.parseInt(part);
                }
            }
            return num;
        }

        public Common.IPAddress toIPAddress() {
            Common.IPAddress.Builder ipB = Common.IPAddress.newBuilder();
            if (this.isValid().booleanValue()) {
                if (this.hasIpv4().booleanValue()) {
                    ipB.setHost(this.toInt().intValue());
                } else {
                    ipB.setHostIpAddr(this.toIpAddrMsg());
                }
            }
            if (this.hostName != null && !this.hostName.isEmpty()) {
                ipB.setHostname(this.hostName);
            }
            return ipB.build();
        }

        public Boolean isLoopBack() {
            return this.inetAddr.isLoopbackAddress();
        }

        public Boolean isLinkLocal() {
            return this.inetAddr.isLinkLocalAddress();
        }

        public String getSockAddr(int port) {
            String strSockAddr = null;
            if (this.isValid().booleanValue()) {
                strSockAddr = this.hasIpv4() != false ? this.toString() + ":" + port : "[" + this.toString() + "]:" + port;
            }
            return strSockAddr;
        }
    }

    public static class SocketAddr {
        private IpAddr ipAddr;
        private Integer port = 0;

        public SocketAddr() {
            this.ipAddr = new IpAddr();
            this.port = 0;
        }

        public SocketAddr(byte[] ipAddr) {
            this.ipAddr = new IpAddr(ipAddr);
            this.port = 0;
        }

        public SocketAddr(Common.IPAddress ipAddress) {
            this.ipAddr = new IpAddr();
            if (ipAddress.hasHostIpAddr()) {
                this.ipAddr.copyFrom(ipAddress.getHostIpAddr());
            } else {
                this.ipAddr.copyFrom(ipAddress.getHost());
            }
            int port = ipAddress.getPort();
            if (Util.isValidPort(port)) {
                this.port = port;
            }
        }

        public SocketAddr(Common.IPPort ipPort) {
            this.ipAddr = new IpAddr();
            if (ipPort.getHostIpAddrsCount() > 0) {
                this.ipAddr.copyFrom((Security.IpAddrMsg)ipPort.getHostIpAddrsList().get(0));
            } else if (ipPort.getHostsCount() > 0) {
                this.ipAddr.copyFrom((Integer)ipPort.getHostsList().get(0));
            } else {
                LOG.error("Invalid IPPort");
            }
            int port = ipPort.getPort();
            if (Util.isValidPort(port)) {
                this.port = port;
            }
        }

        public SocketAddr(byte[] ipAddr, int port) {
            this.ipAddr = new IpAddr(ipAddr);
            this.port = port;
        }

        public SocketAddr(String hostip, Integer port) {
            this.ipAddr = new IpAddr(hostip);
            this.port = port;
        }

        public SocketAddr(IpAddr ipAddr, Integer port) {
            this.ipAddr = ipAddr;
            this.port = port;
        }

        public void setPort(Integer port) {
            this.port = port;
        }

        public Integer getPort() {
            return this.port;
        }

        public boolean isIpValid() {
            return this.ipAddr.isValid();
        }

        public boolean isPortValid() {
            return Util.isValidPort(this.port);
        }

        public void copyFrom(Common.IPAddress ipAddress) {
            if (ipAddress.hasHostIpAddr()) {
                this.ipAddr.copyFrom(ipAddress.getHostIpAddr());
            } else {
                this.ipAddr.copyFrom(ipAddress.getHost());
            }
            int port = ipAddress.getPort();
            if (Util.isValidPort(port)) {
                this.port = port;
            }
        }

        public boolean isValid() {
            return this.isIpValid() && this.isPortValid();
        }

        public IpAddr getIpAddr() {
            return this.ipAddr;
        }

        public void setIpAddr(IpAddr ipAddr) {
            this.ipAddr = ipAddr;
        }

        public Common.IPAddress toIPAddress() {
            Common.IPAddress.Builder ipB = Common.IPAddress.newBuilder();
            if (this.isIpValid()) {
                if (this.ipAddr.hasIpv4().booleanValue()) {
                    ipB.setHost(this.ipAddr.toInt().intValue());
                } else {
                    ipB.setHostIpAddr(this.ipAddr.toIpAddrMsg());
                }
            }
            if (this.ipAddr.getHostName() != null && !this.ipAddr.getHostName().isEmpty()) {
                ipB.setHostname(this.ipAddr.getHostName());
            }
            if (this.isPortValid()) {
                ipB.setPort(this.port.intValue());
            }
            return ipB.build();
        }

        public String toString() {
            if (this.ipAddr.isValid().booleanValue()) {
                if (this.ipAddr.hasIpv4().booleanValue()) {
                    return this.ipAddr.toString() + ":" + this.port.toString();
                }
                return "[" + this.ipAddr.toString() + "]:" + this.port.toString();
            }
            LOG.error("Invalid Ip Address {}", (Object)this.ipAddr.toString());
            return "";
        }
    }

    public static enum IpFamily {
        IPUNSPEC,
        IPV4,
        IPV6;

    }
}

