/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.security.maprsasl;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.ProtocolStringList;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.fs.proto.Security;
import com.mapr.login.client.MapRLoginHttpsClient;
import com.mapr.security.JNISecurity;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import com.mapr.security.SecurityHelper;
import com.mapr.security.maprsasl.MapRSaslImplBase;
import com.mapr.security.maprsasl.MaprSaslServer;
import com.mapr.security.maprsasl.MaprSecurityLoginModule;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaprSaslClient
extends MapRSaslImplBase
implements SaslClient {
    private static final Logger LOG = LoggerFactory.getLogger(MaprSaslClient.class);
    private static final Integer MAX_BUF_SIZE_FOR_WRAP = new Integer(65536);
    private int passDone = 0;
    private CallbackHandler cbh;
    private long randomSecret;
    private String authorizationId;
    private String authenticationId;
    private Security.Key userKey;
    private String localqopProperty;
    private String clusterName;

    public MaprSaslClient(Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        super(props);
        this.cbh = cbh;
        this.clusterName = "";
        if (props == null || props.isEmpty()) {
            this.localqopProperty = MaprSaslServer.QOP.AUTHENTICATION.getQopString();
        } else {
            for (Map.Entry<String, ?> entry : props.entrySet()) {
                Object valueO;
                String key = entry.getKey();
                if (key.equals("javax.security.sasl.qop")) {
                    valueO = entry.getValue();
                    if (!(valueO instanceof String)) continue;
                    this.localqopProperty = (String)entry.getValue();
                    continue;
                }
                if (!key.equals("ClusterName") || (valueO = entry.getValue()) == null || !(valueO instanceof String)) continue;
                this.clusterName = (String)entry.getValue();
            }
        }
    }

    @Override
    public void dispose() throws SaslException {
        this.sessionKey = null;
        this.randomSecret = -1L;
        this.authorizationId = null;
        this.authenticationId = null;
    }

    @Override
    public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
        MutableInt err;
        ProtocolStringList serverCLDBS;
        block35: {
            if (this.completed) {
                throw new IllegalStateException("MaprSasl authentication already completed");
            }
            serverCLDBS = null;
            if (this.passDone > 0) {
                if (challenge == null || challenge.length < 1) {
                    throw new SaslException("Received challenge is empty when secret expected");
                }
                if (this.userKey == null) {
                    throw new SaslException("Bad userKey");
                }
                try {
                    err = new MutableInt();
                    challenge = Base64.decodeBase64((byte[])challenge);
                    byte[] decodedResponse = Security.Decrypt(this.userKey, challenge, err);
                    if (err.GetValue() != 0) {
                        decodedResponse = challenge;
                    }
                    Security.AuthenticationResp authResponse = null;
                    try {
                        authResponse = Security.AuthenticationResp.parseFrom((byte[])decodedResponse);
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw new SaslException("Can not parse out the data from server response", e);
                    }
                    if (authResponse != null) {
                        int status = authResponse.getStatus();
                        if (status == 0) {
                            if (authResponse.hasChallengeResponse()) {
                                long respLong = authResponse.getChallengeResponse();
                                if (this.randomSecret != respLong) {
                                    throw new SaslException("Bad returned secret");
                                }
                            } else {
                                throw new SaslException("No returned secret");
                            }
                            if (authResponse.hasEncodingType()) {
                                int qopInt = authResponse.getEncodingType();
                                String interimQOPOption = MaprSaslServer.QOP.getStringFromQOPInt(qopInt);
                                if (interimQOPOption != null) {
                                    if (!interimQOPOption.equals(this.localqopProperty)) {
                                        LOG.warn("SASL Server qopProperty: " + interimQOPOption + "is different from Client: " + this.localqopProperty + ".Using Server one");
                                    }
                                    this.negotiatedQOPProperty = interimQOPOption;
                                }
                            } else {
                                throw new SaslException("No server QOP in response");
                            }
                            if (!MaprSaslServer.QOP.AUTHENTICATION.getQopString().equals(this.negotiatedQOPProperty)) {
                                this.sessionKey = authResponse.getSessionKey();
                                if (this.sessionKey == null) {
                                    throw new SaslException("Bad returned sessionKey");
                                }
                            }
                            this.completed = true;
                            return new byte[0];
                        }
                        if (this.passDone > 1) {
                            throw new SaslException("Max Attempts reached");
                        }
                        serverCLDBS = authResponse.getReceivingCldbList();
                        if (serverCLDBS == null || serverCLDBS.isEmpty()) {
                            throw new SaslException("Error in response: No CLDBs recieved from the server");
                        }
                        break block35;
                    }
                    throw new SaslException("Bad response");
                }
                catch (Throwable t) {
                    if (t instanceof SaslException) {
                        throw (SaslException)t;
                    }
                    LOG.error("Exception while processing ticket data", t);
                    throw new SaslException("Exception while processing ticket data", t);
                }
            }
        }
        try {
            String currentClusterName;
            err = new MutableInt();
            MapRLoginHttpsClient client = new MapRLoginHttpsClient();
            Security.TicketAndKey ticketKey = null;
            if (MaprSecurityLoginModule.isUseMaprServerTicket()) {
                if (serverCLDBS == null) {
                    currentClusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
                } else {
                    currentClusterName = SecurityHelper.getClusterFromHost(serverCLDBS);
                    if (currentClusterName == null) {
                        throw new SaslException("Cannot find the cluster name given cldb hosts from server");
                    }
                }
                ticketKey = Security.GetTicketAndKeyForCluster(Security.ServerKeyType.CldbKey, currentClusterName, err);
            } else {
                currentClusterName = null;
                if (serverCLDBS != null) {
                    currentClusterName = SecurityHelper.getClusterFromHost(serverCLDBS);
                }
                ticketKey = currentClusterName != null ? client.authenticateIfNeeded(currentClusterName) : (!this.clusterName.isEmpty() ? client.authenticateIfNeeded(this.clusterName) : client.authenticateIfNeeded());
            }
            if (ticketKey == null) {
                throw new SaslException("ServerTicketKey was not set and cannot get remote ticket");
            }
            long ticketExpTime = ticketKey.getExpiryTime() * 1000L;
            if (ticketExpTime < System.currentTimeMillis()) {
                throw new SaslException("MaprSaslClient My ticket Expired. Cannot auto renew nontemp ticket");
            }
            this.userKey = ticketKey.getUserKey();
            this.randomSecret = JNISecurity.GenerateRandomNumber();
            byte[] writeBuffer = new byte[]{(byte)(this.randomSecret >>> 56), (byte)(this.randomSecret >>> 48), (byte)(this.randomSecret >>> 40), (byte)(this.randomSecret >>> 32), (byte)(this.randomSecret >>> 24), (byte)(this.randomSecret >>> 16), (byte)(this.randomSecret >>> 8), (byte)(this.randomSecret >>> 0)};
            Security.AuthenticationReqFull.Builder bld = Security.AuthenticationReqFull.newBuilder();
            byte[] secretBytesEncrypted = Security.Encrypt(this.userKey, writeBuffer, err);
            if (err.GetValue() != 0) {
                throw new SaslException("Error while encrypting data: " + err.GetValue());
            }
            bld.setEncryptedRandomSecret(ByteString.copyFrom((byte[])secretBytesEncrypted));
            bld.setEncryptedTicket(ticketKey.getEncryptedTicket());
            SecurityHelper.addCLDBsToAuthReqFull(bld, this.clusterName);
            byte[] authRequestBytes = bld.build().toByteArray();
            authRequestBytes = Base64.encodeBase64((byte[])authRequestBytes);
            ++this.passDone;
            return authRequestBytes;
        }
        catch (Throwable t) {
            if (t instanceof SaslException) {
                throw (SaslException)t;
            }
            LOG.error("Exception while processing ticket data", t);
            throw new SaslException("Exception while processing ticket data", t);
        }
    }

    @Override
    public boolean hasInitialResponse() {
        return true;
    }

    public static class SaslMaprClientFactory
    implements SaslClientFactory {
        @Override
        public String[] getMechanismNames(Map<String, ?> props) {
            return new String[]{"MAPR-SECURITY"};
        }

        @Override
        public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
            if (mechanisms != null) {
                for (String mechanism : mechanisms) {
                    if (!"MAPR-SECURITY".equals(mechanism)) continue;
                    return new MaprSaslClient(props, cbh);
                }
            }
            return null;
        }
    }
}

