/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.security;

import com.google.protobuf.ByteString;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.fs.proto.Security;
import com.mapr.security.JNISecurity;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.SecretKey;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityHelper {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityHelper.class);
    private static final String DEFAULT_INSTALL_LOCATION = "/opt/mapr";
    private static final String DEFAULT_CREDSTORE_PASSWORD = "none";
    private static final String DEFAULT_CREDSTORE_KEYPASSWORD = "none";

    public static byte[] zookeeperAuthRequestCreationHelper(Security.TicketAndKey ticketAndKey, long sessionId, String clusterName) {
        if (ticketAndKey == null) {
            LOG.error("TicketAndKey is null");
            return null;
        }
        MutableInt err = new MutableInt();
        long randomSecret = System.currentTimeMillis();
        byte[] writeBuffer = new byte[]{(byte)(randomSecret >>> 56), (byte)(randomSecret >>> 48), (byte)(randomSecret >>> 40), (byte)(randomSecret >>> 32), (byte)(randomSecret >>> 24), (byte)(randomSecret >>> 16), (byte)(randomSecret >>> 8), (byte)(randomSecret >>> 0), (byte)(sessionId >>> 56), (byte)(sessionId >>> 48), (byte)(sessionId >>> 40), (byte)(sessionId >>> 32), (byte)(sessionId >>> 24), (byte)(sessionId >>> 16), (byte)(sessionId >>> 8), (byte)(sessionId >>> 0)};
        Security.AuthenticationReqFull.Builder bld = Security.AuthenticationReqFull.newBuilder();
        byte[] secretBytesEncrypted = Security.Encrypt(ticketAndKey.getUserKey(), writeBuffer, err);
        if (err.GetValue() != 0) {
            LOG.error("Could not encrypt ticket with error: " + err.GetValue());
            return null;
        }
        bld.setEncryptedRandomSecret(ByteString.copyFrom((byte[])secretBytesEncrypted));
        bld.setEncryptedTicket(ticketAndKey.getEncryptedTicket());
        SecurityHelper.addCLDBsToAuthReqFull(bld, clusterName);
        byte[] authRequestBytes = bld.build().toByteArray();
        authRequestBytes = Base64.encodeBase64((byte[])authRequestBytes);
        return authRequestBytes;
    }

    public static Security.TicketAndKey ticketReadingHelper() {
        String ticketFileLocation = JNISecurity.GetUserTicketAndKeyFileLocation();
        if (ticketFileLocation == null) {
            LOG.error("TicketKey file is not found");
            return null;
        }
        MutableInt err = new MutableInt();
        int errorCode = Security.SetTicketAndKeyFile(ticketFileLocation);
        if (errorCode != 0) {
            LOG.error("Problem with TicketKey file: " + errorCode);
            return null;
        }
        String currentClusterName = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        if (currentClusterName == null) {
            LOG.error("Current cluster name is not found");
            return null;
        }
        Security.TicketAndKey ticketAndKey = Security.GetTicketAndKeyForCluster(Security.ServerKeyType.ServerKey, currentClusterName, err);
        if (ticketAndKey == null) {
            LOG.error("MaprTicket is not found");
            return null;
        }
        if (!Security.IsTicketAndKeyUsable(ticketAndKey)) {
            LOG.error("My Mapr ticket is expired. Get new one");
            return null;
        }
        return ticketAndKey;
    }

    public static List<String> getHostFromCluster(String clusterName) {
        List<CLDBRpcCommonUtils.IpPort> ipports = CLDBRpcCommonUtils.getInstance().getOriginalClusterMap().get(clusterName);
        if (ipports == null) {
            return null;
        }
        ArrayList<String> res = new ArrayList<String>(ipports.size());
        for (CLDBRpcCommonUtils.IpPort ipport : ipports) {
            List<String> hosts = ipport.getOriginalAddr();
            if (hosts.size() <= 0) continue;
            res.add(hosts.get(0));
        }
        return res;
    }

    public static String getClusterFromHost(List<String> hosts) {
        for (String host : hosts) {
            String cn = CLDBRpcCommonUtils.getInstance().getHostMap().get(host);
            if (cn == null) continue;
            return cn;
        }
        return null;
    }

    public static boolean addCLDBsToAuthReqFull(Security.AuthenticationReqFull.Builder bld, String clusterName) {
        String cn;
        String string = cn = clusterName == null || clusterName.isEmpty() ? CLDBRpcCommonUtils.getInstance().getCurrentClusterName() : clusterName;
        if (cn != null) {
            List<String> hosts = SecurityHelper.getHostFromCluster(cn);
            if (hosts == null) {
                LOG.error("No CLDBs can be found for the cluster " + cn);
                return false;
            }
            bld.addAllCldb(hosts);
            return true;
        }
        LOG.error("Current cluster name is null. Cannot retrieve CLDB host names.");
        return false;
    }

    public static boolean checkCLDBAuthReqFull(Security.AuthenticationReqFull req) {
        String currCluster = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        for (String host : req.getCldbList()) {
            String cn = CLDBRpcCommonUtils.getInstance().getHostMap().get(host);
            if (cn == null || !cn.equals(currCluster)) continue;
            return true;
        }
        return false;
    }

    public static Security.AuthenticationResp createAuthRespWrongTicket() {
        String currCluster = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        Security.AuthenticationResp.Builder res = Security.AuthenticationResp.newBuilder();
        res.setStatus(1);
        res.setError("Ticket for wrong cluster is being used on cluster " + currCluster);
        List<String> hosts = SecurityHelper.getHostFromCluster(currCluster);
        if (hosts == null) {
            LOG.error("No CLDBs can be found for the cluster " + currCluster);
            return null;
        }
        res.addAllReceivingCldb(hosts);
        return res.build();
    }

    public static char[] getPasswordFromCredStore(CredStore credStore, String alias, String storeType, String storePass) throws IllegalArgumentException {
        char[] cArray;
        String credentialStoreType = null;
        String installDir = null;
        String storePassword = null;
        String maprHomeDir = System.getenv("MAPR_HOME");
        if (credStore != CredStore.CRED_KEYSTORE && credStore != CredStore.CRED_TRUSTSTORE) {
            throw new IllegalArgumentException("Credential store must be either CRED_KEYSTORE or CRED_TRUSTSTORE");
        }
        if (!(storeType.equalsIgnoreCase("jks") || storeType.equalsIgnoreCase("jceks") || storeType.equalsIgnoreCase("bcfks"))) {
            throw new IllegalArgumentException("Credential store type must be either jks, jceks or bcfks");
        }
        installDir = maprHomeDir != null ? (!maprHomeDir.isEmpty() ? maprHomeDir : DEFAULT_INSTALL_LOCATION) : DEFAULT_INSTALL_LOCATION;
        String maprConfDir = installDir + "/conf";
        if (storeType.equalsIgnoreCase("jks") || storeType.equalsIgnoreCase("jceks")) {
            credentialStoreType = "jceks";
        } else if (storeType.equalsIgnoreCase("bcfks")) {
            credentialStoreType = storeType;
        } else {
            return null;
        }
        storePassword = storePass == null ? "none" : storePass;
        String keyPassword = storePassword;
        File credsFile = null;
        if (credStore == CredStore.CRED_KEYSTORE) {
            credsFile = new File(maprConfDir, "maprkeycreds." + credentialStoreType);
        } else if (credStore == CredStore.CRED_TRUSTSTORE) {
            credsFile = new File(maprConfDir, "maprtrustcreds." + credentialStoreType);
        }
        FileInputStream fis = new FileInputStream(credsFile);
        try {
            KeyStore ks = credentialStoreType.equals("jceks") ? KeyStore.getInstance(credentialStoreType) : KeyStore.getInstance("BCFKS", "BCFIPS");
            ks.load(fis, storePassword.toCharArray());
            SecretKey secretKey = (SecretKey)ks.getKey(alias, keyPassword.toCharArray());
            byte[] secretBytes = secretKey.getEncoded();
            String secretBytesStr = new String(secretBytes);
            cArray = secretBytesStr.toCharArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return null;
            }
        }
        fis.close();
        return cArray;
    }

    public static enum CredStore {
        CRED_KEYSTORE,
        CRED_TRUSTSTORE;

    }
}

