/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.s3serverutils;

import com.google.protobuf.ByteString;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.fs.Rpc;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Security;
import com.mapr.login.client.MapRLoginHttpsClient;
import com.mapr.security.JNISecurity;
import com.mapr.security.MaprSecurityException;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3ServerRpcCommonUtils {
    private static final Logger LOG = LoggerFactory.getLogger(S3ServerRpcCommonUtils.class);
    private static S3ServerRpcCommonUtils s_instance = null;
    List<Common.IPPort> reachableList = null;
    List<Common.IPPort> unreachableList = null;
    private final String metaDataFile = "/tmp/s3ServerLocations";
    private int listenPort = 0;

    private S3ServerRpcCommonUtils(int listenPort) {
        this.listenPort = listenPort;
        if (this.reachableList == null) {
            try {
                this.getS3ServerLocations();
            }
            catch (Exception e) {
                LOG.error("failed to initializing S3ServerRpcCommonUtils", (Throwable)e);
            }
        }
    }

    public static S3ServerRpcCommonUtils getInstance() {
        return S3ServerRpcCommonUtils.getInstance(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static S3ServerRpcCommonUtils getInstance(int listenPort) {
        if (s_instance != null) return s_instance;
        Class<S3ServerRpcCommonUtils> clazz = S3ServerRpcCommonUtils.class;
        synchronized (S3ServerRpcCommonUtils.class) {
            if (s_instance != null) return s_instance;
            s_instance = new S3ServerRpcCommonUtils(listenPort);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return s_instance;
        }
    }

    public synchronized void getS3ServerLocations() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getS3ServerLocations");
        }
        this.reachableList = this.getSavedList();
        if (this.reachableList != null) {
            return;
        }
        CLDBProto.GetZkConnectStringRequest.Builder reqB = CLDBProto.GetZkConnectStringRequest.newBuilder();
        reqB.setIpType(Common.IPType.INTERNAL_ONLY);
        byte[] data = null;
        int numTry = 0;
        int maxTryBeforeGivingUp = 0;
        do {
            data = CLDBRpcCommonUtils.getInstance().sendRequest(CLDBRpcCommonUtils.getInstance().getCurrentClusterName(), Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.GetZkConnectStringProc.getNumber(), (MessageLite)reqB.build(), CLDBProto.GetZkConnectStringResponse.class, Security.ServerKeyType.ServerKey, this.listenPort);
            if (++numTry < 3) continue;
            try {
                LOG.debug("sleeping before retrying again, failed 3 timed continously");
                Thread.sleep(60000L);
                ++maxTryBeforeGivingUp;
            }
            catch (Exception exception) {
                // empty catch block
            }
            numTry = 0;
        } while (data == null && maxTryBeforeGivingUp <= 3);
        if (data == null) {
            return;
        }
        this.reachableList = new ArrayList<Common.IPPort>();
        this.unreachableList = new ArrayList<Common.IPPort>();
        try {
            CLDBProto.GetZkConnectStringResponse resp = CLDBProto.GetZkConnectStringResponse.parseFrom((byte[])data);
            int unReachableIdx = resp.getS3ServerUnreachableIdx();
            CLDBProto.GetZkConnectStringResponse.Builder dataToSave = CLDBProto.GetZkConnectStringResponse.newBuilder();
            ArrayList psList = new ArrayList();
            psList.addAll(resp.getS3ServersList());
            LOG.debug("recieved list size {} and unrechable server idx as {}", (Object)psList.size(), (Object)unReachableIdx);
            this.reachableList.clear();
            this.reachableList.addAll(new ArrayList(psList.subList(0, unReachableIdx)));
            this.unreachableList.clear();
            this.unreachableList.addAll(new ArrayList(psList.subList(unReachableIdx, psList.size())));
            if (this.reachableList.size() > 0) {
                dataToSave.addAllS3Servers(this.reachableList);
                BufferedOutputStream fw = new BufferedOutputStream(new FileOutputStream("/tmp/s3ServerLocations"));
                fw.write(dataToSave.build().toByteArray());
                fw.flush();
                fw.close();
            }
        }
        catch (IOException e) {
            LOG.error("error while storing s3 server addresses in internal file", (Throwable)e);
        }
    }

    private List<Common.IPPort> getSavedList() {
        if (!new File("/tmp/s3ServerLocations").exists()) {
            return null;
        }
        Path fileLocation = Paths.get("/tmp/s3ServerLocations", new String[0]);
        CLDBProto.GetZkConnectStringResponse resp = null;
        try {
            byte[] data = Files.readAllBytes(fileLocation);
            resp = CLDBProto.GetZkConnectStringResponse.parseFrom((byte[])data);
        }
        catch (Exception e) {
            LOG.error("error in parsing s3 server address file", (Throwable)e);
            this.removeMetaDataFile();
            return null;
        }
        return resp != null && resp.getS3ServersCount() > 0 ? new ArrayList(resp.getS3ServersList()) : null;
    }

    private long getBinding(int port, List<Integer> ips, String clusterName, Security.ServerKeyType keyType) throws Exception {
        MutableInt mutableerr;
        Security.TicketAndKey ticket;
        if (ips.size() == 0) {
            return 0L;
        }
        try {
            int rpcPort = Rpc.initialize(0, 0, clusterName);
            if (rpcPort < 0) {
                LOG.error("error in rpc initilization (unable to get bindings), rpc port:{}", (Object)rpcPort);
                return 0L;
            }
        }
        catch (Exception e) {
            LOG.error("error in rpc initilization (unable to get bindings)", (Throwable)e);
            return 0L;
        }
        if (JNISecurity.IsSecurityEnabled(clusterName) && (ticket = Security.GetTicketAndKeyForCluster(keyType, clusterName, mutableerr = new MutableInt())) == null) {
            int err = Security.SetTicketAndKeyFile(CLDBRpcCommonUtils.getInstance().getPathToServerTicketFile());
            if (err != 0) {
                LOG.error("unable to load secutiry ticket file:{}, error:{}", (Object)CLDBRpcCommonUtils.getInstance().getPathToServerTicketFile(), (Object)err);
            }
            ticket = Security.GetTicketAndKeyForCluster(keyType, clusterName, mutableerr);
        }
        int[] ipsArray = new int[ips.size()];
        int idx = 0;
        for (Integer Ip : ips) {
            ipsArray[idx] = Ip;
            ++idx;
        }
        int flags = CLDBRpcCommonUtils.getInstance().getFlagsForBinding(clusterName, false);
        long binding = Rpc.createBindingForIps2(ipsArray, port, clusterName, keyType.getNumber(), flags);
        return binding;
    }

    private byte[] sendRequestToParticularS3Server(String clusterName, Common.IPPort ips, int procedureId, MessageLite request, Class<? extends MessageLite> responseClass, Security.ServerKeyType keyType) throws Exception {
        try {
            MapRLoginHttpsClient loginClient = new MapRLoginHttpsClient();
            loginClient.quietAuthenticateIfNeeded(clusterName, keyType);
            long binding = this.getBinding(ips.getPort(), ips.getHostsList(), clusterName, keyType);
            if (binding == 0L) {
                LOG.error("Unable to create binding for S3Server");
                return null;
            }
            Method parseFromMethod = responseClass.getMethod("parseFrom", ByteString.class);
            int MAX_ATTEMPTS = 6;
            int nAttempt = 0;
            Integer status = 0;
            do {
                byte[] retBytes;
                if ((retBytes = Rpc.sendRequest(binding, Common.MapRProgramId.CldbS3ServerProgramId.getNumber(), procedureId, request)) != null) {
                    Object returnObject = parseFromMethod.invoke(null, ByteString.copyFrom((byte[])retBytes));
                    Method statusMethod = returnObject.getClass().getMethod("getStatus", new Class[0]);
                    status = (Integer)statusMethod.invoke(returnObject, new Object[0]);
                    if (status == null) {
                        LOG.error("Return Status is not Integer: " + status);
                        return null;
                    }
                    if (status == 30) {
                        LOG.debug("Current Server is READ_ONLY S3Server. Trying another one");
                        return null;
                    }
                    if (status == 3) {
                        if (++nAttempt == 1) {
                            LOG.error("Current Server is attempting to become a master. Retrying!");
                        }
                        if (nAttempt >= 6) continue;
                        Thread.sleep((2 * nAttempt + 1) * 1000);
                        continue;
                    }
                    return retBytes;
                }
                return null;
            } while (nAttempt < 6);
        }
        catch (MaprSecurityException se) {
            LOG.error(se.getMessage());
            throw se;
        }
        return null;
    }

    public byte[] sendRequestToS3Server(int procedureId, MessageLite request, Class<? extends MessageLite> responseClass) throws Exception {
        return this.sendRequestToS3Server(CLDBRpcCommonUtils.getInstance().getDefaultClusterName(), procedureId, request, responseClass);
    }

    public byte[] sendRequestToS3Server(String clusterName, int procedureId, MessageLite request, Class<? extends MessageLite> responseClass) throws Exception {
        return this.sendRequestToS3Server(clusterName, procedureId, request, Security.ServerKeyType.ServerKey, responseClass);
    }

    public byte[] sendRequestToS3Server(String clusterName, int procedureId, MessageLite request, Security.ServerKeyType keytype, Class<? extends MessageLite> responseClass) throws Exception {
        return this.sendRequestToS3Server(clusterName, procedureId, request, keytype, null, responseClass);
    }

    public byte[] sendRequestToS3Server(String clusterName, int procedureId, MessageLite request, Security.ServerKeyType keytype, List<Common.IPPort> ipPort, Class<? extends MessageLite> responseClass) throws Exception {
        boolean fetchedS3ServerLocation = false;
        do {
            int numTry = 0;
            do {
                if (this.reachableList == null) {
                    this.reachableList = this.getSavedList();
                }
                if (this.reachableList != null) continue;
                this.getS3ServerLocations();
                if (this.reachableList == null) {
                    LOG.error("Couldn't fetch s3 server location");
                    return null;
                }
                fetchedS3ServerLocation = true;
            } while (this.reachableList == null && ++numTry <= 3);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reachable List of size{} and Unreachable List of size {} ,ipPort of size {} recieved", new Object[]{this.reachableList != null ? this.reachableList.size() : 0, this.unreachableList != null ? this.unreachableList.size() : 0, ipPort != null ? ipPort.size() : 0});
            }
            try {
                for (int i = 0; i < 2; ++i) {
                    Common.IPPort ip;
                    List<Common.IPPort> listToProcess = null;
                    switch (i) {
                        case 0: {
                            listToProcess = this.reachableList;
                            break;
                        }
                        case 1: {
                            listToProcess = this.unreachableList;
                        }
                    }
                    if (listToProcess == null && ipPort == null) continue;
                    if (ipPort != null) {
                        listToProcess = ipPort;
                    }
                    Collections.shuffle(listToProcess);
                    byte[] data = null;
                    Iterator<Common.IPPort> iterator = listToProcess.iterator();
                    while (iterator.hasNext() && (data = this.sendRequestToParticularS3Server(clusterName, ip = iterator.next(), procedureId, request, responseClass, keytype)) == null) {
                    }
                    if (data == null) continue;
                    return data;
                }
            }
            catch (MaprSecurityException se) {
                LOG.error("excption in sending request, removing previously cache locationerr:{}", (Object)se.getMessage());
                this.removeMetaDataFile();
                throw se;
            }
            this.removeMetaDataFile();
            this.reachableList = null;
        } while (!fetchedS3ServerLocation);
        return null;
    }

    private void removeMetaDataFile() {
        File file = new File("/tmp/s3ServerLocations");
        file.delete();
    }
}

