/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.utils;

import com.mapr.baseutils.utils.ListSorterPurgeTask;
import com.mapr.fs.cldb.proto.CLDBProto;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericSorter<T> {
    private static final Logger LOG = LoggerFactory.getLogger(GenericSorter.class);
    private Map<String, CachedList<T>> sortedListMap = new ConcurrentHashMap<String, CachedList<T>>();

    public abstract void sortList(List<T> var1, CLDBProto.ListSortKey var2);

    protected abstract List<T> getFreshList(CLDBProto.ListSortKey var1);

    protected abstract int getSortedListRefreshSeconds();

    public List<T> getSortedList(CLDBProto.ListSortKey sortingKey) {
        if (this.getSortedListRefreshSeconds() == 0) {
            return this.getFreshList(sortingKey);
        }
        return this.serveListFromCache(sortingKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<T> serveListFromCache(CLDBProto.ListSortKey sortingKey) {
        CachedList<T> cachedList = this.sortedListMap.get(sortingKey.name());
        if (cachedList == null) {
            GenericSorter genericSorter = this;
            synchronized (genericSorter) {
                cachedList = this.sortedListMap.get(sortingKey.name());
                if (cachedList == null) {
                    this.logMessage("building sorted list for key " + sortingKey.name());
                    List<T> list = this.getFreshList(sortingKey);
                    this.sortedListMap.put(sortingKey.name(), new CachedList<T>(list));
                    return list;
                }
                return cachedList.getList();
            }
        }
        if (cachedList.isValid()) {
            this.logMessage("returning cached sorted list for key " + sortingKey.name());
            return cachedList.getList();
        }
        cachedList.lock();
        try {
            if (!cachedList.isValid()) {
                this.logMessage("re-building sorted list for key " + sortingKey.name());
                List<T> list = this.getFreshList(sortingKey);
                cachedList.setList(list);
                ListSorterPurgeTask.getInstance().addToPurgeList(this);
            }
        }
        finally {
            cachedList.unlock();
        }
        return cachedList.getList();
    }

    protected void logMessage(String str) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(str);
        }
    }

    public int compareLong(Long l1, Long l2) {
        return l1.compareTo(l2);
    }

    public int compareString(String s1, String s2) {
        if (s1 == null) {
            s1 = "";
        }
        if (s2 == null) {
            s2 = "";
        }
        return s1.compareTo(s2);
    }

    public int compareBoolean(Boolean b1, Boolean b2) {
        return b1.compareTo(b2);
    }

    public int compareStringIgnoreCase(String s1, String s2) {
        if (s1 == null) {
            s1 = "";
        }
        if (s2 == null) {
            s2 = "";
        }
        return s1.compareToIgnoreCase(s2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean purgeExpiredList() {
        for (Map.Entry<String, CachedList<T>> entry : this.sortedListMap.entrySet()) {
            String key = entry.getKey();
            CachedList cachedList = entry.getValue();
            if (cachedList.isValid()) continue;
            this.logMessage("purgeExpiredList: clearing/expiring cached sorted list for " + key);
            cachedList.lock();
            try {
                if (cachedList.isValid()) continue;
                cachedList.setList(null);
            }
            finally {
                cachedList.unlock();
            }
        }
        return true;
    }

    class CachedList<T> {
        private List<T> list;
        private Lock lock;
        private long createTime;

        CachedList(List<T> newList) {
            this.list = newList;
            this.lock = new ReentrantLock();
            this.createTime = System.currentTimeMillis();
        }

        boolean isValid() {
            long currentTime = System.currentTimeMillis();
            return this.list != null && currentTime <= this.createTime + (long)(GenericSorter.this.getSortedListRefreshSeconds() * 1000);
        }

        List<T> getList() {
            return this.list;
        }

        void setList(List<T> newlist) {
            if (newlist != null) {
                this.createTime = System.currentTimeMillis();
            }
            this.list = newlist;
        }

        void lock() {
            this.lock.lock();
        }

        void unlock() {
            this.lock.unlock();
        }
    }
}

