/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.tedutils;

import com.mapr.baseutils.tedutils.TedProcIdRetMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TedServer {
    private static final Logger LOG = LoggerFactory.getLogger(TedServer.class);
    TedEvent[] tedEvents = new TedEvent[1627];
    TedProcIdRetMap procIdToTedRetVal;

    public TedServer() {
        for (int i = 0; i < 1627; ++i) {
            this.tedEvents[i] = new TedEvent(i);
        }
        this.procIdToTedRetVal = new TedProcIdRetMap();
    }

    public void addToTedRetValMap(int procid, int ret) {
        this.procIdToTedRetVal.addToTedRetValMap(procid, ret);
    }

    public Integer getTedRetVal(int procid) {
        return this.procIdToTedRetVal.getTedRetVal(procid);
    }

    void removeProcIdFromTedMap(int procid) {
        this.procIdToTedRetVal.removeProcId(procid);
    }

    public void enableEvent(int id, Integer proc, Integer retVal) {
        if (id >= this.tedEvents.length) {
            return;
        }
        this.tedEvents[id].enabled = true;
        if (LOG.isInfoEnabled()) {
            LOG.info("Enabled ted event " + id);
        }
        if (proc != null && retVal != null) {
            this.addToTedRetValMap(proc, retVal);
        }
    }

    public boolean eventEnabled(int id) {
        if (id >= this.tedEvents.length) {
            return false;
        }
        return this.tedEvents[id].enabled;
    }

    public void disableEvent(int id, Integer procid) {
        if (id >= this.tedEvents.length) {
            return;
        }
        this.tedEvents[id].enabled = false;
        if (LOG.isInfoEnabled()) {
            LOG.info("Disabled ted event " + id);
        }
        if (procid != null) {
            this.removeProcIdFromTedMap(procid);
        }
    }

    public EventType getEventType(int id) {
        if (id >= 0 && id <= 9) {
            return EventType.NODE_EVENT;
        }
        if (id >= 1000 && id <= 1004) {
            return EventType.VOLUME_EVENT;
        }
        if (id >= 1100 && id <= 1103) {
            return EventType.CID_GENERATOR_EVENT;
        }
        if (id >= 1200 && id <= 1202) {
            return EventType.VOLUME_MANAGER_EVENT;
        }
        if (id >= 1300 && id < 1301) {
            return EventType.KVSTORE_EVENT;
        }
        if (id >= 1400 && id < 1499) {
            return EventType.GENERIC_CLDB_EVENT;
        }
        if (id >= 1500 && id < 1504) {
            return EventType.PBS_EVENT;
        }
        if (id >= 1600 && id < 1627) {
            return EventType.S3_EVENT;
        }
        return EventType.INVALID_EVENT;
    }

    class TedEvent {
        int eventId;
        boolean enabled;

        TedEvent(int id) {
            this.eventId = id;
            this.enabled = false;
        }
    }

    public static enum EventType {
        NODE_EVENT,
        VOLUME_EVENT,
        CID_GENERATOR_EVENT,
        VOLUME_MANAGER_EVENT,
        KVSTORE_EVENT,
        GENERIC_CLDB_EVENT,
        PBS_EVENT,
        S3_EVENT,
        INVALID_EVENT;

    }
}

