/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.utils;

import com.mapr.fs.proto.Security;
import java.util.Iterator;

public class ACL {
    static int AllUsersId = -1;
    Security.AccessControlList aclList;
    public static int AllActionsMask = -1;

    boolean aclEntryMatches(Security.AclEntry aclEntry, int userId) {
        Security.SecurityPrincipal principal = aclEntry.getPrincipal();
        int principalId = principal.getPrincId();
        if (principalId == AllUsersId) {
            return true;
        }
        return principalId == userId;
    }

    boolean aclEntryMatchesExactly(Security.AclEntry aclEntry, int userId) {
        return aclEntry.getPrincipal().getPrincId() == userId;
    }

    boolean bitSet(int mask, int bitMask) {
        return (mask & bitMask) != 0;
    }

    boolean denyAccess(Security.AclEntry entry, int bitMask) {
        if (!entry.hasDeny()) {
            return false;
        }
        int denyMask = entry.getDeny();
        return this.bitSet(denyMask, bitMask);
    }

    boolean allowAccess(Security.AclEntry entry, int bitMask) {
        if (!entry.hasAllow()) {
            return false;
        }
        int allowMask = entry.getAllow();
        return this.bitSet(allowMask, bitMask);
    }

    int allowedAccess(int id, boolean isUser, int bitMask) {
        int userid = ACL.makePrincipalId(id, isUser);
        for (Security.AclEntry entry : this.aclList.getAclList()) {
            if (!this.aclEntryMatches(entry, userid)) continue;
            if (this.denyAccess(entry, bitMask)) {
                return -1;
            }
            if (!this.allowAccess(entry, bitMask)) continue;
            return 1;
        }
        return 0;
    }

    public boolean verifyPermissions(Security.CredentialsMsg creds, int bitMask) {
        return this.verifyPermissions(creds, bitMask, null);
    }

    public boolean verifyPermissions(Security.CredentialsMsg creds, int bitMask, StringBuilder errorMsg) {
        long clusterOpsMask;
        boolean accessDenied = false;
        if (creds == null) {
            if (errorMsg != null && errorMsg.length() == 0) {
                errorMsg.append("Missing credentials");
            }
            return false;
        }
        if (creds.hasCapabilities() && creds.getCapabilities().hasClusterOpsMask() && ((int)(clusterOpsMask = creds.getCapabilities().getClusterOpsMask()) & bitMask) != 0) {
            return true;
        }
        if (this.aclList == null) {
            if (errorMsg != null && errorMsg.length() == 0) {
                errorMsg.append("ACL not found, not yet initialized");
            }
            return false;
        }
        int check = this.allowedAccess(creds.getUid(), true, bitMask);
        if (check == -1) {
            accessDenied = true;
        }
        if (check == 1) {
            return true;
        }
        Iterator iterator = creds.getGidsList().iterator();
        while (iterator.hasNext()) {
            int gid = (Integer)iterator.next();
            check = this.allowedAccess(gid, false, bitMask);
            if (check == -1) {
                accessDenied = true;
            }
            if (check != 1 || accessDenied) continue;
            return true;
        }
        if (errorMsg != null && errorMsg.length() == 0) {
            errorMsg.append("User do not have permissions to read ACL");
        }
        return false;
    }

    public boolean setPermissionsForId(int id, boolean isUser, int allowMask, int denyMask) {
        Security.AccessControlList.Builder aclBuilder = Security.AccessControlList.newBuilder((Security.AccessControlList)this.aclList);
        int userid = ACL.makePrincipalId(id, isUser);
        int index = 0;
        for (Security.AclEntry entry : this.aclList.getAclList()) {
            if (this.aclEntryMatchesExactly(entry, userid)) {
                int newAllowMask = allowMask;
                int newDenyMask = denyMask;
                Security.AclEntry.Builder newEntry = Security.AclEntry.newBuilder();
                newEntry.setPrincipal(entry.getPrincipal());
                newEntry.setAllow(newAllowMask);
                newEntry.setDeny(newDenyMask);
                aclBuilder.setAcl(index, newEntry);
                this.aclList = aclBuilder.build();
                return true;
            }
            ++index;
        }
        return false;
    }

    public boolean changePrincipal(int oldPrincipal, int newPrincipal) {
        Security.AccessControlList.Builder aclBuilder = Security.AccessControlList.newBuilder((Security.AccessControlList)this.aclList);
        int index = 0;
        for (Security.AclEntry entry : this.aclList.getAclList()) {
            if (entry.getPrincipal().getPrincId() == oldPrincipal) {
                Security.SecurityPrincipal.Builder newSP = Security.SecurityPrincipal.newBuilder();
                newSP.setPrincId(newPrincipal);
                Security.AclEntry.Builder newAclEntryBuilder = Security.AclEntry.newBuilder((Security.AclEntry)entry);
                newAclEntryBuilder.setPrincipal(newSP);
                aclBuilder.setAcl(index, newAclEntryBuilder);
                this.aclList = aclBuilder.build();
                return true;
            }
            ++index;
        }
        return false;
    }

    public boolean updateAclEntry(Security.AclEntry newAclEntry) {
        Security.AccessControlList.Builder aclBuilder = Security.AccessControlList.newBuilder((Security.AccessControlList)this.aclList);
        int index = 0;
        for (Security.AclEntry entry : this.aclList.getAclList()) {
            if (entry.getPrincipal().getPrincId() == newAclEntry.getPrincipal().getPrincId()) {
                aclBuilder.setAcl(index, newAclEntry);
                this.aclList = aclBuilder.build();
                return true;
            }
            ++index;
        }
        return false;
    }

    public void addAclEntry(Security.AclEntry newAclEntry) {
        Security.AccessControlList.Builder aclBuilder = Security.AccessControlList.newBuilder();
        aclBuilder.addAcl(newAclEntry);
        aclBuilder.mergeFrom(this.aclList);
        this.aclList = aclBuilder.build();
    }

    public void addPermissionsForId(int id, boolean isUser, int allowMask, int denyMask) {
        Security.AccessControlList.Builder aclBuilder = Security.AccessControlList.newBuilder();
        Security.AclEntry.Builder aclEntryBuilder = Security.AclEntry.newBuilder().setAllow(allowMask).setDeny(denyMask).setPrincipal(ACL.makePrincipal(id, isUser));
        if (id == AllUsersId) {
            aclBuilder.addAcl(aclEntryBuilder);
            aclBuilder.mergeFrom(this.aclList);
        } else {
            aclBuilder.mergeFrom(this.aclList);
            aclBuilder.addAcl(aclEntryBuilder);
        }
        this.aclList = aclBuilder.build();
    }

    public boolean removeAllPermissionsForId(int id, boolean isUser) {
        Security.AccessControlList.Builder aclBuilder = Security.AccessControlList.newBuilder();
        int userid = ACL.makePrincipalId(id, isUser);
        boolean idFound = false;
        for (Security.AclEntry entry : this.aclList.getAclList()) {
            if (!this.aclEntryMatchesExactly(entry, userid)) {
                aclBuilder.addAcl(entry);
                continue;
            }
            idFound = true;
        }
        this.aclList = aclBuilder.build();
        return idFound;
    }

    public Security.AccessControlList getAclList() {
        return this.aclList;
    }

    public Security.AccessControlList getAclList(int principalId, boolean isUser) {
        Security.AccessControlList.Builder aclListBuilder = Security.AccessControlList.newBuilder();
        int id = ACL.makePrincipalId(principalId, isUser);
        for (Security.AclEntry entry : this.aclList.getAclList()) {
            if (!this.aclEntryMatchesExactly(entry, id)) continue;
            aclListBuilder.addAcl(entry);
            break;
        }
        return aclListBuilder.build();
    }

    public ACL(Security.AccessControlList aclList) {
        this.aclList = aclList;
    }

    public static Security.SecurityPrincipal allUsers() {
        return Security.SecurityPrincipal.newBuilder().setPrincId(AllUsersId).build();
    }

    public static boolean allUsers(int id) {
        return id == AllUsersId;
    }

    public static Security.SecurityPrincipal userUid(int uid) {
        return Security.SecurityPrincipal.newBuilder().setPrincId(uid).build();
    }

    public static Security.SecurityPrincipal groupGid(int gid) {
        return Security.SecurityPrincipal.newBuilder().setPrincId(gid |= Integer.MIN_VALUE).build();
    }

    public static int makePrincipalId(int id, boolean isUser) {
        if (isUser) {
            return id;
        }
        return id | Integer.MIN_VALUE;
    }

    public static Security.SecurityPrincipal makePrincipal(int id, boolean isUser) {
        int userid = ACL.makePrincipalId(id, isUser);
        return Security.SecurityPrincipal.newBuilder().setPrincId(userid).build();
    }

    public static boolean isGid(int princId) {
        return (princId & Integer.MIN_VALUE) != 0;
    }

    public static int getGid(int princId) {
        return princId & Integer.MAX_VALUE;
    }

    public static boolean isUid(int princId) {
        return (princId & Integer.MIN_VALUE) == 0;
    }

    public static void main(String[] args) {
        Security.CredentialsMsg unknownUser;
        int action;
        Security.SecurityPrincipal allUsers = ACL.allUsers();
        Security.AclEntry allowAll = Security.AclEntry.newBuilder().setPrincipal(allUsers).setAllow(-1).build();
        Security.AccessControlList list = Security.AccessControlList.newBuilder().addAcl(allowAll).build();
        ACL acl = new ACL(list);
        Security.CredentialsMsg creds = Security.CredentialsMsg.newBuilder().setUid(100).addGids(100).addGids(200).build();
        System.out.println("Starting tests");
        for (action = 0; action < 32; ++action) {
            if (acl.verifyPermissions(creds, 1 << action)) continue;
            System.out.println("FAIL: Allow ALL test for action = " + action);
            System.exit(-1);
        }
        acl.setPermissionsForId(AllUsersId, true, -1, -1);
        for (action = 0; action < 32; ++action) {
            if (!acl.verifyPermissions(creds, 1 << action)) continue;
            System.out.println("FAIL: Deny ALL test for action = " + action);
            System.exit(-1);
        }
        acl.removeAllPermissionsForId(AllUsersId, true);
        acl.addPermissionsForId(100, false, -1, 1);
        if (acl.verifyPermissions(creds, 1)) {
            System.out.println("FAIL: Allow all except 0 failed for 0");
            System.exit(-1);
        }
        if (!acl.verifyPermissions(creds, 2)) {
            System.out.println("FAIL: Allow all except 0 failed for 1");
            System.exit(-1);
        }
        acl.removeAllPermissionsForId(100, false);
        acl.addPermissionsForId(100, true, 15, 1);
        if (acl.verifyPermissions(creds, 1)) {
            System.out.println("FAIL: Allow 0xF except 0 failed for 0");
            System.exit(-1);
        }
        if (!acl.verifyPermissions(creds, 2)) {
            System.out.println("FAIL: Allow 0xF except 0 failed for 1");
            System.exit(-1);
        }
        if (acl.verifyPermissions(unknownUser = Security.CredentialsMsg.newBuilder().setUid(0x100000).build(), 1)) {
            System.out.println("FAIL: Unknown user should have no permissions allowed");
            System.exit(-1);
        }
        acl.addPermissionsForId(200, false, 240, 0);
        acl.addPermissionsForId(300, false, 3840, 0);
        if (acl.verifyPermissions(creds, 1)) {
            System.out.println("FAIL: User 100 should have no permissions for action 0");
            System.exit(-1);
        }
        if (!acl.verifyPermissions(creds, 2)) {
            System.out.println("FAIL: User 100 should have permissions for action 1");
            System.exit(-1);
        }
        if (!acl.verifyPermissions(creds, 128)) {
            System.out.println("FAIL: Group 200 should have permissions for action 7");
            System.exit(-1);
        }
        if (acl.verifyPermissions(creds, 2048)) {
            System.out.println("FAIL: Group 300 should have no permissions for action 11");
            System.exit(-1);
        }
        acl.addPermissionsForId(AllUsersId, true, -1, 0);
        if (!acl.verifyPermissions(creds, 1)) {
            System.out.println("FAIL: User 100 should have permissions for action 0");
            System.exit(-1);
        }
        System.out.println("All tests passed");
    }
}

