/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.sso.roles;

import com.mapr.baseutils.sso.roles.SSORole;
import com.mapr.fs.cldb.proto.CLDBProto;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSORoleTranslator {
    private static Logger LOG = LoggerFactory.getLogger(SSORoleTranslator.class);
    private static SSORoleTranslator translator = null;

    private SSORoleTranslator() {
    }

    public static SSORoleTranslator getInstance() {
        if (translator == null) {
            translator = new SSORoleTranslator();
        }
        return translator;
    }

    public long getClusterCapabilities(List<String> ssoRoles) {
        long clusterCapabilities = 0L;
        if (ssoRoles == null) {
            return clusterCapabilities;
        }
        LOG.debug("recieved Roles: {}.", ssoRoles);
        ArrayList<String> skippedRoles = new ArrayList<String>();
        for (String ssoRole : ssoRoles) {
            SSORole role = SSORole.getByName(ssoRole);
            if (role == null) {
                skippedRoles.add(ssoRole);
                continue;
            }
            switch (role) {
                case DEVELOPER: {
                    clusterCapabilities |= (long)(1 << CLDBProto.ClusterActions.CLUSTER_READ_ONLY.getNumber() | 1 << CLDBProto.ClusterActions.CLUSTER_CREATE_VOLUMES.getNumber());
                    break;
                }
                case INFRASTRUCTURE_ADMIN: {
                    clusterCapabilities |= (long)(1 << CLDBProto.ClusterActions.CLUSTER_ADMIN.getNumber());
                    break;
                }
                case FABRIC_MANAGER: {
                    clusterCapabilities |= (long)(1 << CLDBProto.ClusterActions.CLUSTER_FULL_CONTROL.getNumber());
                    break;
                }
            }
        }
        if (!skippedRoles.isEmpty()) {
            LOG.debug("skipped Roles: {}, as these are not undefinded.", skippedRoles);
        }
        return clusterCapabilities;
    }
}

