/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.security.zookeeper.auth;

import com.mapr.fs.ShimLoader;
import com.mapr.fs.proto.Security;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import org.apache.commons.codec.binary.Base64;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.auth.AuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaprZKAuthProvider
implements AuthenticationProvider {
    private static final Logger LOG;
    public static final String MAPR_ZK_AUTH_PROVIDER_SCHEME = "maprauth";
    private static final long MAX_EPOCH_DELAY = 600000L;
    private static final String cldbKeyFile;
    private static final String configuredEpochDelay;
    private static long epochDelay;

    public MaprZKAuthProvider() throws InstantiationException {
        Security.Key cldbKey;
        try {
            epochDelay = Long.valueOf(configuredEpochDelay);
        }
        catch (NumberFormatException nfe) {
            LOG.warn("Configured Epoch Delay is not a number: " + configuredEpochDelay + ". Will use default");
        }
        if (cldbKeyFile == null) {
            LOG.error("Location of ZK cldb key is not set");
            throw new InstantiationException("Location of ZK cldb key is not set");
        }
        MutableInt err = new MutableInt();
        int errCode = Security.SetKeyFile(Security.ServerKeyType.CldbKey, cldbKeyFile);
        if (errCode != 0) {
            LOG.error("Failed to set cldb key file " + cldbKeyFile + " err " + err);
            throw new InstantiationException("Failed to set cldb key file " + cldbKeyFile + " err " + err);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Set the cldb key file to " + cldbKeyFile);
        }
        if ((cldbKey = Security.GetKey(Security.ServerKeyType.CldbKey, err)) == null) {
            LOG.error("Cldb key can not be obtained: " + err.GetValue());
            throw new InstantiationException("Cldb key can not be obtained: " + err.GetValue());
        }
        Security.Key serverKey = Security.GetServerKey(cldbKey, 0L);
        if (serverKey == null) {
            LOG.error("Server key can not be obtained");
            throw new InstantiationException("Server key can not be obtained");
        }
        errCode = Security.SetKey(Security.ServerKeyType.ServerKey, serverKey);
        if (errCode != 0) {
            LOG.error("Failed to set Server key with error: " + err);
            throw new InstantiationException("Failed to set Server key with error: " + err);
        }
    }

    public String getScheme() {
        return MAPR_ZK_AUTH_PROVIDER_SCHEME;
    }

    public KeeperException.Code handleAuthentication(ServerCnxn cnxn, byte[] authData) {
        if (authData == null || authData.length < 1) {
            LOG.error("Received challenge is empty when secret expected");
            return KeeperException.Code.AUTHFAILED;
        }
        try {
            byte[] base64decoded = Base64.decodeBase64((byte[])authData);
            Security.AuthenticationReqFull reply = Security.AuthenticationReqFull.parseFrom((byte[])base64decoded);
            if (reply != null && reply.getEncryptedTicket() != null) {
                byte[] encryptedTicket = reply.getEncryptedTicket().toByteArray();
                MutableInt err = new MutableInt();
                Security.Ticket decryptedTicket = Security.DecryptTicket(encryptedTicket, err);
                if (err.GetValue() != 0 || decryptedTicket == null) {
                    LOG.error("Error while trying to decrypt ticket: " + err.GetValue());
                    return KeeperException.Code.AUTHFAILED;
                }
                Security.CredentialsMsg userCreds = decryptedTicket.getUserCreds();
                Security.Key userKey = decryptedTicket.getUserKey();
                if (userCreds == null || userKey == null) {
                    LOG.error("Incoming info is not valid");
                    return KeeperException.Code.AUTHFAILED;
                }
                String uID = Integer.toString(userCreds.getUid());
                byte[] secretNumberBytes = reply.getEncryptedRandomSecret().toByteArray();
                byte[] secretNumberBytesDecrypted = Security.Decrypt(userKey, secretNumberBytes, err);
                if (secretNumberBytesDecrypted.length != 16) {
                    LOG.error("Bad random secret");
                    return KeeperException.Code.AUTHFAILED;
                }
                long returnLong = ((long)secretNumberBytesDecrypted[0] << 56) + ((long)(secretNumberBytesDecrypted[1] & 0xFF) << 48) + ((long)(secretNumberBytesDecrypted[2] & 0xFF) << 40) + ((long)(secretNumberBytesDecrypted[3] & 0xFF) << 32) + ((long)(secretNumberBytesDecrypted[4] & 0xFF) << 24) + (long)((secretNumberBytesDecrypted[5] & 0xFF) << 16) + (long)((secretNumberBytesDecrypted[6] & 0xFF) << 8) + (long)((secretNumberBytesDecrypted[7] & 0xFF) << 0);
                long currentTime = System.currentTimeMillis();
                if (Math.abs(currentTime - returnLong) > epochDelay) {
                    LOG.warn("Epoch on client differs > " + epochDelay + "ms. then on server: " + currentTime + ", client: " + returnLong + ". Most likely it is related to ZK disconnect");
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("on server: " + currentTime + ", client: " + returnLong);
                }
                long clientSession = ((long)secretNumberBytesDecrypted[8] << 56) + ((long)(secretNumberBytesDecrypted[9] & 0xFF) << 48) + ((long)(secretNumberBytesDecrypted[10] & 0xFF) << 40) + ((long)(secretNumberBytesDecrypted[11] & 0xFF) << 32) + ((long)(secretNumberBytesDecrypted[12] & 0xFF) << 24) + (long)((secretNumberBytesDecrypted[13] & 0xFF) << 16) + (long)((secretNumberBytesDecrypted[14] & 0xFF) << 8) + (long)((secretNumberBytesDecrypted[15] & 0xFF) << 0);
                Id myId = new Id(this.getScheme(), uID);
                cnxn.addAuthInfo(myId);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Auth info size: " + cnxn.getAuthInfo().size());
                }
                return KeeperException.Code.OK;
            }
            LOG.error("Malformed auth info");
            return KeeperException.Code.AUTHFAILED;
        }
        catch (Throwable t) {
            LOG.error("Bad server key ", t);
            return KeeperException.Code.AUTHFAILED;
        }
    }

    public boolean isAuthenticated() {
        return true;
    }

    public boolean isValid(String id) {
        return true;
    }

    public boolean matches(String id, String aclExpr) {
        if (aclExpr.equals("anyone")) {
            return true;
        }
        return id.equals(aclExpr);
    }

    static {
        ShimLoader.load();
        LOG = LoggerFactory.getLogger(MaprZKAuthProvider.class);
        cldbKeyFile = System.getProperty("zookeeper.mapr.cldbkeyfile.location");
        configuredEpochDelay = System.getProperty("zookeeper.mapr.epoch.delay", "600000");
        epochDelay = 600000L;
    }
}

