/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.security.maprsasl;

import com.mapr.fs.proto.Security;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import com.mapr.security.SecurityHelper;
import com.mapr.security.callback.MaprSaslCallbackHandler;
import com.mapr.security.maprsasl.MapRSaslImplBase;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaprSaslServer
extends MapRSaslImplBase
implements SaslServer {
    private static final Logger LOG = LoggerFactory.getLogger(MaprSaslServer.class);
    private boolean firstPassDone;
    private CallbackHandler cbh;
    private String authorizationId;
    private String authenticationId;
    private String localqopProperty;

    public MaprSaslServer(CallbackHandler cbh, String protocol, Map<String, ?> props) throws SaslException {
        super(props);
        if (props == null || props.isEmpty()) {
            this.localqopProperty = QOP.AUTHENTICATION.getQopString();
        } else {
            for (Map.Entry<String, ?> entry : props.entrySet()) {
                Object valueO;
                String key = entry.getKey();
                if (!key.equals("javax.security.sasl.qop") || !((valueO = entry.getValue()) instanceof String)) continue;
                this.localqopProperty = (String)entry.getValue();
            }
        }
        this.cbh = cbh;
    }

    @Override
    public void dispose() throws SaslException {
        this.sessionKey = null;
        this.authorizationId = null;
        this.authenticationId = null;
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        if (!this.firstPassDone) {
            if (response == null || response.length < 1) {
                throw new SaslException("Received challenge is empty when secret expected");
            }
            MaprSaslCallbackHandler.MaprCallback mc = new MaprSaslCallbackHandler.MaprCallback();
            try {
                this.cbh.handle(new Callback[]{mc});
            }
            catch (IOException e) {
                throw new SaslException("MaprSaslClient IO Exception while handling callback");
            }
            catch (UnsupportedCallbackException e) {
                throw new SaslException("MaprSaslClient Error acquiring Subject");
            }
            try {
                byte[] base64decoded = Base64.decodeBase64((byte[])response);
                Security.AuthenticationReqFull reply = Security.AuthenticationReqFull.parseFrom((byte[])base64decoded);
                if (reply != null && reply.getEncryptedTicket() != null) {
                    byte[] encryptedTicket = reply.getEncryptedTicket().toByteArray();
                    MutableInt err = new MutableInt();
                    Security.Ticket decryptedTicket = Security.DecryptTicket(encryptedTicket, err);
                    if (err.GetValue() != 0 || decryptedTicket == null) {
                        if (SecurityHelper.checkCLDBAuthReqFull(reply)) {
                            throw new SaslException("Error while trying to decrypt ticket: " + err.GetValue());
                        }
                        byte[] resp = SecurityHelper.createAuthRespWrongTicket().toByteArray();
                        return Base64.encodeBase64((byte[])resp);
                    }
                    Security.CredentialsMsg userCreds = decryptedTicket.getUserCreds();
                    Security.Key userKey = decryptedTicket.getUserKey();
                    this.authorizationId = userCreds.getUserName();
                    byte[] secretNumberBytes = reply.getEncryptedRandomSecret().toByteArray();
                    byte[] secretNumberBytesDecrypted = Security.Decrypt(userKey, secretNumberBytes, err);
                    if (secretNumberBytesDecrypted.length != 8) {
                        throw new SaslException("Bad random ticket");
                    }
                    long returnLong = ((long)secretNumberBytesDecrypted[0] << 56) + ((long)(secretNumberBytesDecrypted[1] & 0xFF) << 48) + ((long)(secretNumberBytesDecrypted[2] & 0xFF) << 40) + ((long)(secretNumberBytesDecrypted[3] & 0xFF) << 32) + ((long)(secretNumberBytesDecrypted[4] & 0xFF) << 24) + (long)((secretNumberBytesDecrypted[5] & 0xFF) << 16) + (long)((secretNumberBytesDecrypted[6] & 0xFF) << 8) + (long)((secretNumberBytesDecrypted[7] & 0xFF) << 0);
                    Security.AuthenticationResp.Builder authResp = Security.AuthenticationResp.newBuilder();
                    authResp.setChallengeResponse(returnLong);
                    if (!QOP.AUTHENTICATION.getQopString().equals(this.localqopProperty)) {
                        this.sessionKey = Security.GenerateRandomKey();
                        authResp.setSessionKey(this.sessionKey);
                    }
                    authResp.setStatus(0);
                    int qopIntOption = QOP.getIntFromQOPString(this.localqopProperty);
                    if (qopIntOption < 0) {
                        throw new SaslException("Invalid QOP option: " + this.localqopProperty);
                    }
                    authResp.setEncodingType(qopIntOption);
                    byte[] resp = authResp.build().toByteArray();
                    byte[] respEncrypted = Security.Encrypt(userKey, resp, err);
                    this.firstPassDone = true;
                    return Base64.encodeBase64((byte[])respEncrypted);
                }
                LOG.error("Malformed client response");
                throw new SaslException("Malformed client response");
            }
            catch (Throwable t) {
                throw new SaslException("Bad server key ", t);
            }
        }
        if (response.length != 0) {
            throw new SaslException("Unexpected evaluation requested");
        }
        this.completed = true;
        this.negotiatedQOPProperty = this.localqopProperty;
        return null;
    }

    @Override
    public String getAuthorizationID() {
        return this.authorizationId;
    }

    public static class SaslMaprServerFactory
    implements SaslServerFactory {
        @Override
        public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) {
            if ("MAPR-SECURITY".equals(mechanism)) {
                try {
                    return new MaprSaslServer(cbh, protocol, props);
                }
                catch (SaslException e) {
                    return null;
                }
            }
            return null;
        }

        @Override
        public String[] getMechanismNames(Map<String, ?> props) {
            return new String[]{"MAPR-SECURITY"};
        }
    }

    static enum QOP {
        AUTHENTICATION("auth", 1),
        INTEGRITY("auth-int", 2),
        PRIVACY("auth-conf", 4);

        private final int optionInt;
        private final String qopString;

        private QOP(String qopString, int optionInt) {
            this.qopString = qopString;
            this.optionInt = optionInt;
        }

        public int getOptionInt() {
            return this.optionInt;
        }

        public String getQopString() {
            return this.qopString;
        }

        public static int getIntFromQOPString(String option) {
            for (QOP value : QOP.values()) {
                if (!value.getQopString().equals(option)) continue;
                return value.getOptionInt();
            }
            return -1;
        }

        public static String getStringFromQOPInt(int intOption) {
            for (QOP value : QOP.values()) {
                if (value.getOptionInt() != intOption) continue;
                return value.getQopString();
            }
            return null;
        }
    }
}

