/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.baseutils.utils;

import com.mapr.baseutils.utils.ListSorterPurgeTask;
import com.mapr.fs.cldb.proto.CLDBProto;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericSorter<T> {
    private static final Logger LOG = LoggerFactory.getLogger(GenericSorter.class);
    private long listCreateTimeInMillis = 0L;
    private Map<String, List<T>> sortedListMap = new ConcurrentHashMap<String, List<T>>();

    public abstract void sortList(List<T> var1, CLDBProto.ListSortKey var2);

    protected abstract List<T> getFreshList(CLDBProto.ListSortKey var1);

    protected abstract int getSortedListRefreshSeconds();

    private long getValidDurationMillis() {
        return this.listCreateTimeInMillis + (long)(this.getSortedListRefreshSeconds() * 1000);
    }

    public List<T> getSortedList(CLDBProto.ListSortKey sortingKey) {
        if (this.getSortedListRefreshSeconds() == 0) {
            return this.getFreshList(sortingKey);
        }
        long now = System.currentTimeMillis();
        List<T> list = this.sortedListMap.get(sortingKey.name());
        if (now <= this.getValidDurationMillis() && list != null) {
            this.logMessage("returning cached sorted list for key " + sortingKey.name());
            return list;
        }
        this.purgeExpiredList();
        this.logMessage("building sorted list for key " + sortingKey.name());
        list = this.buildSortedList(sortingKey);
        if (list != null) {
            ListSorterPurgeTask.getInstance().addToPurgeList(this);
        }
        return list;
    }

    protected void logMessage(String str) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(str);
        }
    }

    private synchronized List<T> buildSortedList(CLDBProto.ListSortKey sortingKey) {
        List<T> freshList = this.getFreshList(sortingKey);
        if (freshList == null) {
            return null;
        }
        this.sortedListMap.put(sortingKey.name(), freshList);
        return freshList;
    }

    public int compareLong(Long l1, Long l2) {
        return l1.compareTo(l2);
    }

    public int compareString(String s1, String s2) {
        if (s1 == null) {
            s1 = "";
        }
        if (s2 == null) {
            s2 = "";
        }
        return s1.compareTo(s2);
    }

    public int compareBoolean(Boolean b1, Boolean b2) {
        return b1.compareTo(b2);
    }

    public int compareStringIgnoreCase(String s1, String s2) {
        if (s1 == null) {
            s1 = "";
        }
        if (s2 == null) {
            s2 = "";
        }
        return s1.compareToIgnoreCase(s2);
    }

    public synchronized boolean purgeExpiredList() {
        if (System.currentTimeMillis() > this.getValidDurationMillis()) {
            this.logMessage("clearing/expiring cached sorted list");
            this.sortedListMap.clear();
            this.listCreateTimeInMillis = System.currentTimeMillis();
            return true;
        }
        return false;
    }
}

