/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams.tests.producer;

import com.mapr.db.tests.utils.DBTests;
import com.mapr.streams.Admin;
import com.mapr.streams.StreamDescriptor;
import com.mapr.streams.Streams;
import com.mapr.streams.tests.producer.ProducerMultiTest;
import com.mapr.streams.tests.producer.SendMessagesToProducer;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class ProducerIdExpiryMfsRestartWithErrInjectionTest
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(ProducerIdExpiryMfsRestartWithErrInjectionTest.class);
    private static final String PREFIX = "/jtest-" + ProducerIdExpiryMfsRestartWithErrInjectionTest.class.getSimpleName() + "-";
    private static Admin madmin;
    private static final int numParts = 1;
    private static final String TED_FILE = "build_fileserver/fs/common/ted/ted";
    private static Path repoRootPath;
    private static Path tedCmdPath;
    private static final String SET_TED_CMD = " enable IdempotentRequestDrop";
    private static final String RESET_TED_CMD = " disable IdempotentRequestDrop";

    @BeforeClass
    public static void setupTest() throws Exception {
        Configuration conf = new Configuration();
        madmin = Streams.newAdmin((Configuration)conf);
        String sname = PREFIX + "idempotentproducer";
        try {
            madmin.deleteStream(sname);
        }
        catch (Exception exception) {
            // empty catch block
        }
        StreamDescriptor sdesc = Streams.newStreamDescriptor();
        sdesc.setProducerIdExpirySecs(5L);
        madmin.createStream(sname, sdesc);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        String sname = PREFIX + "idempotentproducer";
        try {
            madmin.deleteStream(sname);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void consumeMsgs(String topicName, KafkaConsumer<byte[], byte[]> kafkaconsumer, int numMsgs, int numPartitions) throws Exception {
        int count;
        ConsumerRecords recs;
        ArrayList<String> topics = new ArrayList<String>();
        topics.add(topicName);
        kafkaconsumer.subscribe(topics);
        try {
            Thread.sleep(100L);
        }
        catch (Exception e) {
            System.out.println("Sleep interrupted " + e);
        }
        for (count = 0; count < numMsgs * numPartitions + 1; count += recs.count()) {
            recs = kafkaconsumer.poll(0L);
        }
        Assert.assertTrue((numMsgs * numPartitions < count ? 1 : 0) != 0);
    }

    @Test
    public void testProducerIdExpiryMfsRestart() throws Exception {
        String sname = PREFIX + "idempotentproducer";
        String topicName = ":t";
        Properties props = new Properties();
        props.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        props.put("enable.idempotence", (Object)true);
        KafkaProducer kafkaproducer = new KafkaProducer(props);
        Properties listenerProps = new Properties();
        listenerProps.put("key.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        listenerProps.put("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        listenerProps.put("fetch.min.bytes", "1");
        listenerProps.put("auto.offset.reset", "earliest");
        listenerProps.put("enable.auto.commit", (Object)false);
        KafkaConsumer kafkaconsumer = new KafkaConsumer(listenerProps);
        madmin.createTopic(sname, "t", 1);
        int msgSize = 0x200000;
        int numMsgs = 500;
        ProducerMultiTest.CountCallback cb = new ProducerMultiTest.CountCallback(numMsgs);
        SendMessagesToProducer producer = new SendMessagesToProducer(kafkaproducer, cb, sname + topicName, 1, numMsgs, msgSize, false);
        Thread producerThread = new Thread(producer);
        producerThread.start();
        producerThread.join();
        String cmd = null;
        int setStatus = 0;
        cmd = tedCmdPath.toString() + SET_TED_CMD;
        setStatus = DBTests.ExecuteShellCmdAndGetReturnCode((String)cmd);
        if (setStatus != 0) {
            throw new IOException(cmd + " failed with exitStatus: " + setStatus);
        }
        cb = new ProducerMultiTest.CountCallback(numMsgs);
        try {
            Thread.sleep(5000L);
        }
        catch (Exception e) {
            System.out.println("Sleep interrupted " + e);
        }
        producer = new SendMessagesToProducer(kafkaproducer, cb, sname + topicName, 1, numMsgs, msgSize, false);
        producerThread = new Thread(producer);
        producerThread.start();
        try {
            Thread.sleep(6000L);
        }
        catch (Exception e) {
            System.out.println("Sleep interrupted " + e);
        }
        ProcessBuilder proc = new ProcessBuilder("sudo", "maprcli", "trace", "dump");
        Process process = proc.start();
        process.waitFor();
        proc = new ProcessBuilder("sudo", "service", "mapr-warden", "restart");
        process = proc.start();
        process.waitFor();
        producerThread.join();
        this.consumeMsgs(sname + topicName, (KafkaConsumer<byte[], byte[]>)kafkaconsumer, numMsgs * 2, 1);
        kafkaconsumer.unsubscribe();
        kafkaconsumer.close();
        kafkaproducer.close();
    }

    static {
        repoRootPath = null;
        tedCmdPath = null;
        repoRootPath = BaseTest.getSourceRoot();
        if (repoRootPath != null && !Files.exists(tedCmdPath = repoRootPath.resolve(TED_FILE), new LinkOption[0])) {
            tedCmdPath = null;
        }
    }
}

