/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.streams.impl.producer;

import com.mapr.streams.impl.producer.MarlinProducerResultImpl;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.producer.RecordMetadata;

public final class MarlinFuture
implements Future<RecordMetadata> {
    private final MarlinProducerResultImpl result;

    public MarlinFuture(MarlinProducerResultImpl result) {
        this.result = result;
    }

    @Override
    public boolean cancel(boolean interrupt) {
        return false;
    }

    @Override
    public RecordMetadata get() throws InterruptedException, ExecutionException {
        this.result.await();
        return this.valueOrError();
    }

    @Override
    public RecordMetadata get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        boolean occurred = this.result.await(timeout, unit);
        if (!occurred) {
            throw new TimeoutException("Timeout after waiting for " + TimeUnit.MILLISECONDS.convert(timeout, unit) + " ms.");
        }
        return this.valueOrError();
    }

    RecordMetadata valueOrError() throws ExecutionException {
        if (this.result.error() != null) {
            throw new ExecutionException(this.result.error());
        }
        return this.value();
    }

    RecordMetadata value() {
        return this.result.getRecordMetadata();
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.result.completed();
    }
}

