/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.web.security;

import com.mapr.web.security.MapRUser;
import com.mapr.web.security.WebSecurityConfig;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.security.Keys;
import io.jsonwebtoken.security.WeakKeyException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;

@Component
public class TokenUtil
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(TokenUtil.class);
    private static final long serialVersionUID = -3301605591108950415L;
    private static final int HS512_KEY_LENGTH_BYTES = 64;
    private static final String AUDIENCE_WEB = "web";
    private final SecretKey secretKey;
    private final long expiration;

    public TokenUtil() {
        String processName = WebSecurityConfig.CONFIG.getProcessName();
        String authTokenPropKey = processName + "." + WebSecurityConfig.CONFIG.getAuthTokenPropSuffix();
        String authTokenSecretProp = System.getProperty(authTokenPropKey);
        if (authTokenSecretProp == null) {
            throw new SecurityException("A JWT secret key was expected to be set via system property '" + authTokenPropKey + "'");
        }
        this.secretKey = TokenUtil.hmacShaKeyFor(authTokenSecretProp);
        String authExprProp = processName + "." + WebSecurityConfig.CONFIG.getAuthExprPropSuffix();
        this.expiration = Long.valueOf(System.getProperty(authExprProp, "1800"));
    }

    public String getUsernameFromToken(String token) {
        return this.getClaimFromToken(token, Claims::getSubject);
    }

    public Date getIssuedAtDateFromToken(String token) {
        return this.getClaimFromToken(token, Claims::getIssuedAt);
    }

    public Date getExpirationDateFromToken(String token) {
        return this.getClaimFromToken(token, Claims::getExpiration);
    }

    public String getAudienceFromToken(String token) {
        return this.getClaimFromToken(token, Claims::getAudience);
    }

    public <T> T getClaimFromToken(String token, Function<Claims, T> claimsResolver) {
        Claims claims = this.getAllClaimsFromToken(token);
        return claimsResolver.apply(claims);
    }

    private Claims getAllClaimsFromToken(String token) {
        return (Claims)Jwts.parser().setSigningKey((Key)this.secretKey).parseClaimsJws(token).getBody();
    }

    private Boolean isTokenExpired(String token) {
        Date expiration = this.getExpirationDateFromToken(token);
        return expiration.before(this.now());
    }

    public String generateToken(UserDetails userDetails) {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        return this.doGenerateToken(claims, userDetails.getUsername(), AUDIENCE_WEB);
    }

    private String doGenerateToken(Map<String, Object> claims, String subject, String audience) {
        Date createdDate = this.now();
        Date expirationDate = this.calculateExpirationDate(createdDate);
        log.info("generateToken " + createdDate);
        return Jwts.builder().setClaims(claims).setSubject(subject).setAudience(audience).setIssuedAt(createdDate).setExpiration(expirationDate).signWith((Key)this.secretKey, SignatureAlgorithm.HS512).compact();
    }

    public Boolean canTokenBeRefreshed(String token) {
        return this.isTokenExpired(token) == false;
    }

    public String refreshToken(String token) {
        Date createdDate = this.now();
        Date expirationDate = this.calculateExpirationDate(createdDate);
        Claims claims = this.getAllClaimsFromToken(token);
        claims.setIssuedAt(createdDate);
        claims.setExpiration(expirationDate);
        return Jwts.builder().setClaims(claims).signWith((Key)this.secretKey, SignatureAlgorithm.HS512).compact();
    }

    public Boolean validateToken(String token, UserDetails userDetails) {
        MapRUser user = (MapRUser)userDetails;
        String username = this.getUsernameFromToken(token);
        return username.equals(user.getUsername()) && this.isTokenExpired(token) == false;
    }

    private Date calculateExpirationDate(Date createdDate) {
        return new Date(createdDate.getTime() + this.expiration * 1000L);
    }

    private Date now() {
        return new Date();
    }

    public static SecretKey hmacShaKeyFor(String authTokenSecret) throws WeakKeyException {
        return TokenUtil.hmacShaKeyFor(authTokenSecret.getBytes(StandardCharsets.UTF_8));
    }

    public static SecretKey hmacShaKeyFor(byte[] authTokenSecretBytes) throws WeakKeyException {
        byte[] signingKeyBytes = authTokenSecretBytes;
        int authTokenSecretBytesLen = authTokenSecretBytes.length;
        if (authTokenSecretBytesLen < 64) {
            signingKeyBytes = new byte[64];
            for (int i = 0; i < signingKeyBytes.length; ++i) {
                signingKeyBytes[i] = authTokenSecretBytes[i % authTokenSecretBytesLen];
            }
        }
        return Keys.hmacShaKeyFor((byte[])signingKeyBytes);
    }
}

