/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.web.security;

import com.mapr.web.security.MapRTicketToken;
import com.mapr.web.security.MapRUser;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.kerberos.authentication.KerberosServiceRequestToken;

public final class SecurityUtils {
    private SecurityUtils() {
    }

    public static String getCurrentUserName() {
        String username = "";
        SecurityContext securityContext = SecurityContextHolder.getContext();
        if (securityContext != null && securityContext.getAuthentication() != null) {
            Authentication authentication = securityContext.getAuthentication();
            if (authentication instanceof KerberosServiceRequestToken) {
                username = authentication.getName().substring(0, authentication.getName().indexOf(64));
            } else if (authentication instanceof UsernamePasswordAuthenticationToken || authentication instanceof MapRTicketToken) {
                Object object = authentication.getPrincipal();
                if (object instanceof MapRUser) {
                    MapRUser user = (MapRUser)authentication.getPrincipal();
                    username = user.getUsername();
                } else {
                    username = object.toString();
                }
            }
        }
        return username;
    }
}

