/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.ojai.DocumentReader;
import org.ojai.Value;
import org.ojai.json.JsonOptions;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

public class Values {
    public static final NullValue NULL = new NullValue();

    private Values() {
    }

    public static class NullValue
    extends BaseValue {
        private NullValue() {
            super(Value.Type.NULL);
        }

        @Override
        public String toString() {
            return "null";
        }

        @Override
        public Object getObject() {
            return null;
        }
    }

    public static class BinaryValue
    extends BaseValue {
        private final ByteBuffer v;

        public BinaryValue(ByteBuffer v) {
            super(Value.Type.BINARY);
            this.v = v;
        }

        @Override
        public ByteBuffer getBinary() {
            return this.v;
        }

        @Override
        public String toString() {
            return this.v.toString();
        }

        @Override
        public Object getObject() {
            return this.v;
        }
    }

    public static class IntervalValue
    extends BaseValue {
        private final OInterval v;

        public IntervalValue(OInterval v) {
            super(Value.Type.INTERVAL);
            this.v = v;
        }

        @Override
        public OInterval getInterval() {
            return this.v;
        }

        @Override
        public String toString() {
            return this.v.toString();
        }

        @Override
        public Object getObject() {
            return this.v;
        }
    }

    public static class TimestampValue
    extends BaseValue {
        private final OTimestamp v;

        public TimestampValue(OTimestamp v) {
            super(Value.Type.TIMESTAMP);
            this.v = v;
        }

        @Override
        public OTimestamp getTimestamp() {
            return this.v;
        }

        @Override
        public String toString() {
            return this.v.toString();
        }

        @Override
        public Object getObject() {
            return this.v;
        }
    }

    public static class TimeValue
    extends BaseValue {
        private final OTime v;

        public TimeValue(OTime v) {
            super(Value.Type.TIME);
            this.v = v;
        }

        @Override
        public OTime getTime() {
            return this.v;
        }

        @Override
        public String toString() {
            return this.v.toString();
        }

        @Override
        public Object getObject() {
            return this.v;
        }
    }

    public static class DateValue
    extends BaseValue {
        private final ODate v;

        public DateValue(ODate v) {
            super(Value.Type.DATE);
            this.v = v;
        }

        @Override
        public ODate getDate() {
            return this.v;
        }

        @Override
        public String toString() {
            return this.v.toString();
        }

        @Override
        public Object getObject() {
            return this.v;
        }
    }

    public static class DecimalValue
    extends BaseValue {
        private final BigDecimal v;

        public DecimalValue(BigDecimal v) {
            super(Value.Type.DECIMAL);
            this.v = v;
        }

        @Override
        public BigDecimal getDecimal() {
            return this.v;
        }

        @Override
        public String toString() {
            return this.v.toString();
        }
    }

    public static class DoubleValue
    extends BaseValue {
        private final double v;

        public DoubleValue(double v) {
            super(Value.Type.DOUBLE);
            this.v = v;
        }

        @Override
        public double getDouble() {
            return this.v;
        }

        @Override
        public String toString() {
            return Double.toString(this.v);
        }

        @Override
        public Object getObject() {
            return this.v;
        }
    }

    public static class FloatValue
    extends BaseValue {
        private final float v;

        public FloatValue(float v) {
            super(Value.Type.FLOAT);
            this.v = v;
        }

        @Override
        public float getFloat() {
            return this.v;
        }

        @Override
        public String toString() {
            return Float.toString(this.v);
        }

        @Override
        public Object getObject() {
            return Float.valueOf(this.v);
        }
    }

    public static class LongValue
    extends BaseValue {
        private final long v;

        public LongValue(long v) {
            super(Value.Type.LONG);
            this.v = v;
        }

        @Override
        public long getLong() {
            return this.v;
        }

        @Override
        public String toString() {
            return Long.toString(this.v);
        }

        @Override
        public Object getObject() {
            return new Long(this.v);
        }
    }

    public static class IntValue
    extends BaseValue {
        private final int v;

        public IntValue(int v) {
            super(Value.Type.INT);
            this.v = v;
        }

        @Override
        public int getInt() {
            return this.v;
        }

        @Override
        public String toString() {
            return Integer.toString(this.v);
        }

        @Override
        public Object getObject() {
            return new Integer(this.v);
        }
    }

    public static class ShortValue
    extends BaseValue {
        private final short v;

        public ShortValue(short v) {
            super(Value.Type.SHORT);
            this.v = v;
        }

        @Override
        public short getShort() {
            return this.v;
        }

        @Override
        public String toString() {
            return Short.toString(this.v);
        }

        @Override
        public Object getObject() {
            return new Short(this.v);
        }
    }

    public static class ByteValue
    extends BaseValue {
        private final byte v;

        public ByteValue(byte v) {
            super(Value.Type.BYTE);
            this.v = v;
        }

        @Override
        public byte getByte() {
            return this.v;
        }

        @Override
        public String toString() {
            return Byte.toString(this.v);
        }

        @Override
        public Object getObject() {
            return new Byte(this.v);
        }
    }

    public static class StringValue
    extends BaseValue {
        private final String v;

        public StringValue(String v) {
            super(Value.Type.STRING);
            this.v = v;
        }

        @Override
        public String getString() {
            return this.v;
        }

        @Override
        public String toString() {
            return this.v;
        }

        @Override
        public Object getObject() {
            return this.v;
        }
    }

    public static class BooleanValue
    extends BaseValue {
        private final boolean v;

        public BooleanValue(boolean v) {
            super(Value.Type.BOOLEAN);
            this.v = v;
        }

        @Override
        public boolean getBoolean() {
            return this.v;
        }

        @Override
        public String toString() {
            return Boolean.toString(this.v);
        }

        @Override
        public Object getObject() {
            return this.v;
        }
    }

    public static class ArrayValue
    extends BaseValue {
        private final List<Object> v;

        public ArrayValue(Object[] v) {
            super(Value.Type.ARRAY);
            this.v = Collections.unmodifiableList(Arrays.asList(v));
        }

        @Override
        public String toString() {
            return this.v.toString();
        }

        @Override
        public Object getObject() {
            return this.v;
        }

        @Override
        public List<Object> getList() {
            return this.v;
        }
    }

    protected static class BaseValue
    implements Value {
        private final Value.Type type;

        protected BaseValue(Value.Type type) {
            this.type = type;
        }

        public String toString() {
            return "Value(type = " + this.type.name() + ")";
        }

        public Value.Type getType() {
            return this.type;
        }

        public String asJsonString() {
            throw new UnsupportedOperationException();
        }

        public String asJsonString(JsonOptions arg0) {
            throw new UnsupportedOperationException();
        }

        public DocumentReader asReader() {
            throw new UnsupportedOperationException();
        }

        public ByteBuffer getBinary() {
            throw new UnsupportedOperationException();
        }

        public boolean getBoolean() {
            throw new UnsupportedOperationException();
        }

        public byte getByte() {
            throw new UnsupportedOperationException();
        }

        public ODate getDate() {
            throw new UnsupportedOperationException();
        }

        public int getDateAsInt() {
            throw new UnsupportedOperationException();
        }

        public BigDecimal getDecimal() {
            throw new UnsupportedOperationException();
        }

        public double getDouble() {
            throw new UnsupportedOperationException();
        }

        public float getFloat() {
            throw new UnsupportedOperationException();
        }

        public int getInt() {
            throw new UnsupportedOperationException();
        }

        public OInterval getInterval() {
            throw new UnsupportedOperationException();
        }

        public long getIntervalAsLong() {
            throw new UnsupportedOperationException();
        }

        public List<Object> getList() {
            throw new UnsupportedOperationException();
        }

        public long getLong() {
            throw new UnsupportedOperationException();
        }

        public Map<String, Object> getMap() {
            throw new UnsupportedOperationException();
        }

        public Object getObject() {
            throw new UnsupportedOperationException();
        }

        public short getShort() {
            throw new UnsupportedOperationException();
        }

        public String getString() {
            throw new UnsupportedOperationException();
        }

        public OTime getTime() {
            throw new UnsupportedOperationException();
        }

        public int getTimeAsInt() {
            throw new UnsupportedOperationException();
        }

        public OTimestamp getTimestamp() {
            throw new UnsupportedOperationException();
        }

        public long getTimestampAsLong() {
            throw new UnsupportedOperationException();
        }
    }
}

