/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mapr.db.JsonTable;
import com.mapr.db.MapRDB;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.ojai.store.impl.DrillDocumentStream;
import com.mapr.ojai.store.impl.OjaiConnection;
import com.mapr.ojai.store.impl.OjaiQuery;
import com.mapr.ojai.store.impl.OjaiTest;
import com.mapr.ojai.store.impl.PathCollector;
import com.mapr.ojai.store.impl.QueryContext;
import com.mapr.ojai.store.impl.SharedTestTable;
import com.mapr.ojai.store.impl.SharedTestTableLoader;
import com.mapr.ojai.store.impl.StringGenerator;
import com.mapr.ojai.store.impl.Values;
import com.mapr.tests.annotations.ClusterTest;
import com.mapr.utils.ImmutableArray;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.Value;
import org.ojai.store.Connection;
import org.ojai.store.DocumentStore;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;
import org.ojai.store.QueryResult;
import org.ojai.store.SortOrder;
import org.ojai.types.ODate;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

@Category(value={ClusterTest.class})
public class TestOjaiSelect
extends OjaiTest {
    private static final SharedTestTable sharedTableElementAndArrayCond = new SharedTestTableLoader("testElementAndArrayCond");
    private static final SharedTableMaprdb1225 sharedTableMaprdb1225 = new SharedTableMaprdb1225();
    private static final SharedTableMaprdb972 sharedTableMaprdb972 = new SharedTableMaprdb972();
    private static final SharedTableMaprdb1098 sharedTableMaprdb1098 = new SharedTableMaprdb1098();
    private static final SharedTableMaprdb1119 sharedTableMaprdb1119 = new SharedTableMaprdb1119();
    private static final SharedTableMaprdb1369 sharedTableMaprdb1369 = new SharedTableMaprdb1369();
    private static final SharedTableMaprdb1347 sharedTableMaprdb1347 = new SharedTableMaprdb1347();

    private static String arrayToString(Object ... objects) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        boolean needComma = false;
        for (Object object : objects) {
            if (needComma) {
                sb.append(", ");
            }
            sb.append(object.toString());
            needComma = true;
        }
        sb.append(']');
        return sb.toString();
    }

    private void simpleSelectCheck(DocumentStore docStore, Query query, String ... projectedFields) {
        PathCollector pathCollector = new PathCollector();
        try (QueryResult docStream = docStore.find(query);){
            for (Document doc : docStream) {
                pathCollector.collect(doc.asReader());
            }
        }
        List<String> extraPaths = pathCollector.getExtraPaths(projectedFields);
        Assert.assertTrue((String)("fields " + TestOjaiSelect.arrayToString(projectedFields) + " extraPaths " + extraPaths), (boolean)extraPaths.isEmpty());
    }

    @Test
    public void testQuery_maprdb1046() {
        try (OjaiConnection connection = TestOjaiSelect.getConnection();){
            String tableName = sharedTableElementAndArrayCond.prepare((Connection)connection);
            String projectField = "a[].b";
            Query queryUnbuilt = connection.newQuery().select(new String[]{"a[].b"});
            OjaiQuery queryDirect = new OjaiQuery(queryUnbuilt).setOption("ojai.mapr.query.force-direct", (Object)true).build();
            OjaiQuery queryDrill = new OjaiQuery(queryUnbuilt).setOption("ojai.mapr.query.force-drill", (Object)true).build();
            try (DocumentStore docStore = connection.getStore(tableName);){
                this.simpleSelectCheck(docStore, (Query)queryDirect, "a[].b");
            }
        }
    }

    @Test
    public void testQuery_maprdb1082() {
        try (OjaiConnection connection = TestOjaiSelect.getConnection();){
            String tableName = sharedTableElementAndArrayCond.prepare((Connection)connection);
            Query query = connection.newQuery().select(new String[]{"_id", "s"}).where(connection.newCondition().and().in("i", (List)ImmutableList.of()).is("s", QueryCondition.Op.EQUAL, "three").close().build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);){
                int count = 0;
                try (QueryResult docStream = docStore.find(query);){
                    for (Document doc : docStream) {
                        String id = doc.getIdString();
                        Assert.assertNotNull((Object)id);
                        ++count;
                    }
                }
                Assert.assertEquals((long)0L, (long)count);
            }
        }
    }

    private static void maprdb1117_query(DocumentStore docStore, Query query, int numRows, String rawTableName) {
        try (QueryResult docStream = docStore.find(query);){
            int count = 0;
            for (Document doc : docStream) {
                String id = doc.getIdString();
                Assert.assertNotNull((Object)id);
                int z = doc.getInt("x.y.z");
                Assert.assertEquals((long)Integer.parseInt(id), (long)z);
                ++count;
            }
            Assert.assertEquals((long)numRows, (long)count);
            Assert.assertEquals((Object)rawTableName, (Object)OjaiTest.getIndexUsed((DocumentStream)docStream));
        }
    }

    @Test
    public void testQuery_maprdb1117() throws Exception {
        String rawTableName = "maprdb1117";
        int numRows = 30;
        try (OjaiConnection connection = TestOjaiSelect.getConnection();
             JsonTable table = DBTests.createOrGetTable((String)"maprdb1117");){
            Path tablePath = table.getPath();
            String abxyzIndexName = "maprdb1117_ab_xyz_idx";
            DBTests.createIndex((JsonTable)table, (String)"maprdb1117_ab_xyz_idx", (boolean)false, (int)0, (String[])new String[]{"a.b", "x.y.z"}, null, (String[])new String[]{"a.b", "x.y.z"});
            String xyzIndexName = "maprdb1117_xyz_idx";
            DBTests.createIndex((JsonTable)table, (String)"maprdb1117_xyz_idx", (boolean)false, (int)0, (String[])new String[]{"x.y.z"}, null, (String[])new String[]{"x.y.z"});
            Random random = new Random(1117L);
            StringGenerator sGenerator = new StringGenerator(64, random);
            for (int i = 0; i < 30; ++i) {
                Document doc = connection.newDocument();
                doc.setId(Integer.toString(i));
                HashMap<String, Object> yMap = new HashMap<String, Object>();
                yMap.put("s", sGenerator.nextString());
                yMap.put("z", i);
                HashMap<String, HashMap<String, Object>> xMap = new HashMap<String, HashMap<String, Object>>();
                xMap.put("y", yMap);
                doc.set("x", xMap);
                table.insert(doc);
            }
            table.flush();
            DBTests.waitForIndexFlush((String)"maprdb1117");
            DBTests.waitForRowCount((String)"maprdb1117", (long)1L);
            Query unbuiltQuery = connection.newQuery().select(new String[]{"x.y"});
            OjaiQuery queryXYZIndex = new OjaiQuery((Query)((OjaiQuery)unbuiltQuery)).setOption("ojai.mapr.query.hint-using-index", (Object)"maprdb1117_xyz_idx").build();
            OjaiQuery queryABXYZIndex = new OjaiQuery((Query)((OjaiQuery)unbuiltQuery)).setOption("ojai.mapr.query.hint-using-index", (Object)"maprdb1117_ab_xyz_idx").build();
            try (DocumentStore docStore = connection.getStore(tablePath.toString());){
                TestOjaiSelect.maprdb1117_query(docStore, unbuiltQuery.build(), 30, "maprdb1117");
                TestOjaiSelect.maprdb1117_query(docStore, (Query)queryXYZIndex, 30, "maprdb1117");
                TestOjaiSelect.maprdb1117_query(docStore, (Query)queryABXYZIndex, 30, "maprdb1117");
            }
        }
    }

    @Test
    public void testQuery_maprdb1225() {
        try (OjaiConnection connection = TestOjaiSelect.getConnection();){
            String tableName = sharedTableMaprdb1225.prepare((Connection)connection);
            String indexName = sharedTableMaprdb1225.getIndexName();
            Query query = connection.newQuery().select(new String[]{"a", "_id", "x"}).where(connection.newCondition().and().elementAnd("a[]").is("b", QueryCondition.Op.EQUAL, 17).is("c", QueryCondition.Op.EQUAL, 42).close().elementAnd("x[]").is("y", QueryCondition.Op.EQUAL, 5).is("z", QueryCondition.Op.EQUAL, 15).close().close().build());
            ImmutableSet idList = ImmutableSet.of((Object)"002");
            try (DocumentStore docStore = connection.getStore(tableName);){
                TestOjaiSelect.simpleQueryCheck(docStore, query, (Set<String>)idList, indexName);
            }
        }
    }

    @Test
    public void testQuery_maprdb1140() {
        try (OjaiConnection connection = TestOjaiSelect.getConnection();){
            String tableName = sharedTableElementAndArrayCond.prepare((Connection)connection);
            Query query = connection.newQuery().select(new String[]{"_id"}).where(connection.newCondition().is("_id", QueryCondition.Op.EQUAL, "002").build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);){
                this.simpleSelectCheck(docStore, query, "_id");
            }
        }
    }

    @Test
    public void testQuery_maprdb1140_2() {
        try (OjaiConnection connection = TestOjaiSelect.getConnection();){
            String tableName = sharedTableElementAndArrayCond.prepare((Connection)connection);
            String docId = "002";
            QueryCondition queryCondition = connection.newCondition().is("_id", QueryCondition.Op.EQUAL, "002").build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.find(queryCondition, new String[]{"_id"});){
                int count = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertEquals((Object)id, (Object)"002");
                    ++count;
                }
                Assert.assertEquals((long)1L, (long)count);
            }
        }
    }

    @Test
    public void testQuery_maprdb1140_3() throws Exception {
        String tableName = "maprdb1140_3";
        String docId = "document1";
        try (OjaiConnection connection = TestOjaiSelect.getConnection();
             JsonTable table = DBTests.createOrGetTable((String)"maprdb1140_3");){
            Path tablePath = table.getPath();
            Document theDoc = connection.newDocument();
            theDoc.set("name", "anisha");
            table.insertOrReplace("document1", theDoc);
            table.flush();
            QueryCondition queryCondition = connection.newCondition().is("_id", QueryCondition.Op.EQUAL, "document1").build();
            try (DocumentStore docStore = connection.getStore(table.getPath().toString());
                 DocumentStream docStream = docStore.find(queryCondition, new String[]{"_id"});){
                int count = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertEquals((Object)id, (Object)"document1");
                    ++count;
                }
                Assert.assertEquals((long)1L, (long)count);
            }
        }
    }

    @Test
    public void testQuery_maprdb972_exists() {
        try (OjaiConnection connection = TestOjaiSelect.getConnection();){
            String tableName = sharedTableMaprdb972.prepare((Connection)connection);
            String indexName = sharedTableMaprdb972.getExistsIndexName();
            Query unbuiltQuery = connection.newQuery().select(new String[]{"f_exists", "_id"}).where(connection.newCondition().exists("f_exists").build());
            ImmutableSet<String> ids = sharedTableMaprdb972.getExistsIds();
            try (DocumentStore docStore = connection.getStore(tableName);){
                TestOjaiSelect.simpleQueryCheck(docStore, unbuiltQuery, ids, indexName);
            }
        }
    }

    @Test
    public void testQuery_maprdb972_matches() {
        try (OjaiConnection connection = TestOjaiSelect.getConnection();){
            String tableName = sharedTableMaprdb972.prepare((Connection)connection);
            String indexName = sharedTableMaprdb972.getMatchesIndexName();
            String matchesRegex = sharedTableMaprdb972.getMatchesRegex();
            Query unbuiltQuery = connection.newQuery().select(new String[]{"f_matches", "_id"}).where(connection.newCondition().matches("f_matches", matchesRegex).build());
            ImmutableSet<String> ids = sharedTableMaprdb972.getMatchesIds();
            try (DocumentStore docStore = connection.getStore(tableName);){
                TestOjaiSelect.simpleQueryCheck(docStore, unbuiltQuery, ids, indexName);
            }
        }
    }

    @Test
    public void testQuery_maprdb972_typeOf() {
        try (OjaiConnection connection = TestOjaiSelect.getConnection();){
            String tableName = sharedTableMaprdb972.prepare((Connection)connection);
            String rawTableName = sharedTableMaprdb972.getRawTableName();
            String indexName = sharedTableMaprdb972.getTypeOfIndexName();
            long rowCount = sharedTableMaprdb972.getNumRows();
            Query unbuiltQuery = connection.newQuery().select(new String[]{"f_typeOf", "_id"});
            OjaiQuery queryArray = new OjaiQuery((Query)((OjaiQuery)unbuiltQuery)).where(connection.newCondition().typeOf("f_typeOf", Value.Type.ARRAY).build());
            OjaiQuery queryDate = new OjaiQuery((Query)((OjaiQuery)unbuiltQuery)).where(connection.newCondition().typeOf("f_typeOf", Value.Type.DATE).build());
            OjaiQuery queryShort = new OjaiQuery((Query)((OjaiQuery)unbuiltQuery)).where(connection.newCondition().typeOf("f_typeOf", Value.Type.SHORT).build());
            OjaiQuery queryNull = new OjaiQuery((Query)((OjaiQuery)unbuiltQuery)).where(connection.newCondition().typeOf("f_typeOf", Value.Type.NULL).build());
            OjaiQuery queryString = new OjaiQuery((Query)((OjaiQuery)unbuiltQuery)).where(connection.newCondition().typeOf("f_typeOf", Value.Type.STRING).build());
            OjaiQuery queryNotDate = new OjaiQuery((Query)((OjaiQuery)unbuiltQuery)).setOption("ojai.mapr.query.hint-using-index", (Object)rawTableName).where(connection.newCondition().notTypeOf("f_typeOf", Value.Type.DATE).build()).build();
            OjaiQuery queryNotDateIdx = new OjaiQuery((Query)((OjaiQuery)unbuiltQuery)).setOption("ojai.mapr.query.hint-using-index", (Object)indexName).where(connection.newCondition().notTypeOf("f_typeOf", Value.Type.DATE).build()).build();
            ImmutableSet<String> idsArray = sharedTableMaprdb972.getTypeOfArrayIds();
            ImmutableSet<String> idsDate = sharedTableMaprdb972.getTypeOfDateIds();
            ImmutableSet<String> idsShort = sharedTableMaprdb972.getTypeOfShortIds();
            ImmutableSet<String> idsNull = sharedTableMaprdb972.getTypeOfNullIds();
            ImmutableSet<String> idsString = sharedTableMaprdb972.getTypeOfStringIds();
            try (DocumentStore docStore = connection.getStore(tableName);){
                String id;
                int count;
                TestOjaiSelect.simpleQueryCheck(docStore, (Query)queryArray, idsArray, rawTableName);
                TestOjaiSelect.simpleQueryCheck(docStore, (Query)queryArray, idsArray, indexName);
                TestOjaiSelect.simpleQueryCheck(docStore, (Query)queryDate, idsDate, rawTableName);
                TestOjaiSelect.simpleQueryCheck(docStore, (Query)queryDate, idsDate, indexName);
                TestOjaiSelect.simpleQueryCheck(docStore, (Query)queryShort, idsShort, rawTableName);
                TestOjaiSelect.simpleQueryCheck(docStore, (Query)queryShort, idsShort, indexName);
                TestOjaiSelect.simpleQueryCheck(docStore, (Query)queryNull, idsNull, rawTableName);
                TestOjaiSelect.simpleQueryCheck(docStore, (Query)queryNull, idsNull, indexName);
                TestOjaiSelect.simpleQueryCheck(docStore, (Query)queryString, idsString, rawTableName);
                TestOjaiSelect.simpleQueryCheck(docStore, (Query)queryString, idsString, indexName);
                try (QueryResult docStream = docStore.find((Query)queryNotDate);){
                    count = 0;
                    for (Document doc : docStream) {
                        id = doc.getIdString();
                        Assert.assertNotNull((Object)id);
                        Assert.assertFalse((String)("idsDate contained " + id), (boolean)idsDate.contains((Object)id));
                        ++count;
                    }
                    Assert.assertEquals((long)(rowCount - (long)idsDate.size()), (long)count);
                    Assert.assertEquals((Object)rawTableName, (Object)TestOjaiSelect.getIndexUsed((DocumentStream)docStream));
                }
                docStream = docStore.find((Query)queryNotDateIdx);
                try {
                    count = 0;
                    for (Document doc : docStream) {
                        id = doc.getIdString();
                        Assert.assertNotNull((Object)id);
                        Assert.assertFalse((String)("idsDate contained " + id), (boolean)idsDate.contains((Object)id));
                        ++count;
                    }
                    Assert.assertEquals((long)(rowCount - (long)idsDate.size()), (long)count);
                    Assert.assertEquals((Object)indexName, (Object)TestOjaiSelect.getIndexUsed((DocumentStream)docStream));
                }
                finally {
                    if (docStream != null) {
                        docStream.close();
                    }
                }
            }
        }
    }

    @Test
    public void testQuery_maprdb972_sizeOf() {
        try (OjaiConnection connection = TestOjaiSelect.getConnection();){
            String tableName = sharedTableMaprdb972.prepare((Connection)connection);
            String rawTableName = sharedTableMaprdb972.getRawTableName();
            String indexName = sharedTableMaprdb972.getStringIndexName();
            Query unbuiltQuery = connection.newQuery().select(new String[]{"s", "_id"}).where(connection.newCondition().sizeOf("s", QueryCondition.Op.GREATER, (long)sharedTableMaprdb972.getLongerStringLength()).build());
            ImmutableSet<String> idsString = sharedTableMaprdb972.getLongerStringIds();
            try (DocumentStore docStore = connection.getStore(tableName);){
                TestOjaiSelect.simpleQueryCheck(docStore, unbuiltQuery, idsString, rawTableName);
            }
        }
    }

    @Test
    public void testQuery_maprdb1098() {
        try (OjaiConnection connection = TestOjaiSelect.getConnection();){
            String tableName = sharedTableMaprdb1098.prepare((Connection)connection);
            String indexName = sharedTableMaprdb1098.getIndexName();
            Query query = connection.newQuery().setOption("ojai.mapr.query.hint-using-index", (Object)indexName).select(new String[]{"i"}).where(connection.newCondition().or().in("i", (List)ImmutableList.of((Object)42, (Object)17)).is("i", QueryCondition.Op.GREATER, 98).close().build()).build();
            ImmutableList ids = ImmutableList.of((Object)"17", (Object)"42", (Object)"99");
            HashSet<String> idsSeen = new HashSet<String>();
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery(query);){
                int count = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertTrue((String)("unexpected id " + id), (boolean)ids.contains((Object)id));
                    idsSeen.add(id);
                    int i = doc.getInt("i");
                    Assert.assertEquals((Object)id, (Object)Integer.toString(i));
                    ++count;
                }
                Assert.assertEquals((String)("missing ids " + new HashSet(ids).removeAll(idsSeen)), (long)ids.size(), (long)count);
                Assert.assertEquals((Object)indexName, (Object)TestOjaiSelect.getIndexUsed(docStream));
            }
        }
    }

    @Test
    public void testQuery_maprdb1119() {
        try (OjaiConnection connection = TestOjaiSelect.getConnection();){
            String tableName = sharedTableMaprdb1119.prepare((Connection)connection);
            Query query = connection.newQuery().setOption("ojai.mapr.query.hint-using-index", (Object)sharedTableMaprdb1119.getIndexName()).select(new String[]{"x.y[].z"}).where(connection.newCondition().is("x.y[].z", QueryCondition.Op.NOT_EQUAL, "valueAtZ:2").build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery(query);){
                int count = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertNotNull((Object)id);
                    ++count;
                }
                Assert.assertEquals((long)sharedTableMaprdb1119.getNumRows(), (long)count);
            }
        }
    }

    @Ignore(value="MAPRDB-1369")
    @Test
    public void testQuery_maprdb1369() throws Exception {
        ImmutableSet idList = ImmutableSet.of((Object)"001", (Object)"002");
        try (OjaiConnection connection = TestOjaiSelect.getConnection();){
            String tableName = sharedTableMaprdb1369.prepare((Connection)connection);
            String indexName = sharedTableMaprdb1369.getIndexName();
            String binaryString = "TVFPTlFRUU5RUE9RTk1RTw==";
            ByteBuffer binaryMapKey = ByteBuffer.wrap("TVFPTlFRUU5RUE9RTk1RTw==".getBytes());
            Query queryUnbuilt = connection.newQuery().setOption("ojai.mapr.query.hint-using-index", (Object)indexName).limit(150L).select(new String[]{"l0_a0_mapList[].sl1_a0_mapList[].l0_a0_dateMapKey", "l0_a0_mapList[].sl1_a0_mapList[].l0_a0_binaryMapKey"}).where(connection.newCondition().elementAnd("l0_a0_mapList[].sl1_a0_mapList[]").is("l0_a0_dateMapKey", QueryCondition.Op.EQUAL, new ODate(1969, 12, 20)).is("l0_a0_binaryMapKey", QueryCondition.Op.EQUAL, binaryMapKey).close().build());
            OjaiQuery queryDirect = new OjaiQuery(queryUnbuilt).setOption("ojai.mapr.query.force-direct", (Object)true);
            OjaiQuery queryDrill = new OjaiQuery(queryUnbuilt).setOption("ojai.mapr.query.force-drill", (Object)true);
            try (DocumentStore docStore = connection.getStore(tableName);){
                TestOjaiSelect.simpleQueryCheck(docStore, (Query)queryDirect, (Set<String>)idList, indexName);
                TestOjaiSelect.simpleQueryCheck(docStore, (Query)queryDrill, (Set<String>)idList, indexName);
            }
        }
    }

    @Test
    public void testQuery_maprdb1198_parseComplex() {
        ImmutableList stringList = new ImmutableList.Builder().add((Object)"foo").add((Object)"bar").add((Object)"baz").build();
        ImmutableMap innerMap = new ImmutableMap.Builder().put((Object)"n", (Object)17).put((Object)"q", (Object)stringList).put((Object)"d", (Object)new ODate(2018, 6, 22)).build();
        ImmutableMap map = new ImmutableMap.Builder().put((Object)"x", (Object)"xxx").put((Object)"y", (Object)innerMap).put((Object)"z", (Object)42).build();
        try (OjaiConnection connection = TestOjaiSelect.getConnection();){
            String tableName = sharedTableMaprdb1119.prepare((Connection)connection);
            Query query = connection.newQuery().setOption("ojai.mapr.query.force-drill", (Object)true).where(connection.newCondition().equals("some_field", (Map)map).build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery(query);){
                int count = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertNotNull((Object)id);
                    ++count;
                }
                Assert.assertEquals((long)0L, (long)count);
            }
        }
    }

    @Test
    public void testQuery_maprdb1198_list() {
        ImmutableList cList = ImmutableList.of((Object)42, (Object)72, (Object)2);
        ImmutableSet idList = ImmutableSet.of((Object)"002");
        try (OjaiConnection connection = TestOjaiSelect.getConnection();){
            String tableName = sharedTableElementAndArrayCond.prepare((Connection)connection);
            Query unbuiltQuery = connection.newQuery().where(connection.newCondition().equals("a[].c", (List)cList).build());
            OjaiQuery directQuery = new OjaiQuery((Query)((OjaiQuery)unbuiltQuery)).setOption("ojai.mapr.query.force-drill", (Object)false);
            OjaiQuery drillQuery = new OjaiQuery((Query)((OjaiQuery)unbuiltQuery)).setOption("ojai.mapr.query.force-drill", (Object)true);
            try (DocumentStore docStore = connection.getStore(tableName);){
                TestOjaiSelect.simpleQueryCheck(docStore, (Query)directQuery, (Set<String>)idList, null);
                TestOjaiSelect.simpleQueryCheck(docStore, (Query)drillQuery, (Set<String>)idList, null);
            }
        }
    }

    @Test
    public void testQuery_maprdb1198_map() {
        ImmutableList cList = ImmutableList.of((Object)7, (Object)12, (Object)8);
        ImmutableMap aMap = ImmutableMap.of((Object)"b", (Object)1, (Object)"c", (Object)cList);
        ImmutableSet idList = ImmutableSet.of((Object)"004");
        try (OjaiConnection connection = TestOjaiSelect.getConnection();){
            String tableName = sharedTableElementAndArrayCond.prepare((Connection)connection);
            Query unbuiltQuery = connection.newQuery().where(connection.newCondition().equals("a[]", (Map)aMap).build());
            OjaiQuery directQuery = new OjaiQuery((Query)((OjaiQuery)unbuiltQuery)).setOption("ojai.mapr.query.force-drill", (Object)false);
            OjaiQuery drillQuery = new OjaiQuery((Query)((OjaiQuery)unbuiltQuery)).setOption("ojai.mapr.query.force-drill", (Object)true);
            try (DocumentStore docStore = connection.getStore(tableName);){
                TestOjaiSelect.simpleQueryCheck(docStore, (Query)directQuery, (Set<String>)idList, null);
                TestOjaiSelect.simpleQueryCheck(docStore, (Query)drillQuery, (Set<String>)idList, null);
            }
        }
    }

    @Test
    public void testQuery_maprdb1347() {
        ImmutableSet idList = ImmutableSet.of((Object)"user002", (Object)"user005", (Object)"user007", (Object)"user010");
        try (OjaiConnection connection = TestOjaiSelect.getConnection();){
            String tableName = sharedTableMaprdb1347.prepare((Connection)connection);
            String indexName = sharedTableMaprdb1347.getIndexName();
            Query unbuiltQuery = connection.newQuery().where(connection.newCondition().elementAnd("orders[].products[]").is("price", QueryCondition.Op.GREATER, 900).matches("prodname", "^.*\\Qlaptop\\E.*$").close().build());
            OjaiQuery directQuery = new OjaiQuery((Query)((OjaiQuery)unbuiltQuery)).setOption("ojai.mapr.query.force-drill", (Object)false);
            OjaiQuery drillQuery = new OjaiQuery((Query)((OjaiQuery)unbuiltQuery)).setOption("ojai.mapr.query.force-drill", (Object)true);
            try (DocumentStore docStore = connection.getStore(tableName);){
                TestOjaiSelect.simpleQueryCheck(docStore, (Query)directQuery, (Set<String>)idList, indexName);
                TestOjaiSelect.simpleQueryCheck(docStore, (Query)drillQuery, (Set<String>)idList, indexName);
            }
        }
    }

    private static void runRawSql(Connection connection, String sqlStr, String tableName, Set<String> idList) {
        QueryContext queryContext = QueryContext.newBuilder((String)sqlStr).build();
        try (DrillDocumentStream ods = new DrillDocumentStream((OjaiConnection)connection, queryContext);){
            int count = 0;
            for (Document doc : ods) {
                String id = doc.getIdString();
                Assert.assertNotNull((Object)id);
                if (idList != null) {
                    Assert.assertTrue((boolean)idList.contains(id));
                }
                ++count;
            }
            if (idList != null) {
                Assert.assertEquals((long)idList.size(), (long)count);
            }
        }
    }

    @Test
    public void testQuery_maprdb1331() {
        String sqlStrFmt = "select _id from dfs.`%1$s` where _id in (select _id from ( select _id, flatten(t1.weight) as f1 from dfs.`%1$s` as t1 ) as t where t.f1.low in (120,150,170) and t.f1.high in (170,180,190))";
        Set<String> idList = null;
        try (OjaiConnection connection = TestOjaiSelect.getConnection();){
            String tableName = sharedTableMaprdb1347.prepare((Connection)connection);
            String sqlStr = String.format("select _id from dfs.`%1$s` where _id in (select _id from ( select _id, flatten(t1.weight) as f1 from dfs.`%1$s` as t1 ) as t where t.f1.low in (120,150,170) and t.f1.high in (170,180,190))", tableName);
            TestOjaiSelect.runRawSql((Connection)connection, sqlStr, tableName, idList);
        }
    }

    @Test
    public void testQuery_maprdb1384() {
        String sqlStrFmt = "select _id from dfs.`%1$s` where _id in (select _id from (select _id, flatten(t1.`f1`.`products`) as f3, flatten(t1.`f2`.`products`) as f4 from (select _id, flatten(orders) as f1, flatten(orders) as f2 from dfs.`%1$s`) as t1) as t2 where t2.`f3`.`price` > 50 and t2.`f3`.prodname='bike')";
        Set<String> idList = null;
        try (OjaiConnection connection = TestOjaiSelect.getConnection();){
            String tableName = sharedTableMaprdb1347.prepare((Connection)connection);
            String sqlStr = String.format("select _id from dfs.`%1$s` where _id in (select _id from (select _id, flatten(t1.`f1`.`products`) as f3, flatten(t1.`f2`.`products`) as f4 from (select _id, flatten(orders) as f1, flatten(orders) as f2 from dfs.`%1$s`) as t1) as t2 where t2.`f3`.`price` > 50 and t2.`f3`.prodname='bike')", tableName);
            TestOjaiSelect.runRawSql((Connection)connection, sqlStr, tableName, idList);
        }
    }

    @Test
    public void testQuery_maprdb1322() throws Exception {
        String rawTableName = "maprdb1322";
        int numRows = 47;
        int strLength = 11;
        try (OjaiConnection connection = TestOjaiSelect.getConnection();
             JsonTable table = DBTests.createOrGetTable((String)"maprdb1322");){
            Path tablePath = table.getPath();
            Random random = new Random(1322L);
            StringGenerator sGenerator = new StringGenerator(64, random);
            ImmutableSet.Builder idListBuilder = ImmutableSet.builder();
            for (int rowIdx = 0; rowIdx < 47; ++rowIdx) {
                Document doc = connection.newDocument();
                String docId = Integer.toString(rowIdx);
                doc.setId(docId);
                LinkedList aList = new LinkedList();
                int nMaps = random.nextInt(8);
                for (int mapIdx = 0; mapIdx < nMaps; ++mapIdx) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("s", sGenerator.nextString(11));
                    int typeSelector = random.nextInt(3);
                    switch (typeSelector) {
                        case 0: {
                            map.put("v", random.nextInt());
                            idListBuilder.add((Object)docId);
                            break;
                        }
                        case 1: {
                            map.put("v", random.nextBoolean());
                            break;
                        }
                        case 2: {
                            map.put("v", sGenerator.nextString());
                            break;
                        }
                        default: {
                            throw new IllegalStateException("no case for typeSelector == " + typeSelector);
                        }
                    }
                    aList.add(map);
                }
                doc.set("a", aList);
                table.insert(doc);
            }
            table.flush();
            DBTests.waitForIndexFlush((String)"maprdb1322");
            DBTests.waitForRowCount((String)"maprdb1322", (long)47L);
            ImmutableSet idList = idListBuilder.build();
            Assert.assertTrue((String)"not a great test with empty idList", (idList.size() > 0 ? 1 : 0) != 0);
            Query unbuiltQuery = connection.newQuery().where(connection.newCondition().elementAnd("a[]").sizeOf("s", QueryCondition.Op.EQUAL, 11L).typeOf("v", Value.Type.INT).close().build());
            OjaiQuery directQuery = new OjaiQuery((Query)((OjaiQuery)unbuiltQuery)).setOption("ojai.mapr.query.force-direct", (Object)true);
            OjaiQuery drillQuery = new OjaiQuery((Query)((OjaiQuery)unbuiltQuery)).setOption("ojai.mapr.query.force-drill", (Object)true);
            try (DocumentStore docStore = connection.getStore(tablePath.toString());){
                TestOjaiSelect.simpleQueryCheck(docStore, (Query)directQuery, (Set<String>)idList, null);
            }
        }
    }

    private static class SharedTableMaprdb1225
    extends SharedTestTableLoader {
        private String indexName;

        public SharedTableMaprdb1225() {
            super("testMaprdb1225");
        }

        public String getIndexName() {
            return this.indexName;
        }

        @Override
        protected String initialize(Connection connection, String trialRawTableName) throws Exception {
            String tableName = super.initialize(connection, trialRawTableName);
            this.indexName = trialRawTableName + "_b_c_idx";
            try (JsonTable table = DBTests.getTable((String)DBTests.getNameWithoutPath((String)tableName));){
                DBTests.createIndex((JsonTable)table, (String)this.indexName, (boolean)false, (int)0, (String[])new String[]{"a[].b", "a[].c"}, null, (String[])new String[]{"x"});
                String string = tableName;
                return string;
            }
        }
    }

    private static class SharedTableMaprdb972
    extends SharedTestTable {
        private String existsIndexName;
        private ImmutableSet<String> existsIds;
        private static final String matchesRegex = ".xyzabc.";
        private String matchesIndexName;
        private ImmutableSet<String> matchesIds;
        private String typeOfIndexName;
        private ImmutableSet<String> typeOfArrayIds;
        private ImmutableSet<String> typeOfDateIds;
        private ImmutableSet<String> typeOfNullIds;
        private ImmutableSet<String> typeOfShortIds;
        private ImmutableSet<String> typeOfStringIds;
        private static final ImmutableMap<Value.Type, ValueFactory> VALUE_FACTORY;
        private static final ImmutableArray<Value.Type> TYPES;
        private static final int LONGER_STRING_LENGTH = 7;
        private ImmutableSet<String> longerStringIds;
        private String stringIndexName;
        private static final int numRows = 687;

        public String getExistsIndexName() {
            return this.existsIndexName;
        }

        public ImmutableSet<String> getExistsIds() {
            return this.existsIds;
        }

        public String getMatchesRegex() {
            return matchesRegex;
        }

        public String getMatchesIndexName() {
            return this.matchesIndexName;
        }

        public ImmutableSet<String> getMatchesIds() {
            return this.matchesIds;
        }

        public String getTypeOfIndexName() {
            return this.typeOfIndexName;
        }

        public ImmutableSet<String> getTypeOfArrayIds() {
            return this.typeOfArrayIds;
        }

        public ImmutableSet<String> getTypeOfDateIds() {
            return this.typeOfDateIds;
        }

        public ImmutableSet<String> getTypeOfNullIds() {
            return this.typeOfNullIds;
        }

        public ImmutableSet<String> getTypeOfShortIds() {
            return this.typeOfShortIds;
        }

        public ImmutableSet<String> getTypeOfStringIds() {
            return this.typeOfStringIds;
        }

        public int getLongerStringLength() {
            return 7;
        }

        public ImmutableSet<String> getLongerStringIds() {
            return this.longerStringIds;
        }

        public String getStringIndexName() {
            return this.stringIndexName;
        }

        SharedTableMaprdb972() {
            super("maprdb972");
        }

        @Override
        protected String initialize(Connection connection, String rawTableName) throws Exception {
            try (JsonTable table = DBTests.createOrGetTable((String)rawTableName);){
                Path tablePath = table.getPath();
                String tableName = tablePath.toString();
                this.existsIndexName = rawTableName + "_exists_idx";
                DBTests.createIndex((JsonTable)table, (String)this.existsIndexName, (boolean)false, (int)0, (String[])new String[]{"f_exists"}, null, null);
                this.matchesIndexName = rawTableName + "_matches_idx";
                DBTests.createIndex((JsonTable)table, (String)this.matchesIndexName, (boolean)false, (int)0, (String[])new String[]{"f_matches"}, null, null);
                this.typeOfIndexName = rawTableName + "_typeOf_idx";
                DBTests.createIndex((JsonTable)table, (String)this.typeOfIndexName, (boolean)false, (int)0, (String[])new String[]{"f_typeOf"}, null, null);
                this.stringIndexName = rawTableName + "_s_idx";
                DBTests.createIndex((JsonTable)table, (String)this.stringIndexName, (boolean)false, (int)0, (String[])new String[]{"s"}, null, null);
                Random random = new Random(972L);
                StringGenerator sGenerator = new StringGenerator(32, random);
                Primes primes = new Primes();
                int primeIdx = 0;
                int existsPrime = primes.get(primeIdx++);
                ImmutableSet.Builder existsIdsBuilder = ImmutableSet.builder();
                int matchesPrime = primes.get(primeIdx++);
                ImmutableSet.Builder matchesIdsBuilder = ImmutableSet.builder();
                Pattern matchesPattern = Pattern.compile(matchesRegex);
                ImmutableSet.Builder typeOfArrayIdsBuilder = ImmutableSet.builder();
                ImmutableSet.Builder typeOfDateIdsBuilder = ImmutableSet.builder();
                ImmutableSet.Builder typeOfNullIdsBuilder = ImmutableSet.builder();
                ImmutableSet.Builder typeOfShortIdsBuilder = ImmutableSet.builder();
                ImmutableSet.Builder typeOfStringIdsBuilder = ImmutableSet.builder();
                ImmutableSet.Builder longerStringIdsBuilder = ImmutableSet.builder();
                for (int i = 0; i < 687; ++i) {
                    Matcher matcher;
                    Document doc = MapRDB.newDocument();
                    String id = Integer.toString(i);
                    doc.set("_id", id);
                    String s = sGenerator.nextString();
                    if (s.length() > 7) {
                        longerStringIdsBuilder.add((Object)id);
                    }
                    doc.set("s", s);
                    if (i % existsPrime == 0) {
                        doc.set("f_exists", i);
                        existsIdsBuilder.add((Object)id);
                    }
                    Object fMatches = sGenerator.nextString();
                    if (i % matchesPrime == 0) {
                        fMatches = (String)fMatches + "xyzabc" + sGenerator.nextString();
                    }
                    if ((matcher = matchesPattern.matcher((CharSequence)fMatches)).find()) {
                        matchesIdsBuilder.add((Object)id);
                    }
                    doc.set("f_matches", (String)fMatches);
                    Value.Type typeOfType = (Value.Type)TYPES.get(i % TYPES.length());
                    ValueFactory valueFactory = (ValueFactory)VALUE_FACTORY.get((Object)typeOfType);
                    Value typeOfValue = valueFactory.makeValue(random);
                    Assert.assertEquals((Object)typeOfType, (Object)typeOfValue.getType());
                    doc.set("f_typeOf", typeOfValue);
                    switch (typeOfType) {
                        case ARRAY: {
                            typeOfArrayIdsBuilder.add((Object)id);
                            break;
                        }
                        case DATE: {
                            typeOfDateIdsBuilder.add((Object)id);
                            break;
                        }
                        case NULL: {
                            typeOfNullIdsBuilder.add((Object)id);
                            break;
                        }
                        case SHORT: {
                            typeOfShortIdsBuilder.add((Object)id);
                            break;
                        }
                        case STRING: {
                            typeOfStringIdsBuilder.add((Object)id);
                            break;
                        }
                    }
                    table.insert(doc);
                }
                this.existsIds = existsIdsBuilder.build();
                Assert.assertTrue((String)"no f_exists values set for test", (this.existsIds.size() > 0 ? 1 : 0) != 0);
                this.matchesIds = matchesIdsBuilder.build();
                Assert.assertTrue((String)"no f_matches values set for test", (this.matchesIds.size() > 0 ? 1 : 0) != 0);
                this.typeOfArrayIds = typeOfArrayIdsBuilder.build();
                Assert.assertTrue((String)"no f_typeOf values that are arrays", (this.typeOfArrayIds.size() > 0 ? 1 : 0) != 0);
                this.typeOfDateIds = typeOfDateIdsBuilder.build();
                Assert.assertTrue((String)"no f_typeOf values that are dates", (this.typeOfDateIds.size() > 0 ? 1 : 0) != 0);
                this.typeOfNullIds = typeOfNullIdsBuilder.build();
                Assert.assertTrue((String)"no f_typeOf values that are NULLs", (this.typeOfNullIds.size() > 0 ? 1 : 0) != 0);
                this.typeOfShortIds = typeOfShortIdsBuilder.build();
                Assert.assertTrue((String)"no f_typeOf values that are shorts", (this.typeOfShortIds.size() > 0 ? 1 : 0) != 0);
                this.typeOfStringIds = typeOfStringIdsBuilder.build();
                Assert.assertTrue((String)"no f_typeOf values that are Strings", (this.typeOfStringIds.size() > 0 ? 1 : 0) != 0);
                this.longerStringIds = longerStringIdsBuilder.build();
                Assert.assertTrue((String)"no strings long enough for test", (this.longerStringIds.size() > 0 ? 1 : 0) != 0);
                table.flush();
                String string = tableName;
                return string;
            }
        }

        @Override
        public long getNumRows() {
            return 687L;
        }

        static {
            HashMap<Value.Type, ValueFactory> valueFactory = new HashMap<Value.Type, ValueFactory>();
            valueFactory.put(Value.Type.ARRAY, new ValueFactory(){

                @Override
                public Value makeValue(Random random) {
                    Object[] ints = new Integer[random.nextInt(32)];
                    for (int i = 0; i < ints.length; ++i) {
                        ints[i] = new Integer(random.nextInt());
                    }
                    return new Values.ArrayValue(ints);
                }
            });
            valueFactory.put(Value.Type.BINARY, new ValueFactory(){

                @Override
                public Value makeValue(Random random) {
                    byte[] bytes = new byte[random.nextInt(512)];
                    random.nextBytes(bytes);
                    return new Values.BinaryValue(ByteBuffer.wrap(bytes));
                }
            });
            valueFactory.put(Value.Type.BOOLEAN, new ValueFactory(){

                @Override
                public Value makeValue(Random random) {
                    return new Values.BooleanValue(random.nextBoolean());
                }
            });
            valueFactory.put(Value.Type.BYTE, new ValueFactory(){

                @Override
                public Value makeValue(Random random) {
                    return new Values.ByteValue((byte)random.nextInt(127));
                }
            });
            valueFactory.put(Value.Type.DATE, new ValueFactory(){

                @Override
                public Value makeValue(Random random) {
                    ODate date = new ODate(2000 + random.nextInt(28), 1 + random.nextInt(12), 1 + random.nextInt(28));
                    return new Values.DateValue(date);
                }
            });
            valueFactory.put(Value.Type.DOUBLE, new ValueFactory(){

                @Override
                public Value makeValue(Random random) {
                    return new Values.DoubleValue(random.nextDouble());
                }
            });
            valueFactory.put(Value.Type.FLOAT, new ValueFactory(){

                @Override
                public Value makeValue(Random random) {
                    return new Values.FloatValue(random.nextFloat());
                }
            });
            valueFactory.put(Value.Type.INT, new ValueFactory(){

                @Override
                public Value makeValue(Random random) {
                    return new Values.IntValue(random.nextInt());
                }
            });
            valueFactory.put(Value.Type.LONG, new ValueFactory(){

                @Override
                public Value makeValue(Random random) {
                    return new Values.LongValue(random.nextLong());
                }
            });
            valueFactory.put(Value.Type.NULL, new ValueFactory(){

                @Override
                public Value makeValue(Random random) {
                    return Values.NULL;
                }
            });
            valueFactory.put(Value.Type.SHORT, new ValueFactory(){

                @Override
                public Value makeValue(Random random) {
                    return new Values.ShortValue((short)random.nextInt(Short.MAX_VALUE));
                }
            });
            valueFactory.put(Value.Type.STRING, new ValueFactory(){

                @Override
                public Value makeValue(Random random) {
                    StringGenerator sGenerator = new StringGenerator(128, random);
                    return new Values.StringValue(sGenerator.nextString());
                }
            });
            valueFactory.put(Value.Type.TIME, new ValueFactory(){

                @Override
                public Value makeValue(Random random) {
                    OTime time = new OTime(random.nextLong());
                    return new Values.TimeValue(time);
                }
            });
            valueFactory.put(Value.Type.TIMESTAMP, new ValueFactory(){

                @Override
                public Value makeValue(Random random) {
                    OTimestamp timestamp = new OTimestamp(random.nextLong());
                    return new Values.TimestampValue(timestamp);
                }
            });
            VALUE_FACTORY = ImmutableMap.copyOf(valueFactory);
            Object[] types = new Value.Type[VALUE_FACTORY.size()];
            int typesIdx = 0;
            for (Value.Type key : VALUE_FACTORY.keySet()) {
                types[typesIdx++] = key;
            }
            TYPES = ImmutableArray.from((Object[])types);
        }

        static interface ValueFactory {
            public Value makeValue(Random var1);
        }
    }

    private static class SharedTableMaprdb1098
    extends SharedTestTable {
        private String indexName;
        private static final int numRows = 100;

        SharedTableMaprdb1098() {
            super("maprdb1098");
        }

        @Override
        protected String initialize(Connection connection, String rawTableName) throws Exception {
            try (JsonTable table = DBTests.createOrGetTable((String)rawTableName);){
                Path tablePath = table.getPath();
                String tableName = tablePath.toString();
                this.indexName = rawTableName + "_i_idx";
                DBTests.createIndex((JsonTable)table, (String)this.indexName, (boolean)false, (int)0, (String[])new String[]{"i"}, null, null);
                Random valueGenerator = new Random(1098L);
                StringGenerator sGenerator = new StringGenerator(64, valueGenerator);
                for (int i = 0; i < 100; ++i) {
                    Document doc = MapRDB.newDocument();
                    doc.set("_id", Integer.toString(i));
                    doc.set("i", i);
                    doc.set("j", valueGenerator.nextInt());
                    doc.set("s", sGenerator.nextString());
                    table.insert(doc);
                }
                table.flush();
                String string = tableName;
                return string;
            }
        }

        @Override
        public long getNumRows() {
            return 100L;
        }

        public String getIndexName() {
            return this.indexName;
        }
    }

    private static class SharedTableMaprdb1119
    extends SharedTestTableLoader {
        private final String indexName = "xDotyBracketsDotz_idx";

        SharedTableMaprdb1119() {
            super("maprdb1119");
        }

        @Override
        protected String initialize(Connection connection, String trialRawTableName) throws Exception {
            String tableName = super.initialize(connection, trialRawTableName);
            try (JsonTable table = DBTests.getTable((String)DBTests.getNameWithoutPath((String)tableName));){
                DBTests.createIndex((JsonTable)table, (String)"xDotyBracketsDotz_idx", (boolean)false, (int)0, (String[])new String[]{"x.y[].z"}, null, null);
                String string = tableName;
                return string;
            }
        }

        public String getIndexName() {
            return "xDotyBracketsDotz_idx";
        }
    }

    private static class SharedTableMaprdb1369
    extends SharedTestTableLoader {
        private String indexName;

        public SharedTableMaprdb1369() {
            super("testMaprdb1369");
        }

        public String getIndexName() {
            return this.indexName;
        }

        @Override
        protected String initialize(Connection connection, String trialRawTableName) throws Exception {
            String tableName = super.initialize(connection, trialRawTableName);
            this.indexName = trialRawTableName + "_dmk_bmk_idx";
            try (JsonTable table = DBTests.getTable((String)DBTests.getNameWithoutPath((String)tableName));){
                DBTests.createIndex((JsonTable)table, (String)this.indexName, (boolean)false, (int)0, (String[])new String[]{"l0_a0_mapList[].sl1_a0_mapList[].l0_a0_dateMapKey", "l0_a0_mapList[].sl1_a0_mapList[].l0_a0_binaryMapKey"}, (SortOrder[])new SortOrder[]{SortOrder.DESC, SortOrder.DESC}, (String[])new String[]{"l0_a0_mapList[].sl1_a0_mapList[].l0_a0_dateMapKey", "l0_a0_mapList[].sl1_a0_mapList[].l0_a0_binaryMapKey"});
                String string = tableName;
                return string;
            }
        }
    }

    private static class SharedTableMaprdb1347
    extends SharedTestTableLoader {
        private String indexName;

        public SharedTableMaprdb1347() {
            super("maprdb1347");
        }

        public String getIndexName() {
            return this.indexName;
        }

        @Override
        protected String initialize(Connection connection, String trialRawTableName) throws Exception {
            String tableName = super.initialize(connection, trialRawTableName);
            this.indexName = trialRawTableName + "_price_prodname_idx";
            try (JsonTable table = DBTests.getTable((String)DBTests.getNameWithoutPath((String)tableName));){
                DBTests.createIndex((JsonTable)table, (String)this.indexName, (boolean)false, (int)0, (String[])new String[]{"orders[].products[].price", "orders[].products[].prodname"}, null, null);
                String string = tableName;
                return string;
            }
        }
    }

    private static class Primes {
        private static final ArrayList<Integer> primes = new ArrayList();

        private Primes() {
        }

        public int get(int i) {
            if (i >= primes.size()) {
                primes.ensureCapacity(i + 1);
                for (int j = primes.size(); j <= i; ++j) {
                    primes.add(this.compute(j));
                }
            }
            return primes.get(i);
        }

        protected Integer compute(int i) {
            if (i <= 1) {
                return i + 2;
            }
            int lastPrime = this.get(i - 1);
            int newPrime = lastPrime + 2;
            while (true) {
                block4: {
                    int divisor = 1;
                    int pidx = 1;
                    while (divisor * divisor < newPrime) {
                        divisor = this.get(pidx);
                        int quotient = newPrime / divisor;
                        if (quotient * divisor != newPrime) {
                            ++pidx;
                            continue;
                        }
                        break block4;
                    }
                    return newPrime;
                }
                newPrime += 2;
            }
        }
    }
}

