/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.db.JsonTable;
import com.mapr.db.Table;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.ojai.store.impl.OjaiDriver;
import com.mapr.ojai.store.impl.OjaiTest;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ojai.Document;
import org.ojai.FieldPath;
import org.ojai.types.ODate;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

public class AppsUserProfiles {
    public static final String BASE_TABLE_NAME = "user_profiles";
    public static final String EMPTY_TABLE_NAME = "user_profiles_empty";
    public static final FieldPath FIRST_NAME_FIELD = FieldPath.parseFrom((String)"first_name");
    public static final FieldPath LAST_NAME_FIELD = FieldPath.parseFrom((String)"last_name");
    public static final String ID_NON_EXISTENT = "Zoolander";
    public static final String ID_EXISTENT = "dsimon";
    public static final String ID_W_EXTRAS = "rsmith";
    public static final String ID_EXISTENT2 = "mdupont";
    public static final String FIRST_NAME_EXISTENT = "David";
    public static final String LAST_NAME_EXISTENT = "Simon";
    public static final String FIRST_NAME_EXISTENT2 = "Maxime";
    public static final String LAST_NAME_EXISTENT2 = "Dupont";
    public static final String ID_DELETABLE = "jdoe";
    private static Map<String, HashMap<String, Document>> tableMap = new HashMap<String, HashMap<String, Document>>();

    private static void insertDocuments(Map<String, Document> docMap, Table table) {
        OjaiDriver driver = OjaiTest.getDriver();
        Document document = driver.newDocument().set("_id", ID_DELETABLE).set("first_name", "John").set("last_name", "Doe").set("dob", ODate.parse((String)"1970-06-23"));
        table.insertOrReplace(document);
        docMap.put(document.getString("last_name"), document);
        document = driver.newDocument().set("first_name", FIRST_NAME_EXISTENT).set("last_name", LAST_NAME_EXISTENT).set("dob", ODate.parse((String)"1980-10-13"));
        table.insertOrReplace(ID_EXISTENT, document);
        docMap.put(document.getString("last_name"), document);
        document = driver.newDocument().set("_id", ID_EXISTENT2).set("first_name", FIRST_NAME_EXISTENT2).set("last_name", LAST_NAME_EXISTENT2).set("dob", ODate.parse((String)"1982-02-03")).set("interests", Arrays.asList("sports", "movies", "electronics")).set("address.line", "1223 Broadway").set("address.city", "San Jose").set("address.zip", 95109);
        table.insertOrReplace(document);
        docMap.put(document.getString("last_name"), document);
        Document addressRecord = driver.newDocument().set("line", "100 Main Street").set("city", "San Francisco").set("zip", 94105);
        Document extras = driver.newDocument().set("aboolean", true).set("afloat", 1.41f).set("adouble", 3.1415926).set("ashort", (short)17).set("abyte", (byte)42);
        document = driver.newDocument().set("_id", ID_W_EXTRAS).set("first_name", "Robert").set("last_name", "Smith").set("dob", ODate.parse((String)"1982-02-03")).set("interests", Arrays.asList("electronics", "music", "sports")).set("address", addressRecord).set("topdate", new ODate(2001, 5, 2)).set("toptime", new OTime(10, 30, 0, 25)).set("toptimestamp", new OTimestamp(1976, 7, 4, 12, 30, 10, 2)).set("extras", extras);
        table.insertOrReplace(document);
        docMap.put(document.getString("last_name"), document);
        table.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Document> getDocMap(String tableName) {
        Map<String, HashMap<String, Document>> map = tableMap;
        synchronized (map) {
            String testTableName = DBTests.getFullPath((String)tableName);
            return tableMap.get(testTableName);
        }
    }

    public static Table getEmptyTable(String tableName) throws IOException {
        return AppsUserProfiles.getTable(tableName, false);
    }

    public static Table getPopulatedTable(String tableName) throws IOException {
        return AppsUserProfiles.getTable(tableName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Table getTable(String tableName, boolean populate) throws IOException {
        JsonTable table;
        Map<String, HashMap<String, Document>> map = tableMap;
        synchronized (map) {
            table = DBTests.createOrGetTable((String)tableName);
            String tablePath = table.getPath().toString();
            HashMap<String, Object> docMap = tableMap.get(tablePath);
            if (docMap == null) {
                docMap = new HashMap();
                if (populate) {
                    AppsUserProfiles.insertDocuments(docMap, (Table)table);
                }
                tableMap.put(tablePath, docMap);
            }
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllTables() throws IOException {
        Map<String, HashMap<String, Document>> map = tableMap;
        synchronized (map) {
            Set<String> keySet = tableMap.keySet();
            for (String tableName : keySet) {
                DBTests.deleteTables((String[])new String[]{tableName});
            }
            tableMap.clear();
        }
    }
}

