/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.base.Preconditions;
import com.mapr.db.impl.FieldPathHelper;
import com.mapr.ojai.store.impl.ElementOperator;
import com.mapr.ojai.store.impl.Expression;
import com.mapr.ojai.store.impl.ExpressionVisitor;
import com.mapr.ojai.store.impl.FieldExpression;
import com.mapr.ojai.store.impl.LiteralExpression;
import com.mapr.ojai.store.impl.NaryOperator;
import com.mapr.ojai.store.impl.UnaryOperator;
import org.ojai.FieldPath;

public class ExpressionToSql
extends ExpressionVisitor {
    private final String tableAlias;
    private final StringBuilder sb;

    public static void convert(StringBuilder stringBuilder, Expression expr, String tableAlias) {
        Preconditions.checkArgument((tableAlias == null || tableAlias.length() > 0 ? 1 : 0) != 0, (Object)"the table alias must be null or a non-empty string");
        ExpressionToSql etos = new ExpressionToSql(stringBuilder, tableAlias);
        expr.visit(etos);
    }

    public static String convert(Expression expr, String tableAlias) {
        StringBuilder stringBuilder = new StringBuilder();
        ExpressionToSql.convert(stringBuilder, expr, tableAlias);
        return stringBuilder.toString();
    }

    private ExpressionToSql(StringBuilder stringBuilder, String tableAlias) {
        this.tableAlias = tableAlias;
        this.sb = stringBuilder;
    }

    @Override
    public void visitField(FieldExpression fieldExpr) {
        FieldPathHelper.emitFieldPath((StringBuilder)this.sb, (String)this.tableAlias, (FieldPath)fieldExpr.getFieldPath());
    }

    @Override
    public void visitLiteral(LiteralExpression literalExpr) {
        this.sb.append(literalExpr.getLiteral());
    }

    @Override
    public void visitNary(NaryOperator naryOp) {
        if (naryOp.isPrefix) {
            this.sb.append(naryOp.opName);
            this.sb.append('(');
            Expression[] arg = naryOp.arg;
            arg[0].visit(this);
            for (int i = 1; i < naryOp.arg.length; ++i) {
                this.sb.append(',');
                arg[i].visit(this);
            }
            this.sb.append(')');
        } else {
            String opName = naryOp.opName.equals("!=") ? "<>" : naryOp.opName;
            String infixOpStr = " " + opName + " ";
            this.sb.append('(');
            Expression[] arg = naryOp.arg;
            arg[0].visit(this);
            for (int i = 1; i < naryOp.arg.length; ++i) {
                this.sb.append(infixOpStr);
                arg[i].visit(this);
            }
            this.sb.append(')');
        }
    }

    @Override
    public void visitElement(ElementOperator elemOp) {
        throw new UnsupportedOperationException("unimplemented");
    }

    @Override
    public void visitUnary(UnaryOperator unaryOp) {
        this.sb.append(unaryOp.opName);
        this.sb.append('(');
        unaryOp.getOperand().visit(this);
        this.sb.append(')');
    }
}

