/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.db.impl.OjaiQueryProperties;
import com.mapr.ojai.store.impl.AbstractDocumentFilter;
import com.mapr.ojai.store.impl.LongValue;
import com.mapr.ojai.store.impl.PipelineControl;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ojai.Document;
import org.ojai.DocumentStream;

public class LimitStream
extends AbstractDocumentFilter {
    private final long limit;
    private long docCount;

    public LimitStream(DocumentStream upstreamStream, long limit) {
        super(upstreamStream);
        this.limit = limit;
        if (upstreamStream instanceof PipelineControl) {
            PipelineControl pc = (PipelineControl)upstreamStream;
            pc.setDesiredRows(new RemainingRows());
        }
    }

    @Override
    public Iterator<Document> iterator() {
        super.iterator();
        return new LimitIterator();
    }

    public void getQueryPlan(List<Map<String, Object>> planList) {
        if (this.upstreamStream == null) {
            return;
        }
        ((OjaiQueryProperties)this.upstreamStream).getQueryPlan(planList);
        HashMap<String, Object> myMap = new HashMap<String, Object>();
        myMap.put("streamName", this.getClass().getSimpleName());
        HashMap<String, Long> valueMap = new HashMap<String, Long>();
        valueMap.put("limit", this.limit);
        myMap.put("parameters", valueMap);
        planList.add(myMap);
    }

    private class LimitIterator
    implements Iterator<Document> {
        private LimitIterator() {
        }

        @Override
        public boolean hasNext() {
            if (LimitStream.this.docCount >= LimitStream.this.limit) {
                LimitStream.this.upstreamStream.close();
                return false;
            }
            return LimitStream.this.docIter.hasNext();
        }

        @Override
        public Document next() {
            Document doc = (Document)LimitStream.this.docIter.next();
            ++LimitStream.this.docCount;
            return doc;
        }
    }

    private class RemainingRows
    implements LongValue {
        private RemainingRows() {
        }

        @Override
        public long getLongValue() {
            return LimitStream.this.limit - LimitStream.this.docCount;
        }
    }
}

