/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl.bean;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Preconditions;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.fs.beans.QueryServiceParam;
import java.util.Map;
import org.ojai.JsonString;
import org.ojai.json.JsonOptions;

public class DrillConnectionParams
implements JsonString {
    private QueryServiceParam qsp;
    private String clusterId;
    private String storagePlugin;
    private String znode;

    private DrillConnectionParams() {
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getStoragePlugin() {
        return this.storagePlugin;
    }

    public String getZnode() {
        return this.znode;
    }

    @JsonIgnore
    public boolean isValid() {
        return this.clusterId != null && this.storagePlugin != null && this.znode != null;
    }

    public String getZookeeperQuorum() {
        return this.qsp.getZookeeperConnect();
    }

    @JsonIgnore
    public Map<String, String> getConnectionParams() {
        return this.qsp.getConnectionParams();
    }

    public boolean isEnabled() {
        return this.qsp.isEnabled();
    }

    public String asJsonString() {
        return MapRDBImpl.newDocument((Object)this).asJsonString();
    }

    public String asJsonString(JsonOptions options) {
        return MapRDBImpl.newDocument((Object)this).asJsonString(options);
    }

    private DrillConnectionParams setQueryServiceParam(QueryServiceParam qsp) {
        this.qsp = qsp;
        return this;
    }

    public static DrillConnectionParams from(QueryServiceParam qsp) {
        Preconditions.checkNotNull((Object)qsp);
        DrillConnectionParams dcp = new DrillConnectionParams().setQueryServiceParam(qsp);
        if (qsp.isEnabled()) {
            Map params = qsp.getConnectionParams();
            dcp.clusterId = (String)params.get("clusterid");
            dcp.storagePlugin = (String)params.get("storageplugin");
            dcp.znode = (String)params.get("znode");
        }
        return dcp;
    }
}

