/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ExecutionError;
import com.mapr.db.exceptions.DBException;
import com.mapr.ojai.store.impl.DrillNotInClasspathException;
import com.mapr.ojai.store.impl.OjaiConnection;
import com.mapr.ojai.store.impl.OjaiDrillClient;
import com.mapr.ojai.store.impl.bean.DrillConnectionParams;
import com.mapr.security.JNISecurity;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import org.apache.drill.common.config.DrillProperties;
import org.apache.drill.common.exceptions.DrillIOException;
import org.apache.drill.exec.rpc.NonTransientRpcException;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.user.clusterclient.ClusterClientBuilders;
import org.apache.drill.exec.rpc.user.clusterclient.DrillSession;
import org.apache.drill.exec.rpc.user.clusterclient.zkbased.ZKBasedConnectionPool;
import org.apache.drill.exec.rpc.user.clusterclient.zkbased.ZKBasedEndpointProvider;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LazyClient
extends OjaiDrillClient {
    private static final Logger logger = LoggerFactory.getLogger(LazyClient.class);
    private ZKBasedConnectionPool pool;
    private final OjaiConnection ojaiConnection;
    private final String connectionUser;
    private static final String MAPR_HOME_NAME = "MAPR_HOME";
    private static final String MAPR_HOME_DEFAULT = "/opt/mapr/";
    private static final String MAPR_HOME = LazyClient.getMaprHome();
    private static final String MAPR_LOGIN_CONF = MAPR_HOME + "conf/mapr.login.conf";
    private LoadingCache<String, ZKBasedConnectionPool> clusterPoolCache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<String, ZKBasedConnectionPool>(){

        public ZKBasedConnectionPool load(String clusterName) {
            DrillConnectionParams connectParam = LazyClient.this.ojaiConnection.getQueryServiceParam(clusterName);
            if (!connectParam.isEnabled()) {
                LazyClient.this.ojaiConnection.invalidateQueryServiceParam(clusterName);
                throw new DBException("MapR-DB Query Service is not enabled for cluster: " + clusterName);
            }
            if (!connectParam.isValid()) {
                LazyClient.this.ojaiConnection.invalidateQueryServiceParam(clusterName);
                throw new DBException("Invalid Query Service configuration : `" + connectParam.getConnectionParams() + "` for cluster: " + clusterName);
            }
            logger.info("Connecting to Apache Drill cluster: " + connectParam.asJsonString());
            String zookeeperQuorum = connectParam.getZookeeperQuorum();
            String clusterId = connectParam.getClusterId();
            String znode = connectParam.getZnode();
            if (znode.startsWith("/")) {
                znode = znode.replaceAll("^/+", "");
            }
            String connectURL = String.format("%s/%s/%s", zookeeperQuorum, znode, clusterId);
            DrillProperties connectionProperties = DrillProperties.createEmpty();
            connectionProperties.put((Object)"user", (Object)LazyClient.this.connectionUser);
            if (JNISecurity.IsSecurityEnabled((String)clusterName)) {
                connectionProperties.put((Object)"auth", (Object)"MAPRSASL");
            }
            return ClusterClientBuilders.newZKBasedPool().setZKEndpointProviderBuilder(ZKBasedEndpointProvider.newBuilder().withUrl(connectURL)).setConnectionProperties(connectionProperties).build();
        }
    });

    private static String getMaprHome() {
        Object value = System.getenv(MAPR_HOME_NAME);
        if (value == null) {
            logger.info("MAPR_HOME variable not found, using {}", (Object)MAPR_HOME_DEFAULT);
            return MAPR_HOME_DEFAULT;
        }
        if (((String)value).charAt(((String)value).length() - 1) != '/') {
            value = (String)value + "/";
        }
        return value;
    }

    public LazyClient(OjaiConnection ojaiConnection) {
        this.ojaiConnection = ojaiConnection;
        this.pool = null;
        try {
            this.connectionUser = UserGroupInformation.getCurrentUser().getShortUserName();
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not identify the user", e);
        }
        if (this.connectionUser == null || this.connectionUser.isEmpty()) {
            throw new IllegalStateException("User is not set");
        }
    }

    private static void setPropertyIfNotSet(String key, String value) {
        String setValue = System.getProperty(key);
        if (setValue == null) {
            System.setProperty(key, value);
        }
    }

    private synchronized DrillSession getSession(String clusterName, ZKBasedConnectionPool pool) throws DBException, DrillIOException {
        String sessionUser;
        try {
            sessionUser = UserGroupInformation.getCurrentUser().getShortUserName();
            if (sessionUser == null || sessionUser.isEmpty()) {
                throw new DBException("User is not set");
            }
        }
        catch (IOException e) {
            throw new DBException("Could not identify the current user", (Throwable)e);
        }
        if (JNISecurity.IsSecurityEnabled((String)clusterName)) {
            LazyClient.setPropertyIfNotSet("drill.customAuthFactories", "org.apache.drill.exec.rpc.security.maprsasl.MapRSaslFactory");
            LazyClient.setPropertyIfNotSet("java.security.auth.login.config", MAPR_LOGIN_CONF);
        }
        Properties sessionProperties = new Properties();
        sessionProperties.setProperty("user", sessionUser);
        sessionProperties.setProperty("exec.query.progress.update", "false");
        sessionProperties.setProperty("exec.udf.use_dynamic", "false");
        sessionProperties.setProperty("exec.query_profile.save", "false");
        sessionProperties.setProperty("planner.use_simple_optimizer", "true");
        return pool.newSession(sessionProperties);
    }

    @Override
    public synchronized void close() {
        if (this.isClosed()) {
            return;
        }
        if (this.pool != null) {
            this.pool.close();
        }
        super.close();
    }

    private DBException unableToConnectToDrillCluster(String clusterName, Throwable cause) {
        DrillConnectionParams connectParam = this.ojaiConnection.getQueryServiceParam(clusterName);
        return new DBException(String.format("Unable to connect to Drill cluster: %s, please check zknode or clusterid passed to queryservice", connectParam.asJsonString()), cause);
    }

    final ZKBasedConnectionPool getPooledConnection(String clusterName) {
        try {
            return (ZKBasedConnectionPool)this.clusterPoolCache.get((Object)clusterName);
        }
        catch (ExecutionError | ExecutionException e) {
            Throwable realException = e.getCause();
            if (realException instanceof NoClassDefFoundError) {
                throw new DrillNotInClasspathException(realException);
            }
            if (realException instanceof NonTransientRpcException) {
                throw this.unableToConnectToDrillCluster(clusterName, realException);
            }
            throw new DBException(realException);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public synchronized DrillSession getDrillSession(String clusterName) {
        Preconditions.checkNotNull((Object)clusterName);
        int attempts = 0;
        long maxSleepDuration = 30000L;
        while (true) {
            try {
                return this.getSession(clusterName, this.getPooledConnection(clusterName));
            }
            catch (NonTransientRpcException e) {
                throw this.unableToConnectToDrillCluster(clusterName, e);
            }
            catch (RpcException e) {
                logger.warn("Lost connection with Drill cluster, will retry...", (Throwable)e);
                this.clusterPoolCache.invalidate((Object)clusterName);
                ++attempts;
                try {
                    long sleepDuration = attempts * 2 * 100;
                    if (sleepDuration > 30000L) {
                        Thread.sleep(30000L);
                        continue;
                    }
                    Thread.sleep(sleepDuration);
                }
                catch (InterruptedException ie) {
                    throw new DBException("Interrupted while waiting to get Drill session", (Throwable)ie);
                }
            }
        }
        catch (DrillIOException e) {
            throw new DBException("Unexpected exception while creating Drill session", (Throwable)e);
        }
    }
}

