/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.db.indexrowkeyfmt.IndexRowKeyEncoder;
import java.util.Arrays;

public class ByteArrayKey {
    private final byte[] theArray;
    private final int hashCode;
    private static final int HASH_SEED = -257178343;
    private static final int HASH_ROTATE = 5;

    public ByteArrayKey(byte[] theArray, boolean makeCopy) {
        this.theArray = !makeCopy ? theArray : Arrays.copyOf(theArray, theArray.length);
        this.hashCode = ByteArrayKey.computeHash(this.theArray);
    }

    private static int computeHash(byte[] b) {
        int hash = -257178343;
        for (int i = 0; i < b.length; ++i) {
            hash ^= b[i];
            hash = hash >>> 5 | hash << 27;
        }
        return hash;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof ByteArrayKey)) {
            return false;
        }
        ByteArrayKey other = (ByteArrayKey)o;
        if (other == this) {
            return true;
        }
        if (this.hashCode != other.hashCode) {
            return false;
        }
        int cmp = IndexRowKeyEncoder.memcmp((byte[])this.theArray, (byte[])other.theArray);
        return cmp == 0;
    }
}

