/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.base.Preconditions;
import com.mapr.db.impl.FieldPathStack;
import com.mapr.ojai.store.impl.ElementOperator;
import com.mapr.ojai.store.impl.Expression;
import com.mapr.ojai.store.impl.ExpressionVisitor;
import com.mapr.ojai.store.impl.FieldExpression;
import com.mapr.ojai.store.impl.LiteralExpression;
import com.mapr.ojai.store.impl.NaryOperator;
import com.mapr.ojai.store.impl.UnaryOperator;
import java.util.ArrayList;
import java.util.Stack;
import org.ojai.FieldPath;

public class ElementAndToAnd
extends ExpressionVisitor {
    private final Stack<Expression> exprStack = new Stack();
    private final FieldPathStack fieldPathStack = new FieldPathStack();
    private final PartialMatchHolder partialMatchHolder;

    private ElementAndToAnd(PartialMatchHolder holder) {
        this.partialMatchHolder = holder;
        this.partialMatchHolder.partialMatch = false;
    }

    public static Expression convert(Expression expr, PartialMatchHolder partialMatchHolder) {
        ElementAndToAnd visitor = new ElementAndToAnd(partialMatchHolder);
        expr.visit(visitor);
        assert (visitor.exprStack.size() == 1) : "exprStack.size() => " + visitor.exprStack.size() + " for " + expr;
        return visitor.exprStack.peek();
    }

    @Override
    public void visitField(FieldExpression fieldExpr) {
        Preconditions.checkNotNull((Object)fieldExpr);
        FieldPath fieldPath = fieldExpr.getFieldPath();
        FieldPath adjustedPath = this.fieldPathStack.getPath(fieldPath);
        if (adjustedPath.equals((Object)fieldPath)) {
            this.exprStack.push(fieldExpr);
        } else {
            FieldExpression newFieldExpr = new FieldExpression(adjustedPath);
            this.exprStack.push(newFieldExpr);
        }
    }

    @Override
    public void visitLiteral(LiteralExpression literalExpr) {
        Preconditions.checkNotNull((Object)literalExpr);
        this.exprStack.push(literalExpr);
    }

    private static boolean sameArguments(Expression[] exprArray, ArrayList<Expression> argList) {
        assert (exprArray.length == argList.size()) : "exprArray.length " + exprArray.length + " argList.size() " + argList.size();
        for (int i = 0; i < exprArray.length; ++i) {
            if (exprArray[i] == argList.get(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void visitNary(NaryOperator naryOp) {
        int i;
        super.visitNary(naryOp);
        ArrayList<Expression> argList = new ArrayList<Expression>(naryOp.arg.length);
        for (i = 0; i < naryOp.arg.length; ++i) {
            argList.add(null);
        }
        for (i = 0; i < naryOp.arg.length; ++i) {
            argList.set(naryOp.arg.length - 1 - i, this.exprStack.pop());
        }
        if (ElementAndToAnd.sameArguments(naryOp.arg, argList)) {
            this.exprStack.push(naryOp);
        } else if (naryOp.opName.equals("and")) {
            this.partialMatchHolder.partialMatch = true;
            this.exprStack.push(argList.get(0));
        } else {
            NaryOperator newOp = naryOp.recreateWithNewArgs(argList);
            this.exprStack.push(newOp);
        }
    }

    @Override
    public void visitElement(ElementOperator elemOp) {
        Preconditions.checkNotNull((Object)elemOp);
        this.fieldPathStack.push(elemOp.getPrefix());
        for (int i = elemOp.skipVisitArgs; i < elemOp.arg.length; ++i) {
            Expression expr = elemOp.arg[i];
            expr.visit(this);
        }
        ArrayList<Expression> argList = new ArrayList<Expression>(elemOp.arg.length - elemOp.skipVisitArgs);
        for (int i = elemOp.skipVisitArgs; i < elemOp.arg.length; ++i) {
            argList.add(this.exprStack.pop());
        }
        NaryOperator newOp = new NaryOperator("and", elemOp.isPrefix, elemOp.skipVisitArgs - 1, argList, elemOp.originalNode);
        this.exprStack.push(newOp);
        this.fieldPathStack.pop();
    }

    @Override
    public void visitUnary(UnaryOperator unaryOp) {
        Preconditions.checkNotNull((Object)unaryOp);
        unaryOp.operand.visit(this);
        unaryOp.operand = this.exprStack.pop();
        this.exprStack.push(unaryOp);
    }

    public static class PartialMatchHolder {
        public boolean partialMatch;
    }
}

