/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.base.Preconditions;
import com.mapr.db.impl.AefTransformer;
import com.mapr.db.impl.ClonedCondition;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.impl.ConditionVisitor;
import com.mapr.db.impl.FieldPathHelper;
import com.mapr.db.impl.FieldPathStack;
import com.mapr.db.impl.SqlTransformer;
import com.mapr.ojai.store.impl.ElementOperator;
import com.mapr.ojai.store.impl.Expression;
import com.mapr.ojai.store.impl.ExpressionOrConditionChecker;
import com.mapr.ojai.store.impl.ExpressionPruner;
import com.mapr.ojai.store.impl.ExpressionVisitor;
import com.mapr.ojai.store.impl.FieldExpression;
import com.mapr.ojai.store.impl.FieldInBundle;
import com.mapr.ojai.store.impl.LiteralExpression;
import com.mapr.ojai.store.impl.NaryOperator;
import com.mapr.ojai.store.impl.OjaiQuery;
import com.mapr.ojai.store.impl.PredicateManager;
import com.mapr.ojai.store.impl.RelationalOperator;
import com.mapr.ojai.store.impl.SortKey;
import com.mapr.ojai.store.impl.UnaryOperator;
import com.mapr.utils.IndentingStringBuilder;
import com.mapr.utils.PlainStringBuilder;
import com.mapr.utils.PrettyStringBuilder;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.drill.exec.util.EncodedSchemaPathSet;
import org.ojai.DocumentConstants;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.store.QueryCondition;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

class QueryAnalyzer
implements ConditionVisitor {
    private final LinkedList<Expression> exprStack = new LinkedList();
    private static final Set<FieldPath> STAR_PROJECTION;
    private static final Expression ID_EQUALS;
    private PredicateManager predicateManager;
    private Map<FieldPath, List<NaryOperator>> topRelations;
    private Set<Expression> otherPredicates;

    QueryAnalyzer() {
    }

    public boolean structuralEquals(QueryAnalyzer other) {
        return this.getExpressionTree().structuralEquals(other.exprStack.peek());
    }

    public int structuralHashCode() {
        return this.getExpressionTree().structuralHashCode();
    }

    public Expression getExpressionTree() {
        Preconditions.checkState((this.predicateManager != null && this.exprStack.size() < 2 ? 1 : 0) != 0, (String)"predicateManager => %s exprStack.size() %d", (Object)this.predicateManager, (int)this.exprStack.size());
        return this.exprStack.peek();
    }

    protected LinkedList<Expression> peekOperands(int nOperands) {
        Preconditions.checkArgument((nOperands <= this.exprStack.size() ? 1 : 0) != 0);
        LinkedList<Expression> operandList = new LinkedList<Expression>();
        for (int i = 0; i < nOperands; ++i) {
            operandList.addFirst(this.exprStack.get(i));
        }
        return operandList;
    }

    public void visit(ExpressionVisitor ev) {
        Preconditions.checkState((this.exprStack.size() <= 1 ? 1 : 0) != 0);
        if (this.exprStack.size() == 0) {
            return;
        }
        this.exprStack.peek().visit(ev);
    }

    public Expression getPrunedExpression(Set<FieldPath> keepFields, Set<ClonedCondition> keepConditions, ExpressionPruner.PartialElementAndMatch partialElmentAndMatch) {
        Preconditions.checkState((this.exprStack.size() <= 1 ? 1 : 0) != 0);
        Expression exprRoot = this.exprStack.peek();
        if (exprRoot == null) {
            return null;
        }
        ExpressionPruner pruner = new ExpressionPruner(keepFields, keepConditions, partialElmentAndMatch);
        exprRoot.visit(pruner);
        return pruner.getPrunedExpression();
    }

    private static void appendTableName(IndentingStringBuilder sb, String engineName, String tableName, String tableAlias) {
        sb.append(engineName);
        sb.append(".`");
        sb.append(tableName);
        sb.append('`');
        if (tableAlias != null) {
            sb.append(' ');
            sb.append(tableAlias);
        }
    }

    private void appendArrayCondition(IndentingStringBuilder sb, AefTransformer arrayAef, String engineName, String tableName, String tableAlias) {
        if (tableAlias != null) {
            sb.append(tableAlias);
            sb.append('.');
        }
        sb.append("_id in(");
        SqlTransformer sqlTransformer = new SqlTransformer(engineName, tableName);
        arrayAef.appendSqlInSubquery(sb, sqlTransformer);
        sb.append(')');
    }

    private void appendBlockConditions(IndentingStringBuilder sb, AefTransformer rootAef, String engineName, String tableName, String tableAlias) {
        String logicalOp = rootAef.getBlockType();
        Preconditions.checkState(("and".equals(logicalOp) || "or".equals(logicalOp) ? 1 : 0) != 0, (String)"Invalid condition block type: %s", (Object)logicalOp);
        sb.append("(");
        boolean isFirst = true;
        for (AefTransformer childAef : rootAef.getChildren()) {
            if (!isFirst) {
                sb.append(" ").append(logicalOp).append(" ");
            }
            isFirst = false;
            if (childAef.isLeaf()) {
                ConditionNode leafCond = childAef.toCondition(null);
                leafCond.appendSqlArrayCondition(sb, tableAlias, null);
                continue;
            }
            if (childAef.isConditionBlock()) {
                this.appendBlockConditions(sb, childAef, engineName, tableName, tableAlias);
                continue;
            }
            if (childAef.isArrayCondition()) {
                this.appendArrayCondition(sb, childAef, engineName, tableName, tableAlias);
                continue;
            }
            throw new IllegalStateException("Invalid AefTransformer encountered: " + childAef);
        }
        sb.append(")");
    }

    public String buildSql(OjaiQuery ojaiQuery, String engineName, String tableName, List<SortKey> sortKeys, long offset, long limit) {
        String queryString;
        Set<FieldPath> projectedFieldSet;
        Set<FieldPath> userProjectedFieldSet = ojaiQuery.getProjectedFieldSet();
        if (userProjectedFieldSet == null || userProjectedFieldSet.size() == 0) {
            projectedFieldSet = STAR_PROJECTION;
        } else if (userProjectedFieldSet.contains(DocumentConstants.ID_FIELD)) {
            projectedFieldSet = userProjectedFieldSet;
        } else {
            projectedFieldSet = new HashSet<FieldPath>(userProjectedFieldSet);
            projectedFieldSet.add(DocumentConstants.ID_FIELD);
        }
        StringBuilder innersb = new StringBuilder();
        PrettyStringBuilder sb = AefTransformer.showTransform() ? new PrettyStringBuilder(innersb, 2) : new PlainStringBuilder(innersb);
        String tableAlias = null;
        if (projectedFieldSet != null && projectedFieldSet.size() > 0 || this.exprStack.size() == 1 || sortKeys != null && sortKeys.size() > 0) {
            tableAlias = "t";
        }
        sb.append("select ");
        if (projectedFieldSet == null || projectedFieldSet.size() == 0) {
            FieldPathHelper.emitQuotedFieldPath((StringBuilder)innersb, (String)tableAlias, (String)EncodedSchemaPathSet.ENCODED_STAR_COLUMN);
            sb.append(',');
        } else {
            String[] encodedPath;
            String[] fieldPathStrArray = new String[projectedFieldSet.size()];
            Iterator<FieldPath> fpItr = projectedFieldSet.iterator();
            for (int i = 0; i < fieldPathStrArray.length; ++i) {
                fieldPathStrArray[i] = fpItr.next().asPathString(false);
            }
            for (String fieldPath : encodedPath = EncodedSchemaPathSet.encode((String[])fieldPathStrArray)) {
                FieldPathHelper.emitQuotedFieldPath((StringBuilder)innersb, (String)tableAlias, (String)fieldPath);
                sb.append(',');
            }
        }
        FieldPathHelper.emitQuotedFieldPath((StringBuilder)innersb, (String)tableAlias, (String)"$$document");
        sb.pushIndent().nextLine().append("from ");
        QueryAnalyzer.appendTableName((IndentingStringBuilder)sb, engineName, tableName, tableAlias);
        String string = queryString = AefTransformer.showTransform() ? ojaiQuery.toString() : null;
        if (!ojaiQuery.isArrayQuery()) {
            if (this.exprStack.size() == 1) {
                sb.nextLine().append("where ");
                this.exprStack.peek().emitSql(innersb, tableAlias);
            }
        } else {
            sb.nextLine().append("where ");
            ConditionNode cNode = ojaiQuery.getRoot();
            AefTransformer interAef = cNode.createAefTransformer(null);
            if (AefTransformer.showTransform()) {
                System.err.println("\nojaiQuery(" + queryString + ") => AEF:\n" + interAef.toString());
            }
            AefTransformer rootAef = interAef.toServer();
            if (AefTransformer.showTransform()) {
                System.err.println("\nojaiQuery(" + queryString + ") => toServer() AEF:\n" + rootAef.toString());
            }
            if (rootAef.isConditionBlock()) {
                this.appendBlockConditions((IndentingStringBuilder)sb, rootAef, engineName, tableName, tableAlias);
            } else {
                this.appendArrayCondition((IndentingStringBuilder)sb, rootAef, engineName, tableName, tableAlias);
            }
        }
        if (sortKeys != null && sortKeys.size() > 0) {
            sb.nextLine().append("order by ");
            boolean isFirst = true;
            for (SortKey sortKey : sortKeys) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(',');
                }
                FieldPathHelper.emitFieldPath((StringBuilder)innersb, (String)tableAlias, (FieldPath)sortKey.fieldPath);
                sb.append(' ');
                sb.append(sortKey.sortOrder.toString());
            }
        }
        if (limit != -1L) {
            sb.nextLine().append(" limit ");
            sb.append(limit);
        }
        if (offset > 0L) {
            sb.nextLine().append(" offset ");
            sb.append(offset);
        }
        sb.popIndent();
        String sqlString = sb.toString();
        if (AefTransformer.showTransform()) {
            System.err.println("\nojaiQuery(" + queryString + ") => SQL:\n" + sqlString);
        }
        return sqlString;
    }

    public boolean isAlwaysFalse() {
        LiteralExpression litExpr;
        Expression expr;
        Preconditions.checkState((this.exprStack.size() <= 1 ? 1 : 0) != 0, (Object)"Expression stack must have one element or less");
        return this.exprStack.size() == 1 && (expr = this.exprStack.get(0)) instanceof LiteralExpression && (litExpr = (LiteralExpression)expr).getType() == Value.Type.BOOLEAN && !litExpr.getBoolean();
    }

    public boolean isIdEquals() {
        Preconditions.checkState((this.exprStack.size() == 1 ? 1 : 0) != 0, (Object)"Expression stack must have exactly one element");
        return ID_EQUALS.structuralEquals(this.exprStack.peek());
    }

    public Value getIdForLookup() {
        Preconditions.checkState((boolean)this.isIdEquals());
        NaryOperator top = (NaryOperator)this.exprStack.peek();
        LiteralExpression key = (LiteralExpression)(top.arg[0] instanceof LiteralExpression ? top.arg[0] : top.arg[1]);
        if (key.getType() == Value.Type.NULL) {
            return null;
        }
        return key;
    }

    public boolean isUnion() {
        Preconditions.checkState((this.exprStack.size() <= 1 ? 1 : 0) != 0, (Object)"Expression stack must have at least one element");
        Expression topExpr = this.exprStack.peek();
        if (topExpr != null && topExpr instanceof NaryOperator) {
            NaryOperator naryOp = (NaryOperator)topExpr;
            if (naryOp.opName.equals("or")) {
                return true;
            }
        }
        return false;
    }

    public boolean canUseOneIndex() {
        Preconditions.checkState((this.exprStack.size() <= 1 ? 1 : 0) != 0, (Object)"Expression stack must have at least one element");
        Expression topExpr = this.exprStack.peek();
        if (topExpr == null || !(topExpr instanceof NaryOperator)) {
            return true;
        }
        ExpressionOrConditionChecker.MutableBoolean canUseIndex = new ExpressionOrConditionChecker.MutableBoolean(true);
        ExpressionOrConditionChecker orChecker = new ExpressionOrConditionChecker(canUseIndex);
        topExpr.visit(orChecker);
        return canUseIndex.value;
    }

    private static <T> T getSingleMember(Set<T> set) {
        Iterator<T> iter = set.iterator();
        if (!iter.hasNext()) {
            return null;
        }
        T t = iter.next();
        return t;
    }

    public FieldInBundle getFieldInBundle() {
        Preconditions.checkState((this.exprStack.size() == 1 ? 1 : 0) != 0, (Object)"Expression stack must have exactly one element");
        Expression exprRoot = this.exprStack.peek();
        if (!(exprRoot instanceof NaryOperator)) {
            return null;
        }
        NaryOperator nOp = (NaryOperator)exprRoot;
        if (nOp.opName.equals("in")) {
            LinkedList<LiteralExpression> values = new LinkedList<LiteralExpression>();
            for (Expression expr : nOp.arg) {
                if (!(expr instanceof LiteralExpression)) {
                    throw new IllegalStateException();
                }
                LiteralExpression literalArg = (LiteralExpression)expr;
                values.add(literalArg);
            }
            this.gatherExpressions();
            FieldPath topField = QueryAnalyzer.getSingleMember(this.topRelations.keySet());
            return new FieldInBundle(topField, values);
        }
        if (!nOp.opName.equals("or")) {
            return null;
        }
        this.gatherExpressions();
        if (this.topRelations.size() != 1) {
            return null;
        }
        if (this.otherPredicates.size() != 0) {
            return null;
        }
        LinkedList<LiteralExpression> values = new LinkedList<LiteralExpression>();
        for (Expression expr : nOp.arg) {
            if (!(expr instanceof RelationalOperator)) {
                return null;
            }
            RelationalOperator relOp = (RelationalOperator)expr;
            String opName = relOp.opName;
            if (!opName.equals("=")) continue;
            if (!(relOp.arg[0] instanceof FieldExpression)) {
                return null;
            }
            if (!(relOp.arg[1] instanceof LiteralExpression)) {
                return null;
            }
            values.add((LiteralExpression)relOp.arg[1]);
        }
        FieldPath topField = QueryAnalyzer.getSingleMember(this.topRelations.keySet());
        return new FieldInBundle(topField, values);
    }

    private void gatherExpressions() {
        if (this.predicateManager == null) {
            Preconditions.checkState((this.exprStack.size() <= 1 ? 1 : 0) != 0);
            HashMap<FieldPath, List<NaryOperator>> privateTopRelations = new HashMap<FieldPath, List<NaryOperator>>();
            HashSet<Expression> privateOtherPredicates = new HashSet<Expression>();
            this.predicateManager = new PredicateFields(privateTopRelations, privateOtherPredicates);
            this.topRelations = Collections.unmodifiableMap(privateTopRelations);
            this.otherPredicates = Collections.unmodifiableSet(privateOtherPredicates);
            Expression expr = this.exprStack.peek();
            if (expr != null) {
                expr.gatherExpressions(0, this.predicateManager);
            }
        }
    }

    public void build() {
        this.gatherExpressions();
    }

    public Map<FieldPath, List<NaryOperator>> getTopRelations() {
        this.gatherExpressions();
        return this.topRelations;
    }

    public Set<Expression> getOtherPredicates() {
        this.gatherExpressions();
        return this.otherPredicates;
    }

    public void operator(QueryCondition.Op op, int nOperands, ConditionNode originalNode) {
        this.operator((String)OjaiQuery.OP_TO_NAME.get((Object)op), nOperands, originalNode);
    }

    public void operator(String name, int nOperands, ConditionNode originalNode) {
        if (nOperands < 1) {
            throw new IllegalArgumentException("Operators must have at least one operand");
        }
        boolean logicalOperator = NaryOperator.isLogicalOperator(name);
        if (nOperands == 1 && !logicalOperator) {
            if (this.exprStack.size() < 1) {
                throw new IllegalStateException("No operands on stack for unary operator");
            }
            Expression operand = this.exprStack.pop();
            UnaryOperator unOp = new UnaryOperator(name, operand, originalNode);
            this.exprStack.push(unOp);
            return;
        }
        if (this.exprStack.size() < nOperands) {
            throw new IllegalStateException("Insufficient operands on stack");
        }
        LinkedList<Expression> operandList = new LinkedList<Expression>();
        if (!logicalOperator) {
            for (int i = 0; i < nOperands; ++i) {
                operandList.addFirst(this.exprStack.pop());
            }
            if (name.equals("elementAnd")) {
                if (nOperands < 2) {
                    throw new IllegalArgumentException("The elementAnd operator must have at least two operands");
                }
                ElementOperator elementOp = new ElementOperator(name, operandList, originalNode);
                this.exprStack.push(elementOp);
                return;
            }
            String inverseOp = null;
            if (operandList.size() == 2 && (inverseOp = NaryOperator.getInverseOperator(name)) != null) {
                Expression rightExpr = operandList.get(1);
                if (rightExpr instanceof FieldExpression) {
                    operandList.set(1, operandList.get(0));
                    operandList.set(0, rightExpr);
                    name = inverseOp;
                }
                RelationalOperator rOp = new RelationalOperator(name, operandList, originalNode);
                this.exprStack.push(rOp);
                return;
            }
        } else {
            for (int i = 0; i < nOperands; ++i) {
                Expression expr = this.exprStack.pop();
                if (expr instanceof NaryOperator) {
                    NaryOperator naryOp = (NaryOperator)expr;
                    if (naryOp.opName.equals(name)) {
                        for (int ni = naryOp.arg.length - 1; ni >= 0; --ni) {
                            operandList.addFirst(naryOp.arg[ni]);
                        }
                        continue;
                    }
                }
                operandList.addFirst(expr);
            }
        }
        if (operandList.size() > 1) {
            NaryOperator nOp = new NaryOperator(name, false, operandList, originalNode);
            this.exprStack.push(nOp);
        } else {
            this.exprStack.push((Expression)operandList.get(0));
        }
    }

    public void field(FieldPath leafPath, FieldPath fullPath, boolean isBlock) {
        this.exprStack.push(new FieldExpression(leafPath));
    }

    public void arrayLiteral(List<Object> value) {
        this.exprStack.push(new LiteralExpression(value));
    }

    public void binaryLiteral(ByteBuffer value) {
        this.exprStack.push(new LiteralExpression(value));
    }

    public void booleanLiteral(boolean value) {
        this.exprStack.push(new LiteralExpression(value));
    }

    public void byteLiteral(byte value) {
        this.exprStack.push(new LiteralExpression(value));
    }

    public void dateLiteral(ODate value) {
        this.exprStack.push(new LiteralExpression(value));
    }

    public void decimalLiteral(BigDecimal value) {
        throw new RuntimeException("unimplemented");
    }

    public void doubleLiteral(double value) {
        this.exprStack.push(new LiteralExpression(value));
    }

    public void floatLiteral(float value) {
        this.exprStack.push(new LiteralExpression(value));
    }

    public void intLiteral(int value) {
        this.exprStack.push(new LiteralExpression(value));
    }

    public void intervalLiteral(OInterval value) {
        this.exprStack.push(new LiteralExpression(value));
    }

    public void longLiteral(long value) {
        this.exprStack.push(new LiteralExpression(value));
    }

    public void mapLiteral(Map<String, Object> value) {
        this.exprStack.push(new LiteralExpression(value));
    }

    public void nullLiteral() {
        this.exprStack.push(new LiteralExpression());
    }

    public void shortLiteral(short value) {
        this.exprStack.push(new LiteralExpression(value));
    }

    public void stringLiteral(String value) {
        this.exprStack.push(new LiteralExpression(value));
    }

    public void timeLiteral(OTime value) {
        this.exprStack.push(new LiteralExpression(value));
    }

    public void timestampLiteral(OTimestamp value) {
        this.exprStack.push(new LiteralExpression(value));
    }

    static {
        HashSet<FieldPath> starProjection = new HashSet<FieldPath>();
        starProjection.add(FieldPath.parseFrom((String)"*"));
        starProjection.add(DocumentConstants.ID_FIELD);
        STAR_PROJECTION = Collections.unmodifiableSet(starProjection);
        ArrayList<Expression> operand = new ArrayList<Expression>(2);
        operand.add(new FieldExpression(DocumentConstants.ID_FIELD));
        operand.add(new LiteralExpression("0"));
        ID_EQUALS = new RelationalOperator("=", operand, null);
    }

    private static class PredicateFields
    implements PredicateManager {
        private final FieldPathStack fieldPathStack = new FieldPathStack();
        private final Map<FieldPath, List<NaryOperator>> topRelations;
        private final Set<Expression> otherPredicates;

        public PredicateFields(Map<FieldPath, List<NaryOperator>> topRelations, Set<Expression> otherPredicates) {
            this.topRelations = topRelations;
            this.otherPredicates = otherPredicates;
        }

        @Override
        public void addTopRelation(FieldPath fieldPath, NaryOperator nOp) {
            FieldPath newPath = this.fieldPathStack.getPath(fieldPath);
            List<NaryOperator> nOpList = this.topRelations.get(newPath);
            if (nOpList == null) {
                nOpList = new LinkedList<NaryOperator>();
                this.topRelations.put(newPath, nOpList);
            }
            nOpList.add(nOp);
        }

        @Override
        public void addOtherRelation(Expression expression) {
            this.otherPredicates.add(expression);
        }

        @Override
        public void pushPath(FieldPath fieldPath) {
            this.fieldPathStack.push(fieldPath);
        }

        @Override
        public void popPath() {
            this.fieldPathStack.pop();
        }
    }
}

