/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.db.impl.ConditionNode;
import com.mapr.ojai.store.impl.Expression;
import com.mapr.ojai.store.impl.ExpressionVisitor;
import com.mapr.ojai.store.impl.OperatorExpression;

public class UnaryOperator
extends OperatorExpression {
    Expression operand;

    public UnaryOperator(String opName, Expression operand, ConditionNode originalNode) {
        super(opName, originalNode);
        this.operand = operand;
    }

    public Expression getOperand() {
        return this.operand;
    }

    @Override
    public void emitSql(StringBuilder sb, String tableAlias) {
        sb.append(this.opName);
        sb.append('(');
        this.operand.emitSql(sb, tableAlias);
        sb.append(')');
    }

    @Override
    public boolean structuralEquals(Expression e) {
        if (!(e instanceof UnaryOperator)) {
            return false;
        }
        UnaryOperator other = (UnaryOperator)e;
        return this.opName.equals(other.opName) && this.operand.structuralEquals(other.operand);
    }

    @Override
    public int structuralHashCode() {
        return this.opName.hashCode() ^ this.operand.structuralHashCode();
    }

    @Override
    public void visit(ExpressionVisitor ev) {
        ev.visitUnary(this);
    }
}

