/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.base.Preconditions;
import com.mapr.db.impl.OjaiQueryProperties;
import com.mapr.ojai.store.impl.AbstractDocumentFilter;
import com.mapr.ojai.store.impl.ContinuationListener;
import com.mapr.ojai.store.impl.DrillDocumentStream;
import com.mapr.ojai.store.impl.OjaiConnection;
import com.mapr.ojai.store.impl.QueryContext;
import com.mapr.ojai.store.impl.SharedDrillSession;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.exceptions.OjaiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillPostludeFilter
extends AbstractDocumentFilter {
    private static final Logger logger = LoggerFactory.getLogger(DrillPostludeFilter.class);
    private final OjaiConnection ojaiConnection;
    private final String sql;
    private final SharedDrillSession sharedDrillSession;
    private volatile DrillDocumentStream drillStream;
    private static final AtomicInteger idGenerator = new AtomicInteger(0);
    private final int id = idGenerator.addAndGet(1);

    public DrillPostludeFilter(DocumentStream upstreamStream, OjaiConnection ojaiConnection, SharedDrillSession sharedDrillSession, String sql) {
        super(upstreamStream);
        Preconditions.checkArgument((sql != null ? 1 : 0) != 0);
        Preconditions.checkArgument((sharedDrillSession != null ? 1 : 0) != 0);
        this.ojaiConnection = ojaiConnection;
        this.sql = sql;
        this.sharedDrillSession = sharedDrillSession;
        sharedDrillSession.addRef();
    }

    private void privateClose() {
        this.drillStream.close();
        this.sharedDrillSession.close();
    }

    @Override
    public Iterator<Document> iterator() {
        return new PostludeIterator(super.iterator());
    }

    public void getQueryPlan(List<Map<String, Object>> planList) {
        if (this.upstreamStream == null) {
            return;
        }
        ((OjaiQueryProperties)this.upstreamStream).getQueryPlan(planList);
        HashMap<String, Object> myMap = new HashMap<String, Object>();
        myMap.put("streamName", this.getClass().getSimpleName());
        HashMap<String, String> valueMap = new HashMap<String, String>();
        valueMap.put("sql", this.sql);
        myMap.put("parameters", valueMap);
        planList.add(myMap);
    }

    private class PostludeIterator
    implements Iterator<Document> {
        private final Iterator<Document> superIter;
        private boolean triggered;
        private Exception failedException;

        public PostludeIterator(Iterator<Document> superIter) {
            this.superIter = superIter;
        }

        private void checkTrigger() {
            if (!this.triggered) {
                logger.debug("Postlude trigger " + DrillPostludeFilter.this.id + " begin " + DrillPostludeFilter.this.sql);
                CountDownLatch continuationLatch = new CountDownLatch(1);
                QueryContext queryContext = QueryContext.newBuilder(DrillPostludeFilter.this.sql).build();
                DrillPostludeFilter.this.drillStream = new DrillDocumentStream(DrillPostludeFilter.this.ojaiConnection, queryContext, DrillPostludeFilter.this.sharedDrillSession);
                DrillPostludeFilter.this.drillStream.streamTo(new ContinuationListener(continuationLatch){

                    @Override
                    public void failed(Exception ex) {
                        PostludeIterator.this.failedException = ex;
                        super.failed(ex);
                    }
                });
                try {
                    continuationLatch.await();
                }
                catch (InterruptedException iex) {
                    throw new OjaiException((Throwable)iex);
                }
                if (this.failedException != null) {
                    throw new OjaiException((Throwable)this.failedException);
                }
                DrillPostludeFilter.this.privateClose();
                this.triggered = true;
                logger.debug("Postlude completed " + DrillPostludeFilter.this.id);
            }
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = this.superIter.hasNext();
            if (!hasNext) {
                this.checkTrigger();
            }
            return hasNext;
        }

        @Override
        public Document next() {
            this.hasNext();
            return this.superIter.next();
        }
    }
}

