/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.collect.ImmutableList;
import com.mapr.db.impl.BaseJsonTable;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.index.IndexDesc;
import com.mapr.db.index.IndexFieldDesc;
import com.mapr.fs.proto.Dbserver;
import java.util.Collection;
import java.util.List;
import org.ojai.DocumentConstants;
import org.ojai.FieldPath;
import org.ojai.json.JsonOptions;

public class IdIndexDesc
implements IndexDesc {
    private final String primaryTablePath;
    private final String indexFid;
    private final String indexName;
    public static final IndexFieldDesc ID_INDEX_FIELD_DESC = new IdIndexFieldDesc();
    private static final ImmutableList<IndexFieldDesc> idIndexFieldList;
    private static final ImmutableList<IndexFieldDesc> emptyFieldList;

    public IdIndexDesc(BaseJsonTable table) {
        this.primaryTablePath = table.getName();
        this.indexFid = table.getFidStr();
        this.indexName = this.primaryTablePath.substring(this.primaryTablePath.lastIndexOf(47) + 1);
    }

    public static boolean isIdIndex(IndexDesc indexDesc) {
        return indexDesc instanceof IdIndexDesc;
    }

    public String asJsonString() {
        return this.asJsonString(JsonOptions.DEFAULT);
    }

    public String asJsonString(JsonOptions jsonOptions) {
        return MapRDBImpl.newDocument((Object)this).asJsonString(jsonOptions);
    }

    public List<IndexFieldDesc> getIndexedFields() {
        return idIndexFieldList;
    }

    public Collection<IndexFieldDesc> getIncludedFields() {
        return emptyFieldList;
    }

    public boolean isHashed() {
        return false;
    }

    public boolean isUnique() {
        return true;
    }

    public boolean isExternal() {
        return false;
    }

    public boolean isDisabled() {
        return false;
    }

    public String getPrimaryTablePath() {
        return this.primaryTablePath;
    }

    public String getIndexFid() {
        return this.indexFid;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getSystem() {
        return "maprdb";
    }

    public String getCluster() {
        return null;
    }

    public String getConnectionString() {
        return null;
    }

    public int getNumHashPartitions() {
        return 0;
    }

    public Dbserver.SIndexInfo getIndexInfo() {
        throw new UnsupportedOperationException();
    }

    public Dbserver.SIndexInfo.Version getIndexVersion() {
        return Dbserver.SIndexInfo.Version.v6dot1;
    }

    public boolean isFullIndex() {
        return true;
    }

    public boolean isArrayIndex() {
        return false;
    }

    public IndexDesc.MissingAndNullOrdering getMissingAndNullOrdering() {
        return IndexDesc.MissingAndNullOrdering.MissingAndNullLast;
    }

    static {
        ImmutableList.Builder builder = ImmutableList.builder();
        idIndexFieldList = builder.add((Object)ID_INDEX_FIELD_DESC).build();
        builder = ImmutableList.builder();
        emptyFieldList = builder.build();
    }

    private static class IdIndexFieldDesc
    implements IndexFieldDesc {
        private IdIndexFieldDesc() {
        }

        public String asJsonString() {
            throw new UnsupportedOperationException();
        }

        public String asJsonString(JsonOptions arg0) {
            throw new UnsupportedOperationException();
        }

        public FieldPath getFieldPath() {
            return DocumentConstants.ID_FIELD;
        }

        public IndexFieldDesc.Order getSortOrder() {
            return IndexFieldDesc.Order.Asc;
        }

        public boolean isFunctional() {
            return false;
        }

        public String getFunctionName() {
            return null;
        }

        public boolean isOnMTime() {
            return false;
        }
    }
}

