/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.db.impl.OjaiQueryProperties;
import com.mapr.ojai.store.impl.DrillDocumentStream;
import com.mapr.ojai.store.impl.OjaiConnection;
import com.mapr.ojai.store.impl.OjaiTest;
import com.mapr.ojai.store.impl.QueryContext;
import com.mapr.ojai.store.impl.SharedTestTable;
import com.mapr.ojai.store.impl.SharedTestTableLoader;
import com.mapr.tests.annotations.ClusterTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.store.Connection;
import org.ojai.store.DocumentStore;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;
import org.ojai.store.QueryResult;

@Category(value={ClusterTest.class})
public class TestOjaiQuerySql
extends OjaiTest {
    private static final SharedTestTable sharedTableSqlData1 = new SharedTestTableLoader("testOjaiQuerySqlData1");
    private static final SharedTestTable sharedTableSqlData2 = new SharedTestTableLoader("testOjaiQuerySqlData2");
    private static final SharedTestTable sharedTableSqlData3 = new SharedTestTableLoader("testOjaiQuerySqlData3");
    private static final SharedTestTable sharedTableSqlData4 = new SharedTestTableLoader("testOjaiQuerySqlData4");

    private static void runRawSqlFile(Connection connection, String fileName, String tableName) throws Exception {
        String sql = OjaiTest.loadString(fileName, tableName);
        QueryContext queryContext = QueryContext.newBuilder((String)sql).build();
        try (DrillDocumentStream ods = new DrillDocumentStream((OjaiConnection)connection, queryContext);){
            int count = 0;
            for (Document doc : ods) {
                String id = doc.getIdString();
                ++count;
            }
            Assert.assertEquals((long)1L, (long)count);
        }
    }

    @Test
    public void testQuery_rawSql_smoke() throws Exception {
        try (OjaiConnection connection = TestOjaiQuerySql.getConnection();){
            String tableName1 = sharedTableSqlData1.prepare((Connection)connection);
            TestOjaiQuerySql.runRawSqlFile((Connection)connection, "testOjaiQuerySql1", tableName1);
            TestOjaiQuerySql.runRawSqlFile((Connection)connection, "testOjaiQuerySql2", tableName1);
            String tableName4 = sharedTableSqlData4.prepare((Connection)connection);
            TestOjaiQuerySql.runRawSqlFile((Connection)connection, "testOjaiQuerySql4", tableName4);
        }
    }

    private static void simpleDrillCheck(DocumentStore docStore, Query query) {
        try (QueryResult docStream = docStore.find(query);){
            int count = 0;
            for (Document doc : docStream) {
                String id = doc.getIdString();
                Assert.assertNotNull((Object)id);
                ++count;
            }
            Assert.assertEquals((long)1L, (long)count);
            Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DRILL, (Object)TestOjaiQuerySql.getQueryPath((DocumentStream)docStream));
        }
    }

    @Test
    public void testQuery_basicElementAnd() {
        try (OjaiConnection connection = TestOjaiQuerySql.getConnection();){
            String tableName = sharedTableSqlData1.prepare((Connection)connection);
            QueryCondition cond = connection.newCondition().elementAnd("foo[]").is("a", QueryCondition.Op.LESS, 10).is("b", QueryCondition.Op.GREATER, 8).close().build();
            try (DocumentStore docStore = connection.getStore(tableName);){
                Query query = connection.newQuery().setOption("ojai.mapr.query.force-drill", (Object)true).where(cond).build();
                TestOjaiQuerySql.simpleDrillCheck(docStore, query);
            }
        }
    }

    @Test
    public void testQuery_basicArray() {
        try (OjaiConnection connection = TestOjaiQuerySql.getConnection();){
            String tableName = sharedTableSqlData2.prepare((Connection)connection);
            QueryCondition cond = connection.newCondition().is("foo[]", QueryCondition.Op.LESS, 10).build();
            try (DocumentStore docStore = connection.getStore(tableName);){
                Query query = connection.newQuery().setOption("ojai.mapr.query.force-drill", (Object)true).where(cond).build();
                TestOjaiQuerySql.simpleDrillCheck(docStore, query);
            }
        }
    }

    @Test
    public void testQuery_basicArrayAnd() {
        try (OjaiConnection connection = TestOjaiQuerySql.getConnection();){
            String tableName = sharedTableSqlData1.prepare((Connection)connection);
            QueryCondition cond = connection.newCondition().and().is("foo[].a", QueryCondition.Op.LESS, 10).is("foo[].b", QueryCondition.Op.GREATER, 8).close().build();
            try (DocumentStore docStore = connection.getStore(tableName);){
                Query query = connection.newQuery().setOption("ojai.mapr.query.force-drill", (Object)true).where(cond).build();
                TestOjaiQuerySql.simpleDrillCheck(docStore, query);
            }
        }
    }

    @Test
    public void testQuery_basicArrayOr() {
        try (OjaiConnection connection = TestOjaiQuerySql.getConnection();){
            String tableName = sharedTableSqlData1.prepare((Connection)connection);
            QueryCondition cond = connection.newCondition().or().is("foo[].a", QueryCondition.Op.EQUAL, 5).is("foo[].b", QueryCondition.Op.GREATER, 11).close().build();
            try (DocumentStore docStore = connection.getStore(tableName);){
                Query query = connection.newQuery().setOption("ojai.mapr.query.force-drill", (Object)true).where(cond).build();
                TestOjaiQuerySql.simpleDrillCheck(docStore, query);
            }
        }
    }

    @Test
    public void testQuery_basicArrayAndOr() {
        try (OjaiConnection connection = TestOjaiQuerySql.getConnection();){
            String tableName = sharedTableSqlData1.prepare((Connection)connection);
            QueryCondition cond = connection.newCondition().and().is("foo[].a", QueryCondition.Op.EQUAL, 5).or().is("foo[].b", QueryCondition.Op.EQUAL, 5).is("foo[].b", QueryCondition.Op.EQUAL, 10).close().close().build();
            try (DocumentStore docStore = connection.getStore(tableName);){
                Query query = connection.newQuery().setOption("ojai.mapr.query.force-drill", (Object)true).where(cond).build();
                TestOjaiQuerySql.simpleDrillCheck(docStore, query);
            }
        }
    }

    @Test
    public void testQuery_elementAnd_nestedCond() {
        try (OjaiConnection connection = TestOjaiQuerySql.getConnection();){
            String tableName = sharedTableSqlData3.prepare((Connection)connection);
            QueryCondition cond = connection.newCondition().elementAnd("foo[]").is("a", QueryCondition.Op.EQUAL, 5).or().is("c", QueryCondition.Op.EQUAL, 7).is("d", QueryCondition.Op.EQUAL, 10).close().close().build();
            try (DocumentStore docStore = connection.getStore(tableName);){
                Query query = connection.newQuery().setOption("ojai.mapr.query.force-drill", (Object)true).where(cond).build();
                TestOjaiQuerySql.simpleDrillCheck(docStore, query);
            }
        }
    }

    @Test
    public void testQuery_elementAnd_multiDimensional() {
        try (OjaiConnection connection = TestOjaiQuerySql.getConnection();){
            String tableName = sharedTableSqlData4.prepare((Connection)connection);
            QueryCondition cond = connection.newCondition().elementAnd("foo[].t[]").is("a", QueryCondition.Op.EQUAL, 42).is("b", QueryCondition.Op.EQUAL, 17).close().build();
            try (DocumentStore docStore = connection.getStore(tableName);){
                Query query = connection.newQuery().setOption("ojai.mapr.query.force-drill", (Object)true).where(cond).build();
                TestOjaiQuerySql.simpleDrillCheck(docStore, query);
            }
        }
    }
}

