/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.utils;

import com.mapr.utils.ByteReader;

public final class Crypto {
    private static final long FNV_offset_basis_64 = -3750763034362895579L;
    private static final long FNV_prime_64 = 1099511628211L;
    private static final int FNV_offset_basis_32 = -2128831035;
    private static final int FNV_prime_32 = 16777619;

    public static int fnvHash32(int val) {
        int hashval = -2128831035;
        for (int i = 0; i < 4; ++i) {
            int octet = val & 0xFF;
            val >>= 8;
            hashval ^= octet;
            hashval *= 16777619;
        }
        return Math.abs(hashval);
    }

    public static long fnvHash64(long val) {
        long hashval = -3750763034362895579L;
        for (int i = 0; i < 8; ++i) {
            long octet = val & 0xFFL;
            val >>= 8;
            hashval ^= octet;
            hashval *= 1099511628211L;
        }
        return Math.abs(hashval);
    }

    public static byte computeXor(byte[] buf) {
        byte b = 0;
        int len = buf.length;
        for (int i = 0; i < len; ++i) {
            b = (byte)(b ^ buf[i]);
        }
        return b;
    }

    public static byte computeXor(ByteReader buf) {
        buf.mark();
        int mlen = buf.length();
        byte b = 0;
        for (int i = 0; i < mlen; ++i) {
            b = (byte)(b ^ buf.nextUnsafe());
        }
        buf.reset();
        return b;
    }

    public static int computeXorCrc32Unalign(ByteReader buf) {
        buf.mark();
        int crc = 0;
        int index = 0;
        int len = buf.length();
        int k = len / 4;
        int bytesLeft = len % 4;
        if (bytesLeft != 0) {
            int off = len - bytesLeft;
            crc ^= buf.getByte(index + off);
            ++off;
            if (--bytesLeft != 0) {
                crc ^= buf.getByte(index + off) << 8;
                ++off;
                if (--bytesLeft != 0) {
                    crc |= buf.getByte(index + off) << 16;
                }
            }
        }
        if (k != 0) {
            crc ^= Crypto.compute(buf, index, k * 4);
        }
        buf.reset();
        return crc;
    }

    private static int compute(ByteReader buf, int idx, int size) {
        int crc = 0;
        long crc64 = 0L;
        int len = size;
        int data = buf.getInt(idx);
        int index = idx;
        if ((long)index % 8L != 0L) {
            crc = data;
            index += 4;
            len -= 4;
        }
        int left = len % 8;
        int index64 = index;
        for (int count8 = len / 8; count8 > 0; --count8) {
            long data64 = buf.getLong(index64);
            crc64 ^= data64;
            index64 += 8;
        }
        if (crc64 != 0L) {
            int lsb = (int)crc64;
            int msb = (int)(crc64 >>> 32);
            crc ^= lsb ^ msb;
        }
        if (left != 0) {
            int val = buf.getInt(index64);
            crc ^= val;
        }
        return crc;
    }
}

