/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.org.apache.hadoop.hbase.util;

import com.mapr.org.apache.hadoop.hbase.util.ByteRange;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;

public abstract class AbstractByteRange
implements ByteRange {
    public static final int UNSET_HASH_VALUE = -1;
    protected byte[] bytes;
    protected int offset;
    protected int length;
    protected int hash = -1;

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public abstract ByteRange unset();

    @Override
    public ByteRange set(int capacity) {
        return this.set(new byte[capacity]);
    }

    @Override
    public ByteRange set(byte[] bytes) {
        if (null == bytes) {
            return this.unset();
        }
        this.clearHashCache();
        this.bytes = bytes;
        this.offset = 0;
        this.length = bytes.length;
        return this;
    }

    @Override
    public ByteRange set(byte[] bytes, int offset, int length) {
        if (null == bytes) {
            return this.unset();
        }
        this.clearHashCache();
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
        return this;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public ByteRange setOffset(int offset) {
        this.clearHashCache();
        this.offset = offset;
        return this;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public ByteRange setLength(int length) {
        this.clearHashCache();
        this.length = length;
        return this;
    }

    @Override
    public boolean isEmpty() {
        return AbstractByteRange.isEmpty(this);
    }

    public static boolean isEmpty(ByteRange range) {
        return range == null || range.getLength() == 0;
    }

    @Override
    public byte get(int index) {
        return this.bytes[this.offset + index];
    }

    @Override
    public ByteRange get(int index, byte[] dst) {
        if (0 == dst.length) {
            return this;
        }
        return this.get(index, dst, 0, dst.length);
    }

    @Override
    public ByteRange get(int index, byte[] dst, int offset, int length) {
        if (0 == length) {
            return this;
        }
        System.arraycopy(this.bytes, this.offset + index, dst, offset, length);
        return this;
    }

    @Override
    public short getShort(int index) {
        int offset = this.offset + index;
        short n = 0;
        n = (short)(n ^ this.bytes[offset] & 0xFF);
        n = (short)(n << 8);
        n = (short)(n ^ this.bytes[offset + 1] & 0xFF);
        return n;
    }

    @Override
    public int getInt(int index) {
        int offset = this.offset + index;
        int n = 0;
        for (int i = offset; i < offset + 4; ++i) {
            n <<= 8;
            n ^= this.bytes[i] & 0xFF;
        }
        return n;
    }

    @Override
    public long getLong(int index) {
        int offset = this.offset + index;
        long l = 0L;
        for (int i = offset; i < offset + 8; ++i) {
            l <<= 8;
            l ^= (long)(this.bytes[i] & 0xFF);
        }
        return l;
    }

    @Override
    public long getVLong(int index) {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = this.get(index++);
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) == 0) break;
        }
        return result;
    }

    public static int getVLongSize(long val) {
        int rPos = 0;
        while ((val & 0xFFFFFFFFFFFFFF80L) != 0L) {
            val >>>= 7;
            ++rPos;
        }
        return rPos + 1;
    }

    @Override
    public abstract ByteRange put(int var1, byte var2);

    @Override
    public abstract ByteRange put(int var1, byte[] var2);

    @Override
    public abstract ByteRange put(int var1, byte[] var2, int var3, int var4);

    @Override
    public abstract ByteRange putInt(int var1, int var2);

    @Override
    public abstract ByteRange putLong(int var1, long var2);

    @Override
    public abstract ByteRange putShort(int var1, short var2);

    @Override
    public abstract int putVLong(int var1, long var2);

    @Override
    public byte[] deepCopyToNewArray() {
        byte[] result = new byte[this.length];
        System.arraycopy(this.bytes, this.offset, result, 0, this.length);
        return result;
    }

    @Override
    public void deepCopyTo(byte[] destination, int destinationOffset) {
        System.arraycopy(this.bytes, this.offset, destination, destinationOffset, this.length);
    }

    @Override
    public void deepCopySubRangeTo(int innerOffset, int copyLength, byte[] destination, int destinationOffset) {
        System.arraycopy(this.bytes, this.offset + innerOffset, destination, destinationOffset, copyLength);
    }

    public int hashCode() {
        if (this.isHashCached()) {
            return this.hash;
        }
        if (this.isEmpty()) {
            this.hash = 0;
            return this.hash;
        }
        int off = this.offset;
        this.hash = 0;
        for (int i = 0; i < this.length; ++i) {
            this.hash = 31 * this.hash + this.bytes[off++];
        }
        return this.hash;
    }

    protected boolean isHashCached() {
        return this.hash != -1;
    }

    protected void clearHashCache() {
        this.hash = -1;
    }

    @Override
    public int compareTo(ByteRange other) {
        return Bytes.compareTo(this.bytes, this.offset, this.length, other.getBytes(), other.getOffset(), other.getLength());
    }

    public String toString() {
        return Bytes.toStringBinary(this.bytes, this.offset, this.length);
    }
}

