/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.config;

import com.mapr.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypesafeConfig
implements Config {
    private static final Logger log = LoggerFactory.getLogger(TypesafeConfig.class);
    private final com.typesafe.config.Config conf;

    public TypesafeConfig() {
        this.conf = ConfigFactory.load();
    }

    public TypesafeConfig(String resourceBasename) {
        this.conf = ConfigFactory.load((String)resourceBasename);
    }

    @Override
    public List<?> getList(String confKey) {
        return this.getConfigValue(confKey, null);
    }

    @Override
    public Integer getInt(String confKey, Integer defaultValue) {
        return this.getConfigValue(confKey, defaultValue);
    }

    @Override
    public String getString(String confKey, String defaultValue) {
        return this.getConfigValue(confKey, defaultValue);
    }

    @Override
    public Boolean getBoolean(String confKey, Boolean defaultValue) {
        return this.getConfigValue(confKey, defaultValue);
    }

    private <T> T getConfigValue(String confKey, T defaultValue) {
        try {
            return (T)this.conf.getValue(confKey).unwrapped();
        }
        catch (ConfigException.Missing e) {
            log.debug("A configuration value for '{}' wasn't found, using default value {}.", (Object)confKey, defaultValue);
            return defaultValue;
        }
    }
}

