/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.jmxagent;

import com.mapr.web.security.SslConfig;
import com.mapr.web.security.WebSecurityManager;
import com.sun.jmx.remote.security.JMXPluggableAuthenticator;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.rmi.registry.LocateRegistry;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;

public class MapRJMXAgent {
    public static void premain(String args, Instrumentation inst) throws Exception {
        System.setProperty("java.rmi.server.randomIDs", "true");
        int port = MapRJMXAgent.getPort();
        System.out.println("Create RMI registry on port " + port);
        LocateRegistry.createRegistry(port);
        System.out.println("Get the platform's MBean server");
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        System.out.println("Initialize the environment map");
        HashMap<String, Object> env = new HashMap<String, Object>();
        System.setProperty("javax.net.ssl.keyStore", MapRJMXAgent.getKeystoreLocation());
        System.setProperty("javax.net.ssl.keyStorePassword", MapRJMXAgent.getKeystorePassword());
        SslRMIClientSocketFactory csf = new SslRMIClientSocketFactory();
        SslRMIServerSocketFactory ssf = new SslRMIServerSocketFactory();
        env.put("jmx.remote.rmi.client.socket.factory", csf);
        env.put("jmx.remote.rmi.server.socket.factory", ssf);
        env.put("jmx.remote.x.access.file", MapRJMXAgent.getAccessFileLocation());
        env.put("jmx.remote.x.login.config", MapRJMXAgent.getLoginConfig());
        env.put("jmx.remote.x.authenticate", true);
        System.out.println("Create an RMI connector server");
        JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://:" + port + "/jmxrmi");
        JMXConnectorServer cs = JMXConnectorServerFactory.newJMXConnectorServer(url, env, mbs);
        System.out.println("Start the RMI connector server");
        cs.start();
    }

    public static int getPort() throws Exception {
        String port = System.getProperty("mapr.jmx.agent.port");
        if (port == null) {
            throw new Exception("mapr.jmx.agent.port shoud be specified");
        }
        return Integer.parseInt(port);
    }

    public static String getKeystoreLocation() {
        try (SslConfig sslConfig = WebSecurityManager.getSslConfig((SslConfig.SslConfigScope)SslConfig.SslConfigScope.SCOPE_ALL);){
            String string = sslConfig.getClientKeystoreLocation();
            return string;
        }
    }

    public static String getKeystorePassword() {
        try (SslConfig sslConfig = WebSecurityManager.getSslConfig((SslConfig.SslConfigScope)SslConfig.SslConfigScope.SCOPE_ALL);){
            String string = new String(sslConfig.getClientKeystorePassword());
            return string;
        }
    }

    public static String getLoginConfig() throws Exception {
        String loginConfigFile = System.getProperty("java.security.auth.login.config");
        if (loginConfigFile == null) {
            throw new Exception("java.security.auth.login.config shoud be specified");
        }
        String loginConfig = System.getProperty("mapr.jmx.agent.login.config");
        if (loginConfig == null) {
            throw new Exception("mapr.jmx.agent.login.config shoud be specified");
        }
        return loginConfig;
    }

    public static Object getAuthenticator(HashMap<String, Object> env) {
        return new JMXPluggableAuthenticator(env);
    }

    public static String getAccessFileLocation() {
        return "/opt/mapr/conf/jmxremote.access";
    }
}

