/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.jmxagent;

import java.io.IOException;
import java.util.Map;
import javax.management.remote.JMXPrincipal;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import net.sf.jpam.Pam;
import net.sf.jpam.PamReturnValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JpamJMXLoginModule
implements LoginModule {
    private static final Log LOG = LogFactory.getLog((String)JpamJMXLoginModule.class.getName());
    private static final String SERVICE_NAME_OPTION = "serviceName";
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private Pam pam;
    private JMXPrincipal user;

    @Override
    public boolean abort() throws LoginException {
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.subject.getPrincipals().contains(this.user)) {
            this.subject.getPrincipals().add(this.user);
        }
        return true;
    }

    @Override
    public boolean login() throws LoginException {
        this.pam = this.createPam();
        Callback[] callbacks = new Callback[2];
        String username = null;
        NameCallback nameCallback = new NameCallback("Enter Username: ");
        callbacks[0] = nameCallback;
        String credentials = null;
        PasswordCallback passwordCallback = new PasswordCallback("Enter Credentials: ", false);
        callbacks[1] = passwordCallback;
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException e) {
            LOG.error((Object)("IOException handling login: " + e.getMessage()), (Throwable)e);
            throw new LoginException(e.getMessage());
        }
        catch (UnsupportedCallbackException e) {
            LOG.error((Object)("UnsupportedCallbackException handling login: " + e.getMessage()), (Throwable)e);
            throw new LoginException(e.getMessage());
        }
        username = nameCallback.getName();
        credentials = String.copyValueOf(passwordCallback.getPassword());
        boolean authenticated = false;
        PamReturnValue pamReturnValue = this.pam.authenticate(username, credentials);
        if (!pamReturnValue.equals((Object)PamReturnValue.PAM_SUCCESS)) {
            if (pamReturnValue.equals((Object)PamReturnValue.PAM_ACCT_EXPIRED)) {
                throw new AccountExpiredException(PamReturnValue.PAM_ACCT_EXPIRED.toString());
            }
            if (pamReturnValue.equals((Object)PamReturnValue.PAM_CRED_EXPIRED)) {
                throw new CredentialExpiredException(PamReturnValue.PAM_CRED_EXPIRED.toString());
            }
            throw new FailedLoginException(pamReturnValue.toString());
        }
        authenticated = true;
        this.user = new JMXPrincipal(username);
        return authenticated;
    }

    private Pam createPam() {
        String serviceName = (String)this.options.get(SERVICE_NAME_OPTION);
        if (serviceName == null) {
            LOG.debug((Object)"No serviceName configured in JAAS configuration file. Using default service name of net-sf-jpam");
            serviceName = "net-sf-jpam";
        } else {
            LOG.debug((Object)("Using service name of " + serviceName + " from JAAS configuration file"));
        }
        Pam pam = new Pam(serviceName);
        return pam;
    }

    @Override
    public boolean logout() throws LoginException {
        return true;
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
    }

    public Pam getPam() {
        return this.pam;
    }
}

