/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class SrivasDirTest {
    public static void main(String[] args) throws Exception {
        int ac = 0;
        if (args.length < 4) {
            System.out.println("usage: dirtest myidx dirname numDirEnts fileSize");
            return;
        }
        int myidx = Integer.parseInt(args[ac++]);
        String uri = "maprfs:///";
        String dirname = args[ac++];
        Configuration conf = new Configuration();
        conf.set("fs.default.name", uri);
        conf.set("fs.maprfs.impl", "com.mapr.fs.MapRFileSystem");
        FileSystem fs = FileSystem.get((URI)URI.create(uri), (Configuration)conf);
        Path topLevelPath = new Path(dirname);
        boolean res = fs.mkdirs(topLevelPath);
        int numdirs = Integer.parseInt(args[ac++]);
        long sT = System.currentTimeMillis();
        int fileSize = Integer.parseInt(args[ac++]);
        String dname = dirname + "/f." + myidx + ".";
        int numEntsPerDir = 1;
        byte[] buf = new byte[fileSize];
        for (int i = 0; i < numdirs; i += numEntsPerDir) {
            String parent = dname + i;
            FSDataOutputStream os = fs.create(new Path(parent), true, 512, (short)1, 0x4000000L);
            os.write(buf);
            os.close();
            if (numEntsPerDir == 1) continue;
            for (int j = 0; j < numEntsPerDir; ++j) {
                String child = parent + "/ent." + j;
                res = fs.mkdirs(new Path(child));
                if (res) continue;
                System.out.println("mkdir failed, path: " + child);
                return;
            }
        }
        long eT = System.currentTimeMillis();
        double rate = numdirs;
        rate *= 1000.0;
        System.out.println("Mkdir rate: " + (rate /= (double)(eT -= sT)) + " dirs/s");
    }
}

