/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.FilePattern;
import java.net.URI;
import java.util.LinkedList;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class RWTest {
    static int seq;
    static int cprsData;
    static int overWrite;
    static int align;
    static int trunc;
    static int nFiles;
    static int nOps;
    static int seed;
    static FileSystem fs;
    static String testDir;
    public static final String MAPRFS_URI = "maprfs://localhost:7222/";

    public static void Usage() {
        System.err.println("usage: RWTest seq/noseq cprsData/noCprsData overWrite/noOverWrite blockAlign/clusterAlign/noAlign trunc/noTrunc nFiles nOps seed testDir");
        System.exit(1);
    }

    public static void ParseArgs(String[] args) {
        int ac;
        int expectedArgs = 9;
        if (args.length != expectedArgs) {
            System.err.println("Expecting " + expectedArgs + " args");
            RWTest.Usage();
        }
        if (args[ac = 0].compareToIgnoreCase("seq") == 0) {
            seq = 1;
        } else if (args[ac].compareToIgnoreCase("noseq") == 0) {
            seq = 0;
        } else {
            System.err.println("Unknown arg: " + args[ac]);
            RWTest.Usage();
        }
        if (args[++ac].compareToIgnoreCase("cprsData") == 0) {
            cprsData = 1;
        } else if (args[ac].compareToIgnoreCase("noCprsData") == 0) {
            cprsData = 0;
        } else {
            System.err.println("Unknown arg: " + args[ac]);
            RWTest.Usage();
        }
        if (args[++ac].compareToIgnoreCase("overWrite") == 0) {
            overWrite = 1;
        } else if (args[ac].compareToIgnoreCase("noOverWrite") == 0) {
            overWrite = 0;
        } else {
            System.err.println("Unknown arg: " + args[ac]);
            RWTest.Usage();
        }
        if (args[++ac].compareToIgnoreCase("blockAlign") == 0) {
            align = 1;
        } else if (args[ac].compareToIgnoreCase("clusterAlign") == 0) {
            align = 2;
        } else if (args[ac].compareToIgnoreCase("noAlign") == 0) {
            align = 0;
        } else {
            System.err.println("Unknown arg: " + args[ac]);
            RWTest.Usage();
        }
        if (args[++ac].compareToIgnoreCase("trunc") == 0) {
            trunc = 1;
        } else if (args[ac].compareToIgnoreCase("noTrunc") == 0) {
            trunc = 0;
        } else {
            System.err.println("Unknown arg: " + args[ac]);
            RWTest.Usage();
        }
        ++ac;
        try {
            nFiles = Integer.parseInt(args[ac].trim());
            nOps = Integer.parseInt(args[++ac].trim());
            seed = Integer.parseInt(args[++ac].trim());
            ++ac;
        }
        catch (NumberFormatException e) {
            System.err.println("Arg " + (ac + 1) + " should be a number");
            RWTest.Usage();
        }
        testDir = args[ac];
        ++ac;
    }

    public static void SetMaprFilesystemConfig() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.default.name", MAPRFS_URI);
        conf.set("dfs.replication", "1");
        conf.set("fs.maprfs.impl", "com.mapr.fs.MapRFileSystem");
        conf.set("io.file.buffer.size", "65536");
        fs = FileSystem.get((URI)URI.create(MAPRFS_URI), (Configuration)conf);
    }

    public static FSDataOutputStream CreateFile(String fileName) throws Exception {
        Path p = new Path(fileName);
        FSDataOutputStream out = fs.create(p);
        return out;
    }

    public static void FillBuffer(byte[] dest, String pattern, int count) {
        int i;
        for (i = 0; i < count / pattern.length(); ++i) {
            pattern.getBytes(0, pattern.length(), dest, i * pattern.length());
        }
        pattern.getBytes(0, count % pattern.length(), dest, i * pattern.length());
    }

    public static String GeneratePattern(long seed, int i) {
        String pattern = seed + testDir + "/RWtest" + i;
        return pattern;
    }

    public static boolean VerifyPattern(byte[] buf, int count, String pattern) {
        for (int i = 0; i < count; ++i) {
            if (buf[i] == pattern.charAt(i % pattern.length())) continue;
            return true;
        }
        return false;
    }

    public static void CleanupFiles() throws Exception {
        Path topLevelPath = new Path(testDir);
        System.out.println("Cleaning up the test files");
        fs.delete(topLevelPath, true);
    }

    public static void main(String[] args) throws Exception {
        int j;
        long offset;
        int i;
        RWTest.ParseArgs(args);
        RWTest.SetMaprFilesystemConfig();
        Random randomGen = new Random(seed);
        int BlocksPerCluster = 8;
        int BlockSize = 8192;
        int ClusterSize = BlockSize * BlocksPerCluster;
        byte[] buf = new byte[ClusterSize];
        LinkedList[] heads = new LinkedList[nFiles];
        int curOpCount = nOps;
        for (i = 0; i < nFiles; ++i) {
            int curOps = 0;
            String filePath = testDir + "/RWtest" + i;
            FSDataOutputStream out = RWTest.CreateFile(filePath);
            curOps = randomGen.nextInt(curOpCount);
            curOpCount -= curOps;
            System.out.println("Writing file: " + filePath + ": Ops:" + curOps);
            offset = 0L;
            heads[i] = new LinkedList();
            for (j = 0; j < curOps; ++j) {
                int count = randomGen.nextInt(ClusterSize);
                String pattern = new String();
                pattern = RWTest.GeneratePattern(seed, i);
                heads[i].add(new FilePattern(offset, count, pattern));
                RWTest.FillBuffer(buf, pattern, count);
                out.write(buf, 0, count);
                if (seq == 1) {
                    offset += (long)count;
                } else {
                    System.out.println("noseq is not yet supported");
                    RWTest.CleanupFiles();
                    System.exit(1);
                }
                if (curOps / 80 != 0 && j % (curOps / 80 + 1) != 0) continue;
                System.out.print(">");
            }
            out.close();
            System.out.println("");
        }
        for (i = 0; i < nFiles; ++i) {
            String filePath = testDir + "/RWtest" + i;
            Path p = new Path(filePath);
            FSDataInputStream in = fs.open(p);
            System.out.println("Reading file: " + filePath);
            offset = 0L;
            for (j = 0; j < heads[i].size(); ++j) {
                FilePattern fPattern = (FilePattern)heads[i].get(j);
                assert (offset == fPattern.offset);
                in.read(offset, buf, 0, fPattern.count);
                if (RWTest.VerifyPattern(buf, fPattern.count, fPattern.pattern)) {
                    System.out.println("data is mismatched for file/testRWtest" + i + " offset: " + fPattern.offset + " Count: " + fPattern.count);
                    RWTest.CleanupFiles();
                    System.exit(1);
                }
                if (seq == 1) {
                    offset += (long)fPattern.count;
                } else {
                    System.out.println("noseq is not yet supported");
                    RWTest.CleanupFiles();
                    System.exit(1);
                }
                if (heads[i].size() / 80 != 0 && j % (heads[i].size() / 80 + 1) != 0) continue;
                System.out.print(">");
            }
            in.close();
            System.out.println("");
        }
        RWTest.CleanupFiles();
        System.out.println("RWTests passed");
    }
}

